/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.terminal.ui;

import java.io.IOException;
import org.eclipse.dirigible.ide.repository.RepositoryGlobalPreferenceStore;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.jface.preference.BooleanFieldEditor;
import org.eclipse.jface.preference.FieldEditor;
import org.eclipse.jface.preference.FieldEditorPreferencePage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.IntegerFieldEditor;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class TerminalPreferencePage
extends FieldEditorPreferencePage
implements IWorkbenchPreferencePage {
    private static final Logger logger = Logger.getLogger(TerminalPreferencePage.class);
    private static final String CONF_NAME_TERMINAL = "terminal";
    public static final String LIMIT_TIMEOUT = "limitTimeout";
    public static final String LIMIT_ENABLED = "limitEnabled";
    private RepositoryGlobalPreferenceStore repositoryPreferenceStore = new RepositoryGlobalPreferenceStore("/ide", "terminal");
    private BooleanFieldEditor enableTimeLimitField;
    private IntegerFieldEditor limitTimeoutField;

    public static RepositoryGlobalPreferenceStore getTerminalPreferenceStore() {
        try {
            RepositoryGlobalPreferenceStore repositoryPreferenceStore = new RepositoryGlobalPreferenceStore("/ide", CONF_NAME_TERMINAL);
            repositoryPreferenceStore.load();
            return repositoryPreferenceStore;
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return null;
        }
    }

    public TerminalPreferencePage() {
        super(1);
        try {
            this.repositoryPreferenceStore.load();
            this.setPreferenceStore((IPreferenceStore)this.repositoryPreferenceStore);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    protected void createFieldEditors() {
        try {
            this.repositoryPreferenceStore.load();
            if (this.repositoryPreferenceStore.preferenceNames().length == 0) {
                this.repositoryPreferenceStore.setValue(LIMIT_ENABLED, true);
                this.repositoryPreferenceStore.setValue(LIMIT_TIMEOUT, 30);
            }
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        this.enableTimeLimitField = new BooleanFieldEditor(LIMIT_ENABLED, "&Enable Time Limit", this.getFieldEditorParent());
        this.enableTimeLimitField.setPreferenceStore(this.getPreferenceStore());
        this.enableTimeLimitField.load();
        this.addField((FieldEditor)this.enableTimeLimitField);
        this.limitTimeoutField = new IntegerFieldEditor(LIMIT_TIMEOUT, "&Limit Timeout (s):", this.getFieldEditorParent());
        this.limitTimeoutField.setPreferenceStore(this.getPreferenceStore());
        this.limitTimeoutField.load();
        this.addField((FieldEditor)this.limitTimeoutField);
    }

    public void init(IWorkbench workbench) {
        super.initialize();
    }

    private void storeValues() {
        try {
            this.enableTimeLimitField.store();
            this.limitTimeoutField.store();
            this.repositoryPreferenceStore.save();
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    protected void performApply() {
        super.performApply();
        this.storeValues();
    }

    public boolean performOk() {
        this.storeValues();
        return super.performOk();
    }
}

