/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.template.ui.db.wizard;

import org.eclipse.dirigible.ide.template.ui.db.wizard.ColumnDefinition;
import org.eclipse.dirigible.ide.template.ui.db.wizard.Messages;
import org.eclipse.dirigible.repository.datasource.DBSupportedTypesMap;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.swt.custom.ScrolledComposite;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class AddColumnDialog
extends TitleAreaDialog {
    private static final Logger logger = Logger.getLogger(AddColumnDialog.class);
    private static final String END_OF_LINE = "\n";
    private static final String NAME = Messages.AddColumnDialog_NAME;
    private static final String TYPE = Messages.AddColumnDialog_TYPE;
    private static final String INPUT_THE_LENGTH_AS_INTEGER = Messages.AddColumnDialog_INPUT_THE_LENGTH_AS_INTEGER;
    private static final String LENGTH = Messages.AddColumnDialog_LENGTH;
    private static final String NOT_NULL = Messages.AddColumnDialog_NOT_NULL;
    private static final String PRIMARY_KEY = Messages.AddColumnDialog_PRIMARY_KEY;
    private static final String DEFAULT_VALUE = Messages.AddColumnDialog_DEFAULT_VALUE;
    private static final String ADD_COLUMN = Messages.AddColumnDialog_ADD_COLUMN;
    private static final String INPUT_THE_LENGTH = Messages.AddColumnDialog_INPUT_THE_LENGTH;
    private static final String INPUT_THE_TYPE = Messages.AddColumnDialog_INPUT_THE_TYPE;
    private static final String INPUT_THE_NAME = Messages.AddColumnDialog_INPUT_THE_NAME;
    private static final String DUPLICATE_COLUMN_NAME = Messages.AddColumnDialog_DUPLICATE_COLUMN_NAME;
    private static final long serialVersionUID = 131615855198018319L;
    private ColumnDefinition columnDefinition;
    private ColumnDefinition[] columnDefinitions;
    private Text nameText;
    private Combo typeCombo;
    private Text lengthText;
    private Button nnButton;
    private Button pkButton;
    private Text defaultText;
    private Shell parentShell;

    public AddColumnDialog(ColumnDefinition columnDefinition, ColumnDefinition[] columnDefinitions, Shell parentShell) {
        super(parentShell);
        this.parentShell = parentShell;
        this.parentShell.setEnabled(false);
        this.columnDefinition = columnDefinition;
        this.columnDefinitions = columnDefinitions;
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(ADD_COLUMN);
    }

    protected int getShellStyle() {
        return 1232;
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = (Composite)super.createDialogArea(parent);
        ScrolledComposite sc = new ScrolledComposite(composite, 768);
        sc.setLayout((Layout)new GridLayout());
        sc.setLayoutData((Object)new GridData(4, 128, true, true));
        sc.setExpandVertical(true);
        sc.setExpandHorizontal(true);
        sc.setMinSize(200, 200);
        Composite compositeInternal = new Composite((Composite)sc, 0);
        compositeInternal.setLayoutData((Object)new GridData(4, 128, true, true));
        GridLayout layout = new GridLayout(2, false);
        layout.marginBottom = 20;
        compositeInternal.setLayout((Layout)layout);
        this.createNameField(compositeInternal);
        this.createTypeField(compositeInternal);
        this.createLengthField(compositeInternal);
        this.createNotNullField(compositeInternal);
        this.createPrimaryKeyField(compositeInternal);
        this.createDefaultValueField(compositeInternal);
        sc.setContent((Control)compositeInternal);
        return composite;
    }

    private void createDefaultValueField(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(DEFAULT_VALUE);
        label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.defaultText = new Text(parent, 2048);
        this.defaultText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.defaultText.addModifyListener(new ModifyListener(){
            private static final long serialVersionUID = -8689439856255951278L;

            public void modifyText(ModifyEvent event) {
                if (AddColumnDialog.this.defaultText.getText() != null) {
                    AddColumnDialog.this.columnDefinition.setDefaultValue(AddColumnDialog.this.defaultText.getText());
                }
            }
        });
    }

    private void createPrimaryKeyField(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(PRIMARY_KEY);
        label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.pkButton = new Button(parent, 32);
        this.pkButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.pkButton.addSelectionListener(new SelectionListener(){
            private static final long serialVersionUID = -7266916932639020009L;

            public void widgetSelected(SelectionEvent e) {
                AddColumnDialog.this.columnDefinition.setPrimaryKey(AddColumnDialog.this.pkButton.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void createNotNullField(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(NOT_NULL);
        label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.nnButton = new Button(parent, 32);
        this.nnButton.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.nnButton.addSelectionListener(new SelectionListener(){
            private static final long serialVersionUID = 6729005491684506604L;

            public void widgetSelected(SelectionEvent e) {
                AddColumnDialog.this.columnDefinition.setNotNull(AddColumnDialog.this.nnButton.getSelection());
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
    }

    private void createLengthField(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(LENGTH);
        label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.lengthText = new Text(parent, 2048);
        this.lengthText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.lengthText.addModifyListener(new ModifyListener(){
            private static final long serialVersionUID = 70852273750274067L;

            public void modifyText(ModifyEvent event) {
                if (AddColumnDialog.this.lengthText.getText() == null || "".equals(AddColumnDialog.this.lengthText.getText())) {
                    if (DBSupportedTypesMap.DataTypes.VARCHAR.equals((Object)DBSupportedTypesMap.DataTypes.valueOf((String)AddColumnDialog.this.typeCombo.getText())) || DBSupportedTypesMap.DataTypes.CHAR.equals((Object)DBSupportedTypesMap.DataTypes.valueOf((String)AddColumnDialog.this.typeCombo.getText()))) {
                        AddColumnDialog.this.setErrorMessage(INPUT_THE_LENGTH);
                    } else {
                        AddColumnDialog.this.setErrorMessage(null);
                    }
                } else {
                    boolean isInt = false;
                    try {
                        int l = Integer.parseInt(AddColumnDialog.this.lengthText.getText());
                        if (l > 0) {
                            isInt = true;
                        }
                    }
                    catch (Exception e) {
                        logger.debug(e.getMessage());
                    }
                    if (isInt) {
                        AddColumnDialog.this.setErrorMessage(null);
                        AddColumnDialog.this.columnDefinition.setLength(Integer.parseInt(AddColumnDialog.this.lengthText.getText()));
                    } else {
                        AddColumnDialog.this.lengthText.setText("");
                        AddColumnDialog.this.columnDefinition.setLength(0);
                        AddColumnDialog.this.setErrorMessage(INPUT_THE_LENGTH_AS_INTEGER);
                    }
                }
            }
        });
    }

    private void createTypeField(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(TYPE);
        label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.typeCombo = new Combo(parent, 2056);
        this.typeCombo.setItems(DBSupportedTypesMap.getSupportedTypes());
        this.typeCombo.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.typeCombo.addModifyListener(new ModifyListener(){
            private static final long serialVersionUID = 9064913692268796690L;

            public void modifyText(ModifyEvent event) {
                if (AddColumnDialog.this.typeCombo.getText() == null || "".equals(AddColumnDialog.this.typeCombo.getText())) {
                    AddColumnDialog.this.setErrorMessage(INPUT_THE_TYPE);
                } else {
                    AddColumnDialog.this.setErrorMessage(null);
                    AddColumnDialog.this.columnDefinition.setType(AddColumnDialog.this.typeCombo.getText());
                }
            }
        });
    }

    private void createNameField(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(NAME);
        label.setLayoutData((Object)new GridData(16384, 0x1000000, false, false));
        this.nameText = new Text(parent, 2048);
        this.nameText.setLayoutData((Object)new GridData(4, 0x1000000, true, false));
        this.nameText.setFocus();
        this.nameText.addModifyListener(new ModifyListener(){
            private static final long serialVersionUID = -5729566562712894830L;

            public void modifyText(ModifyEvent event) {
                if (AddColumnDialog.this.nameText.getText() == null || "".equals(AddColumnDialog.this.nameText.getText())) {
                    AddColumnDialog.this.setErrorMessage(INPUT_THE_NAME);
                } else {
                    AddColumnDialog.this.setErrorMessage(null);
                    AddColumnDialog.this.columnDefinition.setName(AddColumnDialog.this.nameText.getText());
                }
            }
        });
    }

    protected void okPressed() {
        String errors = this.validateInput();
        if (errors == null) {
            super.okPressed();
            this.parentShell.setEnabled(true);
        } else {
            this.setErrorMessage(errors);
        }
    }

    protected void cancelPressed() {
        super.cancelPressed();
        this.parentShell.setEnabled(true);
    }

    protected void handleShellCloseEvent() {
        super.handleShellCloseEvent();
        this.parentShell.setEnabled(true);
    }

    private String validateInput() {
        StringBuilder buff = new StringBuilder();
        if (this.columnDefinition.getName() == null || "".equals(this.columnDefinition.getName())) {
            buff.append(String.valueOf(INPUT_THE_NAME) + END_OF_LINE);
        }
        if (this.columnDefinition.getType() == null || "".equals(this.columnDefinition.getType())) {
            buff.append(String.valueOf(INPUT_THE_TYPE) + END_OF_LINE);
        }
        if (this.columnDefinition.getLength() == 0 && (DBSupportedTypesMap.DataTypes.VARCHAR.equals((Object)DBSupportedTypesMap.DataTypes.valueOf((String)this.typeCombo.getText())) || DBSupportedTypesMap.DataTypes.CHAR.equals((Object)DBSupportedTypesMap.DataTypes.valueOf((String)this.typeCombo.getText())))) {
            buff.append(String.valueOf(INPUT_THE_LENGTH) + END_OF_LINE);
        }
        ColumnDefinition[] columnDefinitionArray = this.columnDefinitions;
        int n = this.columnDefinitions.length;
        int n2 = 0;
        while (n2 < n) {
            ColumnDefinition columnDefinition_ = columnDefinitionArray[n2];
            if (this.columnDefinition.getName().equals(columnDefinition_.getName())) {
                buff.append(String.valueOf(DUPLICATE_COLUMN_NAME) + END_OF_LINE);
                break;
            }
            ++n2;
        }
        if (buff.length() > 0) {
            return buff.toString();
        }
        return null;
    }
}

