/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.workspace.impl;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.core.resources.IBuildConfiguration;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFilterMatcherDescriptor;
import org.eclipse.core.resources.IMarker;
import org.eclipse.core.resources.IPathVariableManager;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IProjectNatureDescriptor;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceChangeEvent;
import org.eclipse.core.resources.IResourceChangeListener;
import org.eclipse.core.resources.IResourceRuleFactory;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.ISavedState;
import org.eclipse.core.resources.ISynchronizer;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceDescription;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.IWorkspaceRunnable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.dirigible.ide.common.CommonIDEParameters;
import org.eclipse.dirigible.ide.repository.RepositoryFacade;
import org.eclipse.dirigible.ide.workspace.impl.File;
import org.eclipse.dirigible.ide.workspace.impl.Folder;
import org.eclipse.dirigible.ide.workspace.impl.Messages;
import org.eclipse.dirigible.ide.workspace.impl.WorkspaceRoot;
import org.eclipse.dirigible.repository.api.IRepository;
import org.eclipse.dirigible.repository.api.RepositoryException;
import org.eclipse.dirigible.repository.logging.Logger;

public class Workspace
implements IWorkspace {
    private static final String WORKSPACE_CHANGE_LISTENERS_FLAGS = "workspace.changeListenersFlags";
    private static final String WORKSPACE_CHANGE_LISTENERS = "workspace.changeListeners";
    private static final String INVALID_ROOT_PATH = Messages.Workspace_INVALID_ROOT_PATH;
    private static final String FILE_PATH_MUST_HAVE_ATLEAST_2_SEGMENTS = Messages.Workspace_FILE_PATH_MUST_HAVE_ATLEAST_2_SEGMENTS;
    private static final String FOLDER_PATH_MUST_HAVE_ATLEAST_2_SEGMENTS = Messages.Workspace_FOLDER_PATH_MUST_HAVE_ATLEAST_2_SEGMENTS;
    private static final String PROJECT_PATH_MUST_HAVE_1_SEGMENT = Messages.Workspace_PROJECT_PATH_MUST_HAVE_1_SEGMENT;
    private static final String PATH_MAY_NOT_CONTAIN_DEVICE_ID = Messages.Workspace_PATH_MAY_NOT_CONTAIN_DEVICE_ID;
    private static final String PATH_MUST_BE_ABSOLUTE = Messages.Workspace_PATH_MUST_BE_ABSOLUTE;
    private static final String PATH_MAY_NOT_CONTAIN = Messages.Workspace_PATH_MAY_NOT_CONTAIN;
    private static final String PATH_MAY_NOT_BE_EMPTY = Messages.Workspace_PATH_MAY_NOT_BE_EMPTY;
    private static final String PATH_MAY_NOT_BE_NULL = Messages.Workspace_PATH_MAY_NOT_BE_NULL;
    private static final String ROOT_NAME_IS_ALWAYS_INVALID = Messages.Workspace_ROOT_NAME_IS_ALWAYS_INVALID;
    private static final String NAME_MAY_NOT_BE_NULL = Messages.Workspace_NAME_MAY_NOT_BE_NULL;
    private static final String NATURES_ARE_NOT_SUPPORTED = Messages.Workspace_NATURES_ARE_NOT_SUPPORTED;
    private static final String WORKSPACE_STATE_NOT_SUPPORTED = Messages.Workspace_WORKSPACE_STATE_NOT_SUPPORTED;
    private static final String AUTO_BUILDING_IS_NOT_SUPPORTED = Messages.Workspace_AUTO_BUILDING_IS_NOT_SUPPORTED;
    private static final String WORKSPACE_IS_NOT_INITIALIZED = Messages.Workspace_WORKSPACE_IS_NOT_INITIALIZED;
    private static final String MARKERS_ARE_NOT_SUPPORTED = Messages.Workspace_MARKERS_ARE_NOT_SUPPORTED;
    private static final String ONE_OR_MORE_RESOURCES_WERE_NOT_DELETED = Messages.Workspace_ONE_OR_MORE_RESOURCES_WERE_NOT_DELETED;
    private static final String PROJECT_BUILDING_IS_NOT_SUPPORTED = Messages.Workspace_PROJECT_BUILDING_IS_NOT_SUPPORTED;
    private static final String LISTENER_MAY_NOT_BE_NULL = Messages.Workspace_LISTENER_MAY_NOT_BE_NULL;
    private static final String WORKSPACE_NOT_INITIALIZED = Messages.Workspace_WORKSPACE_NOT_INITIALIZED;
    private static final String COULD_NOT_CREATE_WORKSPACE_ROOT = Messages.Workspace_COULD_NOT_CREATE_WORKSPACE_ROOT;
    private static final String COULD_NOT_CREATE_REPOSITORY_HANDLER = Messages.Workspace_COULD_NOT_CREATE_REPOSITORY_HANDLER;
    private static final String WORKSPACE = "/workspace";
    private static final String DB_DIRIGIBLE_USERS = "/db/dirigible/users/";
    private static final Logger logger = Logger.getLogger(Workspace.class);
    private final IRepository repository;
    private WorkspaceRoot root = null;
    private IPath location = null;
    private String username = null;

    public Workspace() throws RepositoryException {
        this.repository = RepositoryFacade.getInstance().getRepository();
        if (this.repository == null) {
            throw new RepositoryException(COULD_NOT_CREATE_REPOSITORY_HANDLER);
        }
    }

    public Workspace(HttpServletRequest request) throws RepositoryException {
        this.repository = RepositoryFacade.getInstance().getRepository(request);
        if (this.repository == null) {
            throw new RepositoryException(COULD_NOT_CREATE_REPOSITORY_HANDLER);
        }
    }

    private Map<IResourceChangeListener, Integer> lookupChangeListenersFlags() {
        HashMap changeListenersFlags = (HashMap)CommonIDEParameters.getObject((String)WORKSPACE_CHANGE_LISTENERS_FLAGS);
        if (changeListenersFlags == null) {
            changeListenersFlags = new HashMap();
            CommonIDEParameters.setObject((String)WORKSPACE_CHANGE_LISTENERS_FLAGS, changeListenersFlags);
        }
        return changeListenersFlags;
    }

    private Set<IResourceChangeListener> lookupChangeListeners() {
        HashSet changeListeners = (HashSet)CommonIDEParameters.getObject((String)WORKSPACE_CHANGE_LISTENERS);
        if (changeListeners == null) {
            changeListeners = new HashSet();
            CommonIDEParameters.setObject((String)WORKSPACE_CHANGE_LISTENERS, changeListeners);
        }
        return changeListeners;
    }

    public Workspace(IRepository repository) {
        this.repository = repository;
    }

    public void initialize(String username) {
        this.username = username;
        String path = this.getRepositoryPathForWorkspace(username);
        this.location = new Path(path);
        try {
            this.repository.createCollection(path);
            this.root = new WorkspaceRoot((IPath)Path.ROOT, this);
        }
        catch (IOException ex) {
            throw new RuntimeException(COULD_NOT_CREATE_WORKSPACE_ROOT, ex);
        }
    }

    public String getRepositoryPathForWorkspace(String username) {
        return DB_DIRIGIBLE_USERS + username + WORKSPACE;
    }

    public IPath getLocation() {
        if (this.location == null) {
            throw new IllegalStateException(WORKSPACE_NOT_INITIALIZED);
        }
        return this.location;
    }

    public IRepository getRepository() {
        return this.repository;
    }

    public IResource newResource(IPath path) {
        if (!this.root.getLocation().isPrefixOf(path)) {
            return null;
        }
        IPath extractedPath = path.removeFirstSegments(this.root.getLocation().segmentCount()).makeAbsolute();
        if (extractedPath.equals((Object)Path.ROOT)) {
            return this.root;
        }
        if (extractedPath.segmentCount() <= 0) {
            return this.root;
        }
        if (extractedPath.segmentCount() == 1) {
            IProject project = this.root.getProject(extractedPath.segment(0));
            if (project.exists()) {
                return project;
            }
            return null;
        }
        try {
            if (this.repository.hasCollection(path.toString())) {
                return new Folder(extractedPath, this);
            }
            if (this.repository.hasResource(path.toString())) {
                return new File(extractedPath, this);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return null;
    }

    public boolean hasResource(IPath path) {
        try {
            String location = path.toString();
            return this.repository.hasCollection(location) || this.repository.hasResource(location);
        }
        catch (IOException iOException) {
            return true;
        }
    }

    public Object getAdapter(Class adapter) {
        return null;
    }

    public void addResourceChangeListener(IResourceChangeListener listener) {
        this.addResourceChangeListener(listener, 7);
    }

    public void addResourceChangeListener(IResourceChangeListener listener, int eventMask) {
        if (listener == null) {
            throw new IllegalArgumentException(LISTENER_MAY_NOT_BE_NULL);
        }
        this.lookupChangeListeners().add(listener);
        this.lookupChangeListenersFlags().put(listener, eventMask);
    }

    public void notifyResourceChanged(IResourceChangeEvent event) {
        for (IResourceChangeListener listener : new HashSet<IResourceChangeListener>(this.lookupChangeListeners())) {
            int flags = this.lookupChangeListenersFlags().get(listener);
            if ((event.getType() & flags) == 0) continue;
            listener.resourceChanged(event);
        }
    }

    public ISavedState addSaveParticipant(Plugin arg0, ISaveParticipant arg1) throws CoreException {
        throw new UnsupportedOperationException();
    }

    public ISavedState addSaveParticipant(String arg0, ISaveParticipant arg1) throws CoreException {
        throw new UnsupportedOperationException();
    }

    public void build(int kind, IProgressMonitor monitor) throws CoreException {
        throw new UnsupportedOperationException(PROJECT_BUILDING_IS_NOT_SUPPORTED);
    }

    public void checkpoint(boolean arg0) {
        throw new UnsupportedOperationException();
    }

    public IProject[][] computePrerequisiteOrder(IProject[] arg0) {
        throw new UnsupportedOperationException();
    }

    public IWorkspace.ProjectOrder computeProjectOrder(IProject[] arg0) {
        throw new UnsupportedOperationException();
    }

    public IStatus copy(IResource[] resources, IPath destination, boolean force, IProgressMonitor monitor) throws CoreException {
        int flags = force ? 1 : 0;
        return this.copy(resources, destination, flags, monitor);
    }

    public IStatus copy(IResource[] arg0, IPath arg1, int arg2, IProgressMonitor arg3) throws CoreException {
        throw new UnsupportedOperationException();
    }

    public IStatus delete(IResource[] resources, boolean force, IProgressMonitor monitor) throws CoreException {
        int flags = 2 | (force ? 1 : 0);
        return this.delete(resources, flags, monitor);
    }

    public IStatus delete(IResource[] resources, int updateFlags, IProgressMonitor monitor) throws CoreException {
        boolean deleteFailed = false;
        IResource[] iResourceArray = resources;
        int n = resources.length;
        int n2 = 0;
        while (n2 < n) {
            IResource resource = iResourceArray[n2];
            if (resource.exists()) {
                resource.delete(updateFlags, monitor);
                if (resource.exists()) {
                    deleteFailed = true;
                }
            }
            ++n2;
        }
        if (deleteFailed) {
            return Workspace.createErrorStatus(ONE_OR_MORE_RESOURCES_WERE_NOT_DELETED);
        }
        return Workspace.createOkStatus();
    }

    public void deleteMarkers(IMarker[] marksers) throws CoreException {
        throw new UnsupportedOperationException(MARKERS_ARE_NOT_SUPPORTED);
    }

    public void forgetSavedTree(String arg0) {
        throw new UnsupportedOperationException();
    }

    public Map<IProject, IProject[]> getDanglingReferences() {
        throw new UnsupportedOperationException();
    }

    public IWorkspaceDescription getDescription() {
        throw new UnsupportedOperationException();
    }

    public IFilterMatcherDescriptor getFilterMatcherDescriptor(String arg0) {
        throw new UnsupportedOperationException();
    }

    public IFilterMatcherDescriptor[] getFilterMatcherDescriptors() {
        throw new UnsupportedOperationException();
    }

    public IProjectNatureDescriptor getNatureDescriptor(String arg0) {
        throw new UnsupportedOperationException();
    }

    public IProjectNatureDescriptor[] getNatureDescriptors() {
        throw new UnsupportedOperationException();
    }

    public IPathVariableManager getPathVariableManager() {
        throw new UnsupportedOperationException();
    }

    public IWorkspaceRoot getRoot() {
        if (this.root == null) {
            throw new IllegalStateException(WORKSPACE_IS_NOT_INITIALIZED);
        }
        return this.root;
    }

    public IResourceRuleFactory getRuleFactory() {
        throw new UnsupportedOperationException();
    }

    public ISynchronizer getSynchronizer() {
        throw new UnsupportedOperationException();
    }

    public boolean isAutoBuilding() {
        logger.error(AUTO_BUILDING_IS_NOT_SUPPORTED);
        return false;
    }

    public boolean isTreeLocked() {
        throw new UnsupportedOperationException();
    }

    public IProjectDescription loadProjectDescription(IPath arg0) throws CoreException {
        throw new UnsupportedOperationException();
    }

    public IProjectDescription loadProjectDescription(InputStream arg0) throws CoreException {
        throw new UnsupportedOperationException();
    }

    public IStatus move(IResource[] resources, IPath destination, boolean force, IProgressMonitor monitor) throws CoreException {
        int flags = 2 | (force ? 1 : 0);
        return this.move(resources, destination, flags, monitor);
    }

    public IStatus move(IResource[] resources, IPath destination, int updateFlags, IProgressMonitor monitor) throws CoreException {
        throw new UnsupportedOperationException();
    }

    public IProjectDescription newProjectDescription(String arg0) {
        throw new UnsupportedOperationException();
    }

    public void removeResourceChangeListener(IResourceChangeListener listener) {
        if (listener != null) {
            this.lookupChangeListeners().remove(listener);
            this.lookupChangeListenersFlags().remove(listener);
        }
    }

    public void removeSaveParticipant(Plugin arg0) {
        throw new UnsupportedOperationException();
    }

    public void removeSaveParticipant(String arg0) {
        throw new UnsupportedOperationException();
    }

    public void run(IWorkspaceRunnable action, IProgressMonitor monitor) throws CoreException {
        this.run(action, (ISchedulingRule)this.getRoot(), 1, monitor);
    }

    public void run(IWorkspaceRunnable action, ISchedulingRule rule, int flags, IProgressMonitor monitor) throws CoreException {
        throw new UnsupportedOperationException();
    }

    public IStatus save(boolean full, IProgressMonitor monitor) throws CoreException {
        throw new UnsupportedOperationException(WORKSPACE_STATE_NOT_SUPPORTED);
    }

    public void setDescription(IWorkspaceDescription arg0) throws CoreException {
        throw new UnsupportedOperationException();
    }

    public String[] sortNatureSet(String[] natureIds) {
        throw new UnsupportedOperationException(NATURES_ARE_NOT_SUPPORTED);
    }

    public IStatus validateEdit(IFile[] arg0, Object arg1) {
        throw new UnsupportedOperationException();
    }

    public IStatus validateLinkLocation(IResource resource, IPath location) {
        throw new UnsupportedOperationException();
    }

    public IStatus validateLinkLocationURI(IResource resource, URI location) {
        return this.validateLinkLocation(resource, (IPath)new Path(location.toString()));
    }

    public IStatus validateName(String segment, int typeMask) {
        if (segment == null) {
            throw new IllegalArgumentException(NAME_MAY_NOT_BE_NULL);
        }
        if (Workspace.maskContainsFlag(typeMask, 8)) {
            return Workspace.createErrorStatus(ROOT_NAME_IS_ALWAYS_INVALID);
        }
        if (Workspace.maskContainsFlag(typeMask, 4)) {
            return this.getValidationStatusForPath(segment);
        }
        if (Workspace.maskContainsFlag(typeMask, 2)) {
            return this.getValidationStatusForPath(segment);
        }
        return this.getValidationStatusForFile(segment);
    }

    private IStatus getValidationStatusForPath(String segment) {
        String projectRegExPattern = "([a-z][a-z_0-9]*)*[a-zA-Z_]($[A-Z_]|[\\w_])*";
        IStatus status = Pattern.matches(projectRegExPattern, segment) ? Workspace.createOkStatus() : Workspace.createErrorStatus(Messages.PROJECT_AND_FOLDER_NAME_FORMAT);
        return status;
    }

    private IStatus getValidationStatusForFile(String segment) {
        IStatus status;
        String fileRegExPattern = "([a-zA-Z_0-9.-]+([a-zA-Z_0-9]+))$";
        if (Pattern.matches(fileRegExPattern, segment)) {
            if (segment.lastIndexOf("..") != -1) {
                IStatus status2 = Workspace.createErrorStatus(Messages.FILE_NAME_FORMAT);
                return status2;
            }
            if (segment.lastIndexOf("--") != -1) {
                IStatus status3 = Workspace.createErrorStatus(Messages.FILE_NAME_FORMAT);
                return status3;
            }
            if (segment.lastIndexOf(".-") != -1) {
                IStatus status4 = Workspace.createErrorStatus(Messages.FILE_NAME_FORMAT);
                return status4;
            }
            if (segment.lastIndexOf("-.") != -1) {
                IStatus status5 = Workspace.createErrorStatus(Messages.FILE_NAME_FORMAT);
                return status5;
            }
            status = Workspace.createOkStatus();
        } else {
            status = Workspace.createErrorStatus(Messages.FILE_NAME_FORMAT);
        }
        return status;
    }

    public IStatus validateNatureSet(String[] natureIds) {
        throw new UnsupportedOperationException(NATURES_ARE_NOT_SUPPORTED);
    }

    public IStatus validatePath(String path, int typeMask) {
        IStatus status;
        IStatus status2;
        if (path == null) {
            throw new IllegalArgumentException(PATH_MAY_NOT_BE_NULL);
        }
        if (path.isEmpty()) {
            return Workspace.createErrorStatus(PATH_MAY_NOT_BE_EMPTY);
        }
        if (path.contains("\\")) {
            return Workspace.createErrorStatus(PATH_MAY_NOT_CONTAIN);
        }
        if (Workspace.maskContainsFlag(typeMask, 8) && !(status2 = this.validateRootPath(path)).isOK()) {
            return status2;
        }
        Path wrapperPath = new Path(path);
        if (!wrapperPath.isAbsolute()) {
            return Workspace.createErrorStatus(PATH_MUST_BE_ABSOLUTE);
        }
        if (wrapperPath.getDevice() != null) {
            return Workspace.createErrorStatus(PATH_MAY_NOT_CONTAIN_DEVICE_ID);
        }
        if (Workspace.maskContainsFlag(typeMask, 1) && !(status = this.validateFilePath(wrapperPath)).isOK()) {
            return status;
        }
        if (Workspace.maskContainsFlag(typeMask, 2) && !(status = this.validateFolderPath(wrapperPath)).isOK()) {
            return status;
        }
        if (Workspace.maskContainsFlag(typeMask, 4) && !(status = this.validateProjectPath(wrapperPath)).isOK()) {
            return status;
        }
        return Workspace.createOkStatus();
    }

    private IStatus validateProjectPath(Path path) {
        if (path.segmentCount() != 1) {
            return Workspace.createErrorStatus(PROJECT_PATH_MUST_HAVE_1_SEGMENT);
        }
        return this.validateName(path.lastSegment(), 4);
    }

    private IStatus validateFolderPath(Path path) {
        if (path.segmentCount() < 2) {
            return Workspace.createErrorStatus(FOLDER_PATH_MUST_HAVE_ATLEAST_2_SEGMENTS);
        }
        IStatus status = this.validateName(path.segment(0), 4);
        int i = 1;
        while (i < path.segmentCount()) {
            status = this.validateName(path.segment(i), 2);
            if (!status.isOK()) {
                return status;
            }
            ++i;
        }
        return Workspace.createOkStatus();
    }

    private IStatus validateFilePath(Path path) {
        if (path.segmentCount() < 2) {
            return Workspace.createErrorStatus(FILE_PATH_MUST_HAVE_ATLEAST_2_SEGMENTS);
        }
        IStatus status = this.validateName(path.segment(0), 4);
        int i = 1;
        while (i < path.segmentCount() - 1) {
            status = this.validateName(path.segment(i), 2);
            if (!status.isOK()) {
                return status;
            }
            ++i;
        }
        return this.validateName(path.lastSegment(), 1);
    }

    private IStatus validateRootPath(String path) {
        if (path.equals(this.getRoot().getLocation().toString())) {
            return Workspace.createOkStatus();
        }
        return Workspace.createErrorStatus(String.valueOf(INVALID_ROOT_PATH) + path);
    }

    public IStatus validateProjectLocation(IProject project, IPath location) {
        throw new UnsupportedOperationException();
    }

    public IStatus validateProjectLocationURI(IProject project, URI location) {
        return this.validateProjectLocation(project, (IPath)new Path(location.toString()));
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof Workspace) {
            Workspace other = (Workspace)obj;
            if (this.username == null) {
                return other.username == null;
            }
            return this.username.equals(other.username);
        }
        return false;
    }

    public int hashCode() {
        return this.username.hashCode();
    }

    private static IStatus createOkStatus() {
        return Workspace.createOkStatus(Messages.Workspace_OK);
    }

    private static IStatus createOkStatus(String message) {
        return new Status(0, "org.eclipse.dirigible.ide.workspace", message);
    }

    private static IStatus createErrorStatus(String message) {
        return new Status(4, "org.eclipse.dirigible.ide.workspace", message);
    }

    private static boolean maskContainsFlag(int mask, int flag) {
        return (mask & flag) == flag;
    }

    public IStatus validateFiltered(IResource arg0) {
        return null;
    }

    public void build(IBuildConfiguration[] buildConfigs, int kind, boolean buildReferences, IProgressMonitor monitor) throws CoreException {
    }

    public IBuildConfiguration newBuildConfig(String projectName, String configName) {
        return null;
    }
}

