/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.repository.datasource.db.dialect;

import org.eclipse.dirigible.repository.datasource.DBSupportedTypesMap;
import org.eclipse.dirigible.repository.datasource.db.dialect.RDBGenericDialectSpecifier;

public class MySQLDBSpecifier
extends RDBGenericDialectSpecifier {
    public static final String PRODUCT_MYSQL = "MySQL";
    private static final String LIMIT_D_D = "LIMIT %d, %d";
    private static final String MYSQLDB_TIMESTAMP = "TIMESTAMP";
    private static final String MYSQL_FLOAT = "DOUBLE";
    private static final String MYSQL_BLOB = "LONGBLOB";
    private static final String MYSQL_CURRENT_TIMESTAMP = "CURRENT_TIMESTAMP";
    private static final String MYSQL_KEY_VARCHAR = "VARCHAR(255)";
    private static final String MYSQL_BIG_VARCHAR = "TEXT";
    private static final String MYSQL_CLOB = "TEXT";

    @Override
    public String specify(String sql) {
        sql = sql.replace("$CURRENT_TIMESTAMP$", MYSQL_CURRENT_TIMESTAMP);
        sql = sql.replace("$TIMESTAMP$", MYSQLDB_TIMESTAMP);
        sql = sql.replace("$BLOB$", MYSQL_BLOB);
        sql = sql.replace("$KEY_VARCHAR$", MYSQL_KEY_VARCHAR);
        sql = sql.replace("$BIG_VARCHAR$", "TEXT");
        sql = sql.replace("$CLOB$", "TEXT");
        return sql;
    }

    @Override
    public String getSpecificType(String commonType) {
        if (DBSupportedTypesMap.DataTypes.FLOAT.equals((Object)DBSupportedTypesMap.DataTypes.valueOf((String)commonType))) {
            return MYSQL_FLOAT;
        }
        if (DBSupportedTypesMap.DataTypes.BLOB.equals((Object)DBSupportedTypesMap.DataTypes.valueOf((String)commonType))) {
            return MYSQL_BLOB;
        }
        if (DBSupportedTypesMap.DataTypes.CLOB.equals((Object)DBSupportedTypesMap.DataTypes.valueOf((String)commonType))) {
            return "TEXT";
        }
        return commonType;
    }

    @Override
    public String createLimitAndOffset(int limit, int offset) {
        return String.format(LIMIT_D_D, offset, limit);
    }

    @Override
    public String getAlterAddOpen() {
        return " ADD ";
    }

    @Override
    public boolean isCatalogForSchema() {
        return true;
    }

    @Override
    public boolean isDialectForName(String productName) {
        return PRODUCT_MYSQL.equalsIgnoreCase(productName);
    }
}

