/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.js;

import java.io.IOException;
import java.util.Map;
import javax.script.Bindings;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.dirigible.repository.api.IRepository;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.dirigible.runtime.js.JavaScriptActivator;
import org.eclipse.dirigible.runtime.scripting.AbstractScriptExecutor;
import org.eclipse.dirigible.runtime.scripting.IJavaScriptEngineExecutor;
import org.eclipse.dirigible.runtime.scripting.IJavaScriptExecutor;
import org.eclipse.dirigible.runtime.scripting.Module;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;

public class JavaScriptExecutor
extends AbstractScriptExecutor
implements IJavaScriptExecutor {
    private static final String JS_TYPE_INTERNAL = "IJavaScriptEngineExecutor";
    private static final Logger logger = Logger.getLogger(JavaScriptExecutor.class);
    private IRepository repository;
    private String[] rootPaths;

    public JavaScriptExecutor(IRepository repository, String ... rootPaths) {
        logger.debug("entering: constructor()");
        this.repository = repository;
        this.rootPaths = rootPaths;
        if (this.rootPaths == null || this.rootPaths.length == 0) {
            this.rootPaths = new String[2];
        }
        logger.debug("exiting: constructor()");
    }

    public IRepository getRepository() {
        return this.repository;
    }

    public String[] getRootPaths() {
        return this.rootPaths;
    }

    public Object executeServiceModule(HttpServletRequest request, HttpServletResponse response, Object input, String module, Map<Object, Object> executionContext) throws IOException {
        String ends;
        int index;
        if (module == null) {
            throw new IOException("The module name for execution cannot be null");
        }
        if (module.endsWith("json") || module.endsWith("entity") || module.endsWith("swagger")) {
            Module scriptingModule = this.retrieveModule(this.repository, module, null, this.rootPaths);
            byte[] result = scriptingModule.getContent();
            return new String(result);
        }
        if (!module.endsWith("js") && (index = module.indexOf(ends = ".js")) > 0) {
            String pathInfo = module.substring(index + ends.length() + 1);
            module = module.substring(0, index + ends.length());
            request.setAttribute("path", (Object)pathInfo);
        }
        IJavaScriptEngineExecutor javascriptEngineExecutor = null;
        if (request != null) {
            javascriptEngineExecutor = (IJavaScriptEngineExecutor)request.getAttribute(JS_TYPE_INTERNAL);
        }
        if (javascriptEngineExecutor == null) {
            try {
                String engine;
                javascriptEngineExecutor = request != null ? ("nashorn".equalsIgnoreCase(engine = request.getParameter("engine")) ? JavaScriptActivator.createExecutor("nashorn", this) : JavaScriptActivator.createExecutor("rhino", this)) : JavaScriptActivator.createExecutor("rhino", this);
            }
            catch (Throwable t) {
                logger.error(t.getMessage());
                throw new IOException(t);
            }
        }
        return javascriptEngineExecutor.executeServiceModule(request, response, input, module, executionContext);
    }

    public void beforeExecution(HttpServletRequest request, HttpServletResponse response, String module, Object context) {
    }

    protected void registerDefaultVariable(Object scope, String name, Object value) {
        if (scope instanceof ScriptableObject) {
            ScriptableObject local = (ScriptableObject)scope;
            local.put(name, (Scriptable)local, value);
        } else if (scope instanceof Bindings) {
            Bindings local = (Bindings)scope;
            local.put(name, value);
        }
    }

    protected String getModuleType(String path) {
        return "ScriptingServices";
    }
}

