/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.core.resources;

import java.util.ArrayList;
import java.util.Hashtable;
import org.eclipse.core.internal.preferences.PreferencesService;
import org.eclipse.core.internal.resources.LocalMetaArea;
import org.eclipse.core.internal.resources.PlatformURLResourceConnection;
import org.eclipse.core.internal.resources.Workspace;
import org.eclipse.core.internal.utils.Messages;
import org.eclipse.core.internal.utils.Policy;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.ICoreRunnable;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.osgi.service.debug.DebugOptionsListener;
import org.osgi.framework.BundleContext;
import org.osgi.framework.ServiceRegistration;

public final class ResourcesPlugin
extends Plugin {
    public static final String PI_RESOURCES = "org.eclipse.core.resources";
    public static final String PT_BUILDERS = "builders";
    public static final String PT_NATURES = "natures";
    public static final String PT_MARKERS = "markers";
    public static final String PT_FILE_MODIFICATION_VALIDATOR = "fileModificationValidator";
    public static final String PT_MOVE_DELETE_HOOK = "moveDeleteHook";
    public static final String PT_TEAM_HOOK = "teamHook";
    public static final String PT_REFRESH_PROVIDERS = "refreshProviders";
    public static final String PT_MODEL_PROVIDERS = "modelProviders";
    public static final String PT_VARIABLE_PROVIDERS = "variableResolvers";
    public static final String PT_FILTER_MATCHERS = "filterMatchers";
    public static final Object FAMILY_AUTO_BUILD = new Object();
    public static final Object FAMILY_AUTO_REFRESH = new Object();
    public static final Object FAMILY_MANUAL_BUILD = new Object();
    public static final Object FAMILY_MANUAL_REFRESH = new Object();
    public static final String PREF_ENCODING = "encoding";
    private static final String PREF_DESCRIPTION_PREFIX = "description.";
    @Deprecated
    public static final String PREF_MAX_NOTIFICATION_DELAY = "maxnotifydelay";
    public static final String PREF_AUTO_BUILDING = "description.autobuilding";
    public static final String PREF_BUILD_ORDER = "description.buildorder";
    public static final String PREF_DEFAULT_BUILD_ORDER = "description.defaultbuildorder";
    public static final String PREF_MAX_BUILD_ITERATIONS = "description.maxbuilditerations";
    public static final String PREF_APPLY_FILE_STATE_POLICY = "description.applyfilestatepolicy";
    public static final String PREF_FILE_STATE_LONGEVITY = "description.filestatelongevity";
    public static final String PREF_MAX_FILE_STATE_SIZE = "description.maxfilestatesize";
    public static final String PREF_MAX_FILE_STATES = "description.maxfilestates";
    public static final String PREF_SNAPSHOT_INTERVAL = "description.snapshotinterval";
    public static final String PREF_DISABLE_LINKING = "description.disableLinking";
    public static final String PREF_AUTO_REFRESH = "refresh.enabled";
    public static final String PREF_LIGHTWEIGHT_AUTO_REFRESH = "refresh.lightweight.enabled";
    public static final String PREF_SEPARATE_DERIVED_ENCODINGS = "separateDerivedEncodings";
    public static final boolean DEFAULT_PREF_SEPARATE_DERIVED_ENCODINGS = false;
    private static final int GET_WORKSPACE_TIMEOUT_BEFORE_WARNING_MILLIS = 20000;
    private static ResourcesPlugin plugin;
    private static volatile Workspace workspace;
    private static volatile Job initWorkspaceJob;
    private volatile ServiceRegistration<IWorkspace> workspaceRegistration;
    private volatile ServiceRegistration<DebugOptionsListener> debugRegistration;

    static {
        workspace = null;
    }

    public ResourcesPlugin() {
        plugin = this;
    }

    private static void constructWorkspace() throws CoreException {
        new LocalMetaArea().createMetaArea();
    }

    public static String getEncoding() {
        String enc = ResourcesPlugin.getPlugin().getPluginPreferences().getString(PREF_ENCODING);
        if (enc == null || enc.length() == 0) {
            enc = System.getProperty("file.encoding");
        }
        return enc;
    }

    public static ResourcesPlugin getPlugin() {
        return plugin;
    }

    public static IWorkspace getWorkspace() {
        Job job = initWorkspaceJob;
        if (workspace == null && job == null) {
            throw new IllegalStateException(Messages.resources_workspaceClosed);
        }
        if (job != null && Thread.currentThread() != job.getThread()) {
            try {
                while (!job.join(20000L, (IProgressMonitor)new NullProgressMonitor())) {
                    ResourcesPlugin.logLongWorkspaceInitWarning(job);
                }
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
            }
            if (workspace == null) {
                throw new IllegalStateException(Messages.resources_workspaceClosed);
            }
        }
        return workspace;
    }

    private static void logLongWorkspaceInitWarning(Job job) {
        class SeverityMultiStatus
        extends MultiStatus {
            public SeverityMultiStatus(int severity, String pluginId, String message, Throwable exception) {
                super(pluginId, 0, message, exception);
                this.setSeverity(severity);
            }
        }
        SeverityMultiStatus status = new SeverityMultiStatus(2, PI_RESOURCES, String.format("Workspace initialization takes longer than usual. Thread ''%s'' is blocked until the initialization finishes.", Thread.currentThread()), null);
        Exception exception = new Exception();
        status.add((IStatus)new Status(1, PI_RESOURCES, "Sample stacktrace of the blocked thread.", (Throwable)exception));
        try {
            SecurityManager securityManager = System.getSecurityManager();
            if (securityManager != null) {
                securityManager.checkPermission(new RuntimePermission("getStackTrace"));
            }
            exception = new Exception();
            exception.setStackTrace(job.getThread().getStackTrace());
            status.add((IStatus)new Status(1, PI_RESOURCES, "Sample stacktrace of the initialization workspace job.", (Throwable)exception));
        }
        catch (SecurityException securityException) {}
        ResourcesPlugin.getPlugin().getLog().log((IStatus)status);
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        this.debugRegistration.unregister();
        this.debugRegistration = null;
        if (workspace == null) {
            return;
        }
        this.workspaceRegistration.unregister();
        ResourcesPlugin.getPlugin().savePluginPreferences();
        workspace.close(null);
        workspace = null;
        this.workspaceRegistration = null;
    }

    public void start(final BundleContext context) throws Exception {
        super.start(context);
        initWorkspaceJob = Job.createSystem((String)Messages.resources_initWorkspace, (ICoreRunnable)new ICoreRunnable(){

            public void run(IProgressMonitor monitor) throws CoreException {
                try {
                    Hashtable<String, String> properties = new Hashtable<String, String>(2);
                    properties.put("listener.symbolic.name", ResourcesPlugin.PI_RESOURCES);
                    ResourcesPlugin.this.debugRegistration = context.registerService(DebugOptionsListener.class, (Object)Policy.RESOURCES_DEBUG_OPTIONS_LISTENER, properties);
                    if (!new LocalMetaArea().hasSavedWorkspace()) {
                        ResourcesPlugin.constructWorkspace();
                    }
                    ResourcesPlugin.workspace = new Workspace();
                    PlatformURLResourceConnection.startup(workspace.getRoot().getLocation());
                    ResourcesPlugin.this.initializePreferenceLookupOrder();
                    IStatus result = workspace.open(monitor);
                    if (!result.isOK()) {
                        ResourcesPlugin.this.getLog().log(result);
                    }
                    ResourcesPlugin.this.workspaceRegistration = context.registerService(IWorkspace.class, (Object)workspace, null);
                }
                finally {
                    initWorkspaceJob = null;
                }
            }
        });
        initWorkspaceJob.schedule();
    }

    private void initializePreferenceLookupOrder() {
        PreferencesService service = PreferencesService.getDefault();
        String[] original = service.getDefaultDefaultLookupOrder();
        ArrayList<String> newOrder = new ArrayList<String>();
        newOrder.add("project");
        String[] stringArray = original;
        int n = original.length;
        int n2 = 0;
        while (n2 < n) {
            String entry = stringArray[n2];
            newOrder.add(entry);
            ++n2;
        }
        service.setDefaultDefaultLookupOrder(newOrder.toArray(new String[newOrder.size()]));
    }
}

