/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.wikitext.core.parser.builder;

import java.io.Writer;
import java.net.URI;
import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.core.util.DefaultXmlStreamWriter;
import org.eclipse.mylyn.wikitext.core.util.XmlStreamWriter;

public abstract class AbstractXmlDocumentBuilder
extends DocumentBuilder {
    private static final Pattern ABSOLUTE_URL_PATTERN = Pattern.compile("(([a-zA-Z]{3,8}://?.*)|(mailto:.*))");
    protected XmlStreamWriter writer;
    protected URI base;
    protected boolean baseInHead = false;

    public AbstractXmlDocumentBuilder(Writer out) {
        this.writer = this.createXmlStreamWriter(out);
    }

    public AbstractXmlDocumentBuilder(XmlStreamWriter writer) {
        this.writer = writer;
    }

    protected XmlStreamWriter createXmlStreamWriter(Writer out) {
        return new DefaultXmlStreamWriter(out);
    }

    public XmlStreamWriter getWriter() {
        return this.writer;
    }

    @Override
    public void characters(String text) {
        this.writer.writeCharacters(text);
    }

    protected String makeUrlAbsolute(String url) {
        if (this.base == null || this.baseInHead || url == null) {
            return url;
        }
        if (ABSOLUTE_URL_PATTERN.matcher(url).matches()) {
            return url;
        }
        if (url.startsWith("#")) {
            return url;
        }
        String absoluteUrl = this.base.toString();
        if (!absoluteUrl.endsWith("/") && !url.startsWith("/")) {
            absoluteUrl = String.valueOf(absoluteUrl) + '/';
        }
        absoluteUrl = String.valueOf(absoluteUrl) + url;
        return absoluteUrl;
    }

    protected boolean isExternalLink(String url) {
        if (url == null) {
            return false;
        }
        return ABSOLUTE_URL_PATTERN.matcher(url).matches() && (this.base == null || !url.startsWith(this.base.toString()));
    }

    @Override
    public void flush() {
        if (this.writer != null) {
            this.writer.flush();
        }
    }

    public void setBase(URI uri) {
        this.base = uri;
    }

    public URI getBase() {
        return this.base;
    }

    public boolean isBaseInHead() {
        return this.baseInHead;
    }

    public void setBaseInHead(boolean baseInHead) {
        this.baseInHead = baseInHead;
    }
}

