/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.db.publish;

import java.io.IOException;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.sql.DataSource;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.dirigible.ide.publish.AbstractPublisher;
import org.eclipse.dirigible.ide.publish.IPublisher;
import org.eclipse.dirigible.ide.publish.PublishException;
import org.eclipse.dirigible.ide.repository.RepositoryFacade;
import org.eclipse.dirigible.repository.api.ICollection;
import org.eclipse.dirigible.repository.api.IRepository;
import org.eclipse.dirigible.repository.datasource.DataSourceFacade;
import org.eclipse.dirigible.repository.ext.db.DatabaseUpdater;
import org.eclipse.dirigible.repository.ext.db.DsvUpdater;
import org.eclipse.dirigible.repository.ext.utils.CommonUtils;
import org.eclipse.dirigible.repository.logging.Logger;

public class DatabasePublisher
extends AbstractPublisher
implements IPublisher {
    private static final String DOT = ".";
    private static final Logger logger = Logger.getLogger(DatabasePublisher.class);

    public void publish(IProject project, HttpServletRequest request) throws PublishException {
        try {
            ICollection targetContainer = this.getTargetProjectContainer(this.getRegistryLocation(), request);
            IFolder sourceFolder = this.getSourceFolder(project, "DataStructures");
            this.copyAllFromTo((IContainer)sourceFolder, targetContainer, request);
            IRepository repository = RepositoryFacade.getInstance().getRepository(request);
            DataSource dataSource = DataSourceFacade.getInstance().getDataSource(request);
            ICollection sourceProjectContainer = this.getSourceProjectContainer(project, request);
            ICollection sourceContainer = sourceProjectContainer.getCollection("DataStructures");
            this.processTablesAndViews(sourceContainer, repository, dataSource);
            this.processDSV(sourceProjectContainer, repository, dataSource);
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            throw new PublishException(ex.getMessage(), (Throwable)ex);
        }
    }

    protected String getRegistryLocation() {
        return "/db/dirigible/registry/public/DataStructures";
    }

    public void activate(IProject project, HttpServletRequest request) throws PublishException {
        this.publish(project, request);
    }

    public void activateFile(IFile file, HttpServletRequest request) throws PublishException {
        this.publish(file.getProject(), request);
    }

    private void processTablesAndViews(ICollection targetContainer, IRepository repository, DataSource dataSource) throws IOException, Exception {
        ArrayList knownFiles = new ArrayList();
        DatabaseUpdater databaseUpdater = new DatabaseUpdater(repository, dataSource, this.getRegistryLocation());
        databaseUpdater.enumerateKnownFiles(targetContainer, knownFiles);
        ArrayList errors = new ArrayList();
        databaseUpdater.executeUpdate(knownFiles, errors);
        if (errors.size() > 0) {
            throw new PublishException(CommonUtils.concatenateListOfStrings(errors, (String)"\n"));
        }
    }

    private void processDSV(ICollection targetContainer, IRepository repository, DataSource dataSource) throws IOException, Exception {
        ArrayList knownFiles = new ArrayList();
        DsvUpdater dsvUpdater = new DsvUpdater(repository, dataSource, this.getRegistryLocation());
        dsvUpdater.enumerateKnownFiles(targetContainer, knownFiles);
        ArrayList errors = new ArrayList();
        dsvUpdater.executeUpdate(knownFiles, errors);
        if (errors.size() > 0) {
            throw new PublishException(CommonUtils.concatenateListOfStrings(errors, (String)"\n"));
        }
    }

    public String getFolderType() {
        return "DataStructures";
    }

    public boolean recognizedFile(IFile file) {
        return this.checkFolderType(file) && (".table".equals(DOT + file.getFileExtension()) || ".view".equals(DOT + file.getFileExtension()));
    }

    public String getPublishedContainerMapping(IFile file) {
        return null;
    }

    public String getActivatedContainerMapping(IFile file) {
        return null;
    }

    public boolean isAutoActivationAllowed() {
        return false;
    }

    protected String getSandboxLocation(HttpServletRequest request) {
        return null;
    }

    public void template(IProject project, HttpServletRequest request) throws PublishException {
    }
}

