/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.template.ui.js.wizard;

import java.util.ArrayList;
import java.util.Map;
import org.eclipse.dirigible.ide.template.ui.common.GenerationModel;
import org.eclipse.dirigible.ide.template.ui.common.TemplateGenerator;
import org.eclipse.dirigible.ide.template.ui.js.wizard.JavascriptServiceTemplateModel;
import org.eclipse.dirigible.ide.template.ui.js.wizard.TableColumn;
import org.eclipse.dirigible.repository.ext.utils.CommonUtils;
import org.eclipse.dirigible.repository.logging.Logger;

public class JavascriptServiceTemplateGenerator
extends TemplateGenerator {
    private static final Logger logger = Logger.getLogger(JavascriptServiceTemplateGenerator.class);
    private static final String LOG_TAG = "JAVASCRIPT_SERVICE_GENERATOR";
    private JavascriptServiceTemplateModel model;

    public JavascriptServiceTemplateGenerator(JavascriptServiceTemplateModel model) {
        this.model = model;
    }

    protected Map<String, Object> prepareParameters() {
        Map parameters = super.prepareParameters();
        parameters.put("tableName", this.model.getTableName());
        parameters.put("tableType", this.model.getTableType());
        parameters.put("entityName", CommonUtils.toCamelCase((String)this.model.getTableName()));
        parameters.put("tableColumns", this.model.getTableColumns());
        parameters.put("tableColumnsWithoutKeys", this.getTableColumnsWithoutKeys(this.model.getTableColumns()));
        parameters.put("primaryKey", this.getPrimaryKey());
        parameters.put("INTEGER", 4);
        parameters.put("BIGINT", -5);
        parameters.put("SMALLINT", 5);
        parameters.put("FLOAT", 7);
        parameters.put("DOUBLE", 8);
        parameters.put("VARCHAR", 12);
        parameters.put("CHAR", 1);
        parameters.put("DATE", 91);
        parameters.put("TIME", 92);
        parameters.put("TIMESTAMP", 93);
        parameters.put("BOOLEAN", 16);
        return parameters;
    }

    private Object getPrimaryKey() {
        if (this.model.getTableName() != null) {
            TableColumn[] columns = this.model.getTableColumns();
            TableColumn primaryKey = null;
            TableColumn[] tableColumnArray = columns;
            int n = columns.length;
            int n2 = 0;
            while (n2 < n) {
                TableColumn column = tableColumnArray[n2];
                if (column.isKey()) {
                    primaryKey = column;
                }
                ++n2;
            }
            if (primaryKey == null) {
                logger.error(String.format("There is no primary key in table %s, which can produce errornous artifacts", this.model.getTableName()));
                return null;
            }
            return primaryKey;
        }
        return null;
    }

    private TableColumn[] getTableColumnsWithoutKeys(TableColumn[] tableColumns) {
        if (tableColumns == null) {
            return null;
        }
        ArrayList<TableColumn> list = new ArrayList<TableColumn>();
        TableColumn[] tableColumnArray = tableColumns;
        int n = tableColumns.length;
        int n2 = 0;
        while (n2 < n) {
            TableColumn tableColumn2 = tableColumnArray[n2];
            TableColumn tableColumn = tableColumn2;
            if (!tableColumn.isKey()) {
                list.add(tableColumn);
            }
            ++n2;
        }
        return list.toArray(new TableColumn[0]);
    }

    protected GenerationModel getModel() {
        return this.model;
    }

    protected String getLogTag() {
        return LOG_TAG;
    }

    protected byte[] afterGeneration(byte[] bytes) {
        byte[] result = this.model.normalizeEscapes(bytes);
        return result;
    }
}

