/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.template.ui.js.wizard;

import java.sql.Connection;
import java.sql.ResultSet;
import java.util.ArrayList;
import org.eclipse.dirigible.ide.common.CommonIDEParameters;
import org.eclipse.dirigible.ide.template.ui.js.wizard.JavascriptServiceTemplateModel;
import org.eclipse.dirigible.ide.template.ui.js.wizard.Messages;
import org.eclipse.dirigible.ide.template.ui.js.wizard.TableName;
import org.eclipse.dirigible.ide.template.ui.js.wizard.TablesTemplateTablePageContentProvider;
import org.eclipse.dirigible.ide.template.ui.js.wizard.TablesTemplateTablePageLabelProvider;
import org.eclipse.dirigible.repository.datasource.DataSourceFacade;
import org.eclipse.dirigible.repository.ext.db.DBUtils;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.dialogs.FilteredTree;
import org.eclipse.ui.dialogs.PatternFilter;

public class TablesTemplateTablePage
extends WizardPage {
    private static final long serialVersionUID = -4198853177500786981L;
    private static final String ERROR_ON_LOADING_TABLES_FROM_DATABASE_FOR_GENERATION = Messages.TablesTemplateTablePage_ERROR_ON_LOADING_TABLES_FROM_DATABASE_FOR_GENERATION;
    private static final String AVAILABLE_TABLES_AND_VIEWS = Messages.TablesTemplateTablePage_AVAILABLE_TABLES_AND_VIEWS;
    private static final String SELECT_THE_TABLE_WHICH_WILL_BE_USED_DURING_GENERATION = Messages.TablesTemplateTablePage_SELECT_THE_TABLE_WHICH_WILL_BE_USED_DURING_GENERATION;
    private static final String SELECTION_OF_TABLE = Messages.TablesTemplateTablePage_SELECTION_OF_TABLE;
    private static final Logger logger = Logger.getLogger(TablesTemplateTablePage.class);
    private static final String PAGE_NAME = "org.eclipse.dirigible.ide.template.ui.odata.wizard.UIForODataTemplateTablePage";
    private JavascriptServiceTemplateModel model;
    private TreeViewer typeViewer;
    private Label labelSelected;

    protected TablesTemplateTablePage(JavascriptServiceTemplateModel model) {
        super(PAGE_NAME);
        this.model = model;
        this.setTitle(SELECTION_OF_TABLE);
        this.setDescription(SELECT_THE_TABLE_WHICH_WILL_BE_USED_DURING_GENERATION);
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        this.setControl((Control)composite);
        composite.setLayout((Layout)new GridLayout());
        this.createTableField(composite);
        this.checkPageStatus();
    }

    private void createTableField(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(AVAILABLE_TABLES_AND_VIEWS);
        label.setLayoutData((Object)new GridData(16384, 1024, false, false));
        PatternFilter filter = new PatternFilter();
        FilteredTree tree = new FilteredTree(parent, 770, filter, true);
        this.typeViewer = tree.getViewer();
        this.typeViewer.getControl().setLayoutData((Object)new GridData(4, 4, true, true));
        this.typeViewer.setContentProvider((IContentProvider)new TablesTemplateTablePageContentProvider());
        this.typeViewer.setLabelProvider((IBaseLabelProvider)new TablesTemplateTablePageLabelProvider());
        this.typeViewer.setSorter(new ViewerSorter());
        TableName[] tableNames = this.createTableNames();
        this.typeViewer.setInput((Object)tableNames);
        this.typeViewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                TablesTemplateTablePage.this.updateTableNames();
                TablesTemplateTablePage.this.checkPageStatus();
            }
        });
        this.updateTableNames();
        this.labelSelected = new Label(parent, 0);
        this.labelSelected.setText("");
        this.labelSelected.setLayoutData((Object)new GridData(16384, 1024, true, false));
    }

    private void updateTableNames() {
        if (this.typeViewer.getTree().getSelection() != null && this.typeViewer.getTree().getSelection().length > 0) {
            TableName selectedTableName = (TableName)this.typeViewer.getTree().getSelection()[0].getData();
            if (selectedTableName != null) {
                this.model.setTableName(selectedTableName.getName());
                this.model.setTableType(selectedTableName.getType());
                this.labelSelected.setText(selectedTableName.getName());
                this.labelSelected.pack();
            } else {
                this.model.setTableName(null);
                this.model.setTableType(null);
                this.labelSelected.setText("");
                this.labelSelected.pack();
            }
        } else {
            this.model.setTableName(null);
            this.model.setTableType(null);
        }
    }

    private TableName[] createTableNames() {
        ArrayList<TableName> availableTableNames = new ArrayList<TableName>();
        try {
            Connection connection = null;
            try {
                connection = DataSourceFacade.getInstance().getDataSource(CommonIDEParameters.getRequest()).getConnection();
                ResultSet tableNames = DBUtils.getAllTables((Connection)connection);
                while (tableNames.next()) {
                    String sTableName = tableNames.getString("TABLE_NAME");
                    String sTableType = tableNames.getString("TABLE_TYPE");
                    if (!"TABLE".equals(sTableType) && !"VIEW".equals(sTableType)) continue;
                    TableName tableName = new TableName(sTableName, sTableType);
                    availableTableNames.add(tableName);
                }
            }
            finally {
                if (connection != null) {
                    connection.close();
                }
            }
        }
        catch (Exception e) {
            logger.error(ERROR_ON_LOADING_TABLES_FROM_DATABASE_FOR_GENERATION, (Throwable)e);
        }
        return availableTableNames.toArray(new TableName[0]);
    }

    private void checkPageStatus() {
        this.setPageComplete(this.model.validateTableName());
    }
}

