/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.actions;

import com.ibm.icu.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourceAttributes;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;

public class ReadOnlyStateChecker {
    private Shell shell;
    private String titleMessage;
    private String mainMessage;
    private boolean yesToAllSelected = false;
    private boolean cancelSelected = false;
    private boolean ignoreLinkedResources = false;
    private String READ_ONLY_EXCEPTION_MESSAGE = IDEWorkbenchMessages.ReadOnlyCheck_problems;

    public ReadOnlyStateChecker(Shell parent, String title, String message) {
        this.shell = parent;
        this.titleMessage = title;
        this.mainMessage = message;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean checkAcceptedResource(IResource resourceToCheck, List<IResource> selectedChildren) throws CoreException {
        if (resourceToCheck.getType() == 1) {
            selectedChildren.add(resourceToCheck);
            return true;
        } else if (this.getIgnoreLinkedResources() && resourceToCheck.isLinked()) {
            selectedChildren.add(resourceToCheck);
            return true;
        } else {
            IContainer container = (IContainer)resourceToCheck;
            if (container.isAccessible()) {
                int childCheck = this.checkReadOnlyResources(container.members(), selectedChildren);
                if (childCheck != 4) return false;
                selectedChildren.add(resourceToCheck);
                return true;
            } else {
                selectedChildren.add(resourceToCheck);
            }
        }
        return true;
    }

    public IResource[] checkReadOnlyResources(IResource[] itemsToCheck) {
        ArrayList<IResource> selections = new ArrayList<IResource>();
        int result = 1;
        try {
            result = this.checkReadOnlyResources(itemsToCheck, selections);
        }
        catch (CoreException exception) {
            this.shell.getDisplay().syncExec(new Runnable(){

                @Override
                public void run() {
                    ErrorDialog.openError((Shell)ReadOnlyStateChecker.this.shell, (String)ReadOnlyStateChecker.this.READ_ONLY_EXCEPTION_MESSAGE, null, (IStatus)exception.getStatus());
                }
            });
        }
        if (result == 1) {
            return new IResource[0];
        }
        if (result == 4) {
            return itemsToCheck;
        }
        IResource[] returnValue = new IResource[selections.size()];
        selections.toArray(returnValue);
        return returnValue;
    }

    private int checkReadOnlyResources(IResource[] itemsToCheck, List<IResource> allSelected) throws CoreException {
        if (this.yesToAllSelected) {
            return 4;
        }
        boolean noneSkipped = true;
        ArrayList<IResource> selectedChildren = new ArrayList<IResource>();
        int i = 0;
        while (i < itemsToCheck.length) {
            IResource resourceToCheck = itemsToCheck[i];
            ResourceAttributes checkAttributes = resourceToCheck.getResourceAttributes();
            if (!this.yesToAllSelected && this.shouldCheck(resourceToCheck) && checkAttributes != null && checkAttributes.isReadOnly()) {
                boolean childResult;
                int action = this.queryYesToAllNoCancel(resourceToCheck);
                if (action == 2 && !(childResult = this.checkAcceptedResource(resourceToCheck, selectedChildren))) {
                    noneSkipped = false;
                }
                if (action == 3) {
                    noneSkipped = false;
                }
                if (action == 1) {
                    this.cancelSelected = true;
                    return 1;
                }
                if (action == 4) {
                    this.yesToAllSelected = true;
                    selectedChildren.add(resourceToCheck);
                }
            } else {
                boolean childResult = this.checkAcceptedResource(resourceToCheck, selectedChildren);
                if (this.cancelSelected) {
                    return 1;
                }
                if (!childResult) {
                    noneSkipped = false;
                }
            }
            ++i;
        }
        if (noneSkipped) {
            return 4;
        }
        allSelected.addAll(selectedChildren);
        return 3;
    }

    private boolean shouldCheck(IResource resourceToCheck) {
        return !this.ignoreLinkedResources || !resourceToCheck.isLinked();
    }

    private int queryYesToAllNoCancel(IResource resource) {
        final MessageDialog dialog = new MessageDialog(this.shell, this.titleMessage, null, MessageFormat.format((String)this.mainMessage, (Object[])new Object[]{resource.getName()}), 3, new String[]{IDialogConstants.get().YES_LABEL, IDialogConstants.get().YES_TO_ALL_LABEL, IDialogConstants.get().NO_LABEL, IDialogConstants.get().CANCEL_LABEL}, 0);
        this.shell.getDisplay().syncExec(new Runnable(){

            @Override
            public void run() {
                dialog.open();
            }
        });
        int result = dialog.getReturnCode();
        if (result == 0) {
            return 2;
        }
        if (result == 1) {
            return 4;
        }
        if (result == 2) {
            return 3;
        }
        return 1;
    }

    public boolean getIgnoreLinkedResources() {
        return this.ignoreLinkedResources;
    }

    public void setIgnoreLinkedResources(boolean ignore) {
        this.ignoreLinkedResources = ignore;
    }
}

