/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.bridge;

import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.dirigible.ide.bridge.AnonymousUserInjector;
import org.eclipse.dirigible.ide.bridge.CmisInjector;
import org.eclipse.dirigible.ide.bridge.ConnectivityInjector;
import org.eclipse.dirigible.ide.bridge.DatabaseInjector;
import org.eclipse.dirigible.ide.bridge.IInjector;
import org.eclipse.dirigible.ide.bridge.InitParametersInjector;
import org.eclipse.dirigible.ide.bridge.InitialContextInjector;
import org.eclipse.dirigible.ide.bridge.LocalParametersInjector;
import org.eclipse.dirigible.ide.bridge.MailInjector;
import org.eclipse.dirigible.ide.bridge.ProxyParametersInjector;
import org.eclipse.equinox.servletbridge.BridgeServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DirigibleBridge
extends BridgeServlet {
    private static final long serialVersionUID = -8043662807856187626L;
    private static final Logger logger = LoggerFactory.getLogger((String)DirigibleBridge.class.getCanonicalName());
    static Properties ENV_PROPERTIES = new Properties();
    static Class<IInjector>[] INJECTOR_CLASSES;
    public static Map<String, Object> BRIDGES;

    static {
        BRIDGES = Collections.synchronizedMap(new HashMap());
        INJECTOR_CLASSES = new Class[]{InitParametersInjector.class, InitialContextInjector.class, DatabaseInjector.class, ProxyParametersInjector.class, LocalParametersInjector.class, MailInjector.class, ConnectivityInjector.class, CmisInjector.class, AnonymousUserInjector.class};
    }

    public void init() throws ServletException {
        ENV_PROPERTIES.putAll((Map<?, ?>)System.getProperties());
        for (Object property : ENV_PROPERTIES.keySet()) {
            logger.info("SYSTEM_" + property + ": " + ENV_PROPERTIES.getProperty(property.toString()));
        }
        ServletConfig servletConfig = this.getServletConfig();
        Class<IInjector>[] classArray = INJECTOR_CLASSES;
        int n = INJECTOR_CLASSES.length;
        int n2 = 0;
        while (n2 < n) {
            Class<IInjector> injectorClass = classArray[n2];
            try {
                IInjector injector = injectorClass.newInstance();
                injector.injectOnStart(servletConfig);
            }
            catch (InstantiationException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            catch (Throwable e) {
                logger.error(e.getMessage(), e);
            }
            ++n2;
        }
        super.init();
    }

    protected void service(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        ServletConfig servletConfig = this.getServletConfig();
        Class<IInjector>[] classArray = INJECTOR_CLASSES;
        int n = INJECTOR_CLASSES.length;
        int n2 = 0;
        while (n2 < n) {
            Class<IInjector> injectorClass = classArray[n2];
            try {
                IInjector injector = injectorClass.newInstance();
                injector.injectOnRequest(servletConfig, req, resp);
            }
            catch (InstantiationException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            catch (IllegalAccessException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
            catch (Throwable e) {
                logger.error(e.getMessage(), e);
            }
            ++n2;
        }
        super.service(req, resp);
    }
}

