/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.integration.publish;

import javax.servlet.http.HttpServletRequest;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.dirigible.ide.common.CommonIDEParameters;
import org.eclipse.dirigible.ide.publish.AbstractPublisher;
import org.eclipse.dirigible.ide.publish.IPublisher;
import org.eclipse.dirigible.ide.publish.PublishException;
import org.eclipse.dirigible.ide.repository.RepositoryFacade;
import org.eclipse.dirigible.repository.api.ICollection;
import org.eclipse.dirigible.repository.datasource.DataSourceFacade;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.dirigible.runtime.listener.ListenersUpdater;

public class IntegrationPublisher
extends AbstractPublisher
implements IPublisher {
    private static final Logger logger = Logger.getLogger(IntegrationPublisher.class);

    public void publish(IProject project, HttpServletRequest request) throws PublishException {
        try {
            ICollection targetContainer = this.getTargetProjectContainer(this.getRegistryLocation(), request);
            IFolder sourceFolder = this.getSourceFolder(project, "IntegrationServices");
            this.copyAllFromTo((IContainer)sourceFolder, targetContainer, request);
            ListenersUpdater listenersUpdater = new ListenersUpdater(RepositoryFacade.getInstance().getRepository(request), DataSourceFacade.getInstance().getDataSource(request), this.getRegistryLocation());
            listenersUpdater.applyUpdates();
        }
        catch (Exception ex) {
            logger.error(ex.getMessage(), (Throwable)ex);
            throw new PublishException(ex.getMessage(), (Throwable)ex);
        }
    }

    public void activate(IProject project, HttpServletRequest request) throws PublishException {
        this.publish(project, request);
    }

    public void activateFile(IFile file, HttpServletRequest request) throws PublishException {
        this.publish(file.getProject(), request);
    }

    public String getFolderType() {
        return "IntegrationServices";
    }

    public boolean recognizedFile(IFile file) {
        return this.checkFolderType(file) && ("flow".equals(file.getFileExtension()) || "job".equals(file.getFileExtension()) || "listener".equals(file.getFileExtension()));
    }

    public String getPublishedContainerMapping(IFile file) {
        if ("flow".equals(file.getFileExtension())) {
            return "/flow";
        }
        if ("job".equals(file.getFileExtension())) {
            return "/job";
        }
        if ("listener".equals(file.getFileExtension())) {
            return "/listener";
        }
        return null;
    }

    public String getActivatedContainerMapping(IFile file) {
        if ("flow".equals(file.getFileExtension())) {
            return "/flow-sandbox";
        }
        if ("job".equals(file.getFileExtension())) {
            return "/job-sandbox";
        }
        if ("job".equals(file.getFileExtension())) {
            return "/listener-sandbox";
        }
        return null;
    }

    public boolean isAutoActivationAllowed() {
        return true;
    }

    protected String getSandboxLocation(HttpServletRequest request) {
        return CommonIDEParameters.getIntegrationContentSandbox((HttpServletRequest)request);
    }

    protected String getRegistryLocation() {
        return "/db/dirigible/registry/public/IntegrationServices";
    }

    public void template(IProject project, HttpServletRequest request) throws PublishException {
    }
}

