/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.publish.ui.command;

import javax.servlet.http.HttpServletRequest;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.resources.IProject;
import org.eclipse.dirigible.ide.common.CommonIDEParameters;
import org.eclipse.dirigible.ide.common.status.StatusLineManagerUtil;
import org.eclipse.dirigible.ide.publish.PublishException;
import org.eclipse.dirigible.ide.publish.PublishManager;
import org.eclipse.dirigible.ide.publish.ui.command.PublishCommandMessages;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.handlers.HandlerUtil;

public class PublishCommandHandler
extends AbstractHandler {
    private static final String NO_PROJECTS_IN_SELECTION_NOTHING_TO_PUBLISH = PublishCommandMessages.NO_PROJECTS_IN_SELECTION_NOTHING_TO_PUBLISH;
    private static final String NOTHING_IS_SELECTED_TO_BE_PUBLISHED = PublishCommandMessages.NOTHING_IS_SELECTED_TO_BE_PUBLISHED;
    private static final Logger logger = Logger.getLogger(PublishCommandHandler.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        ISelection selection = HandlerUtil.getActiveMenuSelection((ExecutionEvent)event);
        return this.executeOnSelection(selection);
    }

    protected Object executeOnSelection(ISelection selection) {
        if (selection.isEmpty()) {
            logger.warn(NOTHING_IS_SELECTED_TO_BE_PUBLISHED);
            return null;
        }
        IProject[] projects = PublishManager.getProjects((ISelection)selection);
        if (projects.length == 0) {
            logger.warn(NO_PROJECTS_IN_SELECTION_NOTHING_TO_PUBLISH);
            return null;
        }
        StatusLineManagerUtil.setInfoMessage((String)"");
        boolean success = true;
        String errorMessage = null;
        IProject[] iProjectArray = projects;
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            try {
                this.publishProject(project);
                StatusLineManagerUtil.setInfoMessage((String)String.format(this.getStatusMessage(), project.getName()));
            }
            catch (Exception ex) {
                errorMessage = ex.getMessage();
                logger.error(errorMessage, (Throwable)ex);
                success = false;
            }
            ++n2;
        }
        if (!success) {
            logger.error(errorMessage);
            StatusLineManagerUtil.setErrorMessage(errorMessage);
            MessageDialog.openError(null, (String)PublishCommandMessages.PUBLISH_FAIL_TITLE, (String)errorMessage);
        }
        return null;
    }

    protected String getStatusMessage() {
        return StatusLineManagerUtil.ARTIFACT_HAS_BEEN_PUBLISHED;
    }

    protected void publishProject(IProject project) throws PublishException {
        PublishManager.publishProject((IProject)project, (HttpServletRequest)CommonIDEParameters.getRequest());
    }
}

