/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.template.ui.html.service;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import javax.servlet.http.HttpServletRequest;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.dirigible.ide.common.status.LogProgressMonitor;
import org.eclipse.dirigible.ide.template.ui.common.GenerationException;
import org.eclipse.dirigible.ide.template.ui.common.TemplateType;
import org.eclipse.dirigible.ide.template.ui.common.TemplateTypesEnumerator;
import org.eclipse.dirigible.ide.template.ui.common.service.AbstractGenerationWorker;
import org.eclipse.dirigible.ide.template.ui.html.service.WebContentTemplateTypeDiscriminator;
import org.eclipse.dirigible.ide.template.ui.html.wizard.HtmlTemplateGenerator;
import org.eclipse.dirigible.ide.template.ui.html.wizard.HtmlTemplateModel;
import org.eclipse.dirigible.repository.api.IRepository;

public class WebContentGenerationWorker
extends AbstractGenerationWorker {
    private static final String PARAM_PAGE_TITLE = "pageTitle";

    public WebContentGenerationWorker(IRepository repository, IWorkspace workspace) {
        super(repository, workspace);
    }

    public String generate(String parameters, HttpServletRequest request) throws GenerationException {
        try {
            JsonElement parametersElement = new JsonParser().parse(parameters);
            JsonObject parametersObject = parametersElement.getAsJsonObject();
            HtmlTemplateModel model = new HtmlTemplateModel();
            HtmlTemplateGenerator generator = new HtmlTemplateGenerator(model);
            TemplateType[] templates = TemplateTypesEnumerator.prepareTemplateTypes((String)WebContentTemplateTypeDiscriminator.getTemplatesPath(), (String)WebContentTemplateTypeDiscriminator.getCategory(), (HttpServletRequest)request);
            this.setParametersToModel(parametersObject, model, templates);
            generator.generate(request);
        }
        catch (Exception e) {
            throw new GenerationException((Throwable)e);
        }
        return "Generation passed successfully.";
    }

    protected void setParametersToModel(JsonObject parametersObject, HtmlTemplateModel model, TemplateType[] templates) throws GenerationException {
        IProject project;
        if (parametersObject.has("templateType")) {
            String templateType = parametersObject.get("templateType").getAsString();
            TemplateType[] templateTypeArray = templates;
            int n = templates.length;
            int n2 = 0;
            while (n2 < n) {
                TemplateType template = templateTypeArray[n2];
                if (template.getLocation().substring(WebContentTemplateTypeDiscriminator.getTemplatesPath().length()).indexOf(String.valueOf(templateType) + "/") == 0) {
                    model.setTemplate(template);
                    break;
                }
                ++n2;
            }
            if (model.getTemplate() == null) {
                throw new GenerationException(String.format("Template %s does not exist in this instance", templateType));
            }
        } else {
            throw new GenerationException(String.format("Mandatory parameter [%s] has not been provided", "templateType"));
        }
        if (!parametersObject.has("fileName")) {
            throw new GenerationException(String.format("Mandatory parameter [%s] has not been provided", "fileName"));
        }
        model.setFileName(parametersObject.get("fileName").getAsString());
        if (parametersObject.has("projectName")) {
            String projectName = parametersObject.get("projectName").getAsString();
            project = this.getWorkspace().getRoot().getProject(projectName);
            if (!project.exists()) {
                try {
                    project.create((IProgressMonitor)new LogProgressMonitor());
                }
                catch (CoreException e) {
                    throw new GenerationException((Throwable)e);
                }
            }
        } else {
            throw new GenerationException(String.format("Mandatory parameter [%s] has not been provided", "projectName"));
        }
        model.setTargetContainer(project.getFullPath().toString());
        if (!parametersObject.has("packageName")) {
            throw new GenerationException(String.format("Mandatory parameter [%s] has not been provided", "packageName"));
        }
        String packageName = parametersObject.get("packageName").getAsString();
        model.setProjectPackageName("WebContent/" + packageName);
        model.setPackageName(packageName);
        if (parametersObject.has(PARAM_PAGE_TITLE)) {
            model.setPageTitle(parametersObject.get(PARAM_PAGE_TITLE).getAsString());
        } else {
            this.checkIfRequired(model, PARAM_PAGE_TITLE);
        }
    }

    public String getTemplates(HttpServletRequest request) throws GenerationException {
        try {
            TemplateType[] templates = TemplateTypesEnumerator.prepareTemplateTypes((String)WebContentTemplateTypeDiscriminator.getTemplatesPath(), (String)WebContentTemplateTypeDiscriminator.getCategory(), (HttpServletRequest)request);
            String result = new Gson().toJson((Object)templates);
            return result;
        }
        catch (Exception e) {
            throw new GenerationException((Throwable)e);
        }
    }
}

