/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.repository.db.init;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import javax.sql.DataSource;
import org.eclipse.dirigible.repository.db.init.Messages;
import org.eclipse.dirigible.repository.ext.db.DBUtils;
import org.eclipse.dirigible.repository.logging.Logger;

public class DBRepositoryInitializer {
    private static final String MESSAGING_HUB = Messages.getString("DBRepositoryInitializer.MESSAGING_HUB");
    private static final String IT_SEEMS_DGB_SCHEMA_VERSIONS_DOESN_T_EXISTS_CHECK_WHETHER_THIS_MESSAGE_HAS_BEEN_APPEARING_MORE_THAN_ONCE = Messages.getString("DBRepositoryInitializer.IT_SEEMS_DGB_SCHEMA_VERSIONS_DOESN_T_EXISTS_CHECK_WHETHER_THIS_MESSAGE_HAS_BEEN_APPEARING_MORE_THAN_ONCE");
    private static final String EXTENSION_POINTS = Messages.getString("DBRepositoryInitializer.EXTENSION_POINTS");
    private static final String INITIALIZING_SCRIPT_VERSION_S_FROM_S_ABOUT_S = Messages.getString("DBRepositoryInitializer.INITIALIZING_SCRIPT_VERSION_S_FROM_S_ABOUT_S");
    private static final String SECURITY_FEATURES = Messages.getString("DBRepositoryInitializer.SECURITY_FEATURES");
    private static final String FILE_VERSIONS_SUPPORT = Messages.getString("DBRepositoryInitializer.FILE_VERSIONS_SUPPORT");
    private static final String FREE_TEXT_SEARCH_IN_DOCUMENTS = Messages.getString("DBRepositoryInitializer.FREE_TEXT_SEARCH_IN_DOCUMENTS");
    private static final String TEST_UPDATE = Messages.getString("DBRepositoryInitializer.TEST_UPDATE");
    private static final String INITIAL_CREATION = Messages.getString("DBRepositoryInitializer.INITIAL_CREATION");
    private static Logger logger = Logger.getLogger(DBRepositoryInitializer.class);
    private static final String TABLE_NAME_DGB_SCHEMA_VERSIONS = "DGB_SCHEMA_VERSIONS";
    private static final String TABLE_COLUMN_SCHV_VERSION = "SCHV_VERSION";
    private DBUtils dbUtils;
    private Connection connection;
    private boolean forceRecreate;
    static List<ScriptDescriptor> scriptDescriptors = new ArrayList<ScriptDescriptor>();

    static {
        scriptDescriptors.add(new ScriptDescriptor(1, INITIAL_CREATION, "/org/eclipse/dirigible/repository/db/sql/create_schema_1.sql"));
        scriptDescriptors.add(new ScriptDescriptor(2, TEST_UPDATE, "/org/eclipse/dirigible/repository/db/sql/create_schema_2.sql"));
        scriptDescriptors.add(new ScriptDescriptor(3, FREE_TEXT_SEARCH_IN_DOCUMENTS, "/org/eclipse/dirigible/repository/db/sql/create_schema_3.sql"));
        scriptDescriptors.add(new ScriptDescriptor(4, FILE_VERSIONS_SUPPORT, "/org/eclipse/dirigible/repository/db/sql/create_schema_4.sql"));
        scriptDescriptors.add(new ScriptDescriptor(5, SECURITY_FEATURES, "/org/eclipse/dirigible/repository/db/sql/create_schema_5.sql"));
        scriptDescriptors.add(new ScriptDescriptor(6, EXTENSION_POINTS, "/org/eclipse/dirigible/repository/db/sql/create_schema_6.sql"));
        scriptDescriptors.add(new ScriptDescriptor(7, MESSAGING_HUB, "/org/eclipse/dirigible/repository/db/sql/create_schema_7.sql"));
    }

    public DBRepositoryInitializer(DataSource dataSource, Connection connection, boolean forceRecreate) {
        logger.debug("entering constructor");
        this.dbUtils = new DBUtils(dataSource);
        this.connection = connection;
        this.forceRecreate = forceRecreate;
        logger.debug("exiting constructor");
    }

    public boolean initialize() {
        boolean result = false;
        logger.debug("entering initialize");
        result = this.forceRecreate ? this.forceRecreate() : this.updateIncrements();
        logger.debug("exiting initialize");
        return result;
    }

    private boolean forceRecreate() {
        logger.warn("entering forceRecreate");
        boolean result = false;
        for (ScriptDescriptor scriptDescriptor : scriptDescriptors) {
            logger.info(String.format(INITIALIZING_SCRIPT_VERSION_S_FROM_S_ABOUT_S, scriptDescriptor.version, scriptDescriptor.location, scriptDescriptor.description));
            String script = null;
            try {
                script = this.dbUtils.readScript(this.connection, scriptDescriptor.location, this.getClass());
                result = this.dbUtils.executeUpdate(this.connection, script);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                logger.error(script);
            }
            if (!result) break;
        }
        logger.warn("exiting forceRecreate");
        return result;
    }

    private boolean updateIncrements() {
        block9: {
            PreparedStatement preparedStatement;
            Connection connection;
            block8: {
                logger.debug("updateIncrements");
                connection = null;
                preparedStatement = null;
                String script = null;
                try {
                    try {
                        connection = this.dbUtils.getConnection();
                        script = this.dbUtils.readScript(connection, "/org/eclipse/dirigible/repository/db/sql/get_schema_version.sql", this.getClass());
                        if (this.versionExists()) {
                            preparedStatement = this.dbUtils.getPreparedStatement(connection, script);
                            ResultSet resultSet = preparedStatement.executeQuery();
                            if (resultSet.next()) {
                                int version = resultSet.getInt(TABLE_COLUMN_SCHV_VERSION);
                                for (ScriptDescriptor scriptDescriptor : scriptDescriptors) {
                                    if (scriptDescriptor.version <= version) continue;
                                    logger.warn(String.format(INITIALIZING_SCRIPT_VERSION_S_FROM_S_ABOUT_S, scriptDescriptor.version, scriptDescriptor.location, scriptDescriptor.description));
                                    script = this.dbUtils.readScript(connection, scriptDescriptor.location, this.getClass());
                                    boolean result = this.dbUtils.executeUpdate(connection, script);
                                    if (result) {
                                        continue;
                                    }
                                    break block8;
                                }
                                break block8;
                            }
                            this.forceRecreate();
                            break block8;
                        }
                        this.forceRecreate();
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), (Throwable)e);
                        logger.error(script);
                        this.dbUtils.closeStatement(preparedStatement);
                        this.dbUtils.closeConnection(connection);
                        break block9;
                    }
                }
                catch (Throwable throwable) {
                    this.dbUtils.closeStatement(preparedStatement);
                    this.dbUtils.closeConnection(connection);
                    throw throwable;
                }
            }
            this.dbUtils.closeStatement((Statement)preparedStatement);
            this.dbUtils.closeConnection(connection);
        }
        logger.debug("exiting updateIncrements");
        return true;
    }

    private boolean versionExists() throws SQLException {
        boolean exists = DBUtils.isTableOrViewExists((Connection)this.connection, (String)TABLE_NAME_DGB_SCHEMA_VERSIONS);
        if (!exists) {
            logger.warn(IT_SEEMS_DGB_SCHEMA_VERSIONS_DOESN_T_EXISTS_CHECK_WHETHER_THIS_MESSAGE_HAS_BEEN_APPEARING_MORE_THAN_ONCE);
        }
        return exists;
    }

    static class ScriptDescriptor {
        int version;
        String description;
        String location;

        public ScriptDescriptor(int version, String description, String location) {
            this.version = version;
            this.description = description;
            this.location = location;
        }
    }
}

