/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.content;

import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.zip.ZipInputStream;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.FileUploadException;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.dirigible.runtime.PermissionsUtils;
import org.eclipse.dirigible.runtime.content.ContentBaseServlet;
import org.eclipse.dirigible.runtime.content.ContentPostImportUpdater;

public class ProjectImporterServlet
extends ContentBaseServlet {
    private static final long serialVersionUID = -2889019459717507121L;
    private static final Logger logger = Logger.getLogger(ProjectImporterServlet.class);
    private static final String DEFAULT_PATH_FOR_IMPORT = "/db/dirigible/registry/";
    private static final String PARAMETER_OVERRIDE = "override";
    private static final String HEADER_OVERRIDE = "override";

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        block7: {
            if (!PermissionsUtils.isUserInRole((HttpServletRequest)request, (String)"Operator")) {
                String err = String.format("%s called, but the user does not have permissions to do this operation", "Import");
                logger.debug(err);
                throw new ServletException(err);
            }
            boolean isMultipart = ServletFileUpload.isMultipartContent((HttpServletRequest)request);
            boolean override = Boolean.parseBoolean(request.getParameter("override")) || Boolean.parseBoolean(request.getHeader("override"));
            try {
                if (isMultipart) {
                    DiskFileItemFactory factory = new DiskFileItemFactory();
                    ServletFileUpload upload = new ServletFileUpload((FileItemFactory)factory);
                    try {
                        List items = upload.parseRequest(request);
                        logger.debug("Importing multiple content...");
                        for (FileItem fileItem : items) {
                            logger.debug("Importing " + fileItem.getFieldName());
                            InputStream in = fileItem.getInputStream();
                            this.importZipAndUpdate(in, request, override);
                            logger.debug("Content imported.");
                        }
                        break block7;
                    }
                    catch (FileUploadException e) {
                        logger.error(e.getMessage(), (Throwable)e);
                        response.sendError(500);
                    }
                    break block7;
                }
                logger.debug("Importing single content...");
                ServletInputStream in = request.getInputStream();
                this.importZipAndUpdate((InputStream)in, request, override);
                logger.debug("Content imported.");
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                response.sendError(500, e.getMessage());
            }
        }
    }

    protected String getDefaultPathForImport() {
        return DEFAULT_PATH_FOR_IMPORT;
    }

    private void importZipAndUpdate(InputStream content, HttpServletRequest request, boolean override) throws Exception {
        this.importZipAndUpdate(content, this.getDefaultPathForImport(), request, override, true);
    }

    private void importZipAndUpdate(InputStream content, String pathForImport, HttpServletRequest request, boolean override, boolean excludeRootFolderName) throws Exception {
        this.getRepository(request).importZip(new ZipInputStream(content), pathForImport, override, excludeRootFolderName);
        this.postImport(request);
    }

    private void postImport(HttpServletRequest request) throws IOException, Exception {
        ContentPostImportUpdater contentPostImportUpdater = new ContentPostImportUpdater(this.getRepository(request));
        contentPostImportUpdater.update(request);
    }
}

