/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql.compile;

import java.util.Properties;
import org.apache.derby.iapi.error.StandardException;
import org.apache.derby.iapi.services.compiler.MethodBuilder;
import org.apache.derby.iapi.services.context.ContextManager;
import org.apache.derby.iapi.util.JBitSet;
import org.apache.derby.impl.sql.compile.ActivationClassBuilder;
import org.apache.derby.impl.sql.compile.OrderByList;
import org.apache.derby.impl.sql.compile.ResultColumn;
import org.apache.derby.impl.sql.compile.ResultColumnList;
import org.apache.derby.impl.sql.compile.ResultSetNode;
import org.apache.derby.impl.sql.compile.SingleChildResultSetNode;
import org.apache.derby.impl.sql.compile.ValueNode;

class NormalizeResultSetNode
extends SingleChildResultSetNode {
    private boolean forUpdate;

    NormalizeResultSetNode(ResultSetNode resultSetNode, ResultColumnList resultColumnList, Properties properties, boolean bl, ContextManager contextManager) throws StandardException {
        super(resultSetNode, properties, contextManager);
        this.forUpdate = bl;
        ResultColumnList resultColumnList2 = resultSetNode.getResultColumns();
        ResultColumnList resultColumnList3 = resultColumnList;
        ResultColumnList resultColumnList4 = resultColumnList2;
        resultSetNode.setResultColumns(resultColumnList2.copyListAndObjects());
        resultColumnList4.removeGeneratedGroupingColumns();
        resultColumnList4.removeOrderByColumns();
        resultColumnList4.genVirtualColumnNodes(resultSetNode, resultSetNode.getResultColumns());
        this.setResultColumns(resultColumnList4);
        if (resultSetNode.getReferencedTableMap() != null) {
            this.setReferencedTableMap((JBitSet)this.getReferencedTableMap().clone());
        }
        if (resultColumnList != null) {
            int n = Math.min(resultColumnList3.size(), this.getResultColumns().size());
            for (int i = 0; i < n; ++i) {
                ResultColumn resultColumn = (ResultColumn)this.getResultColumns().elementAt(i);
                ResultColumn resultColumn2 = (ResultColumn)resultColumnList3.elementAt(i);
                resultColumn.setType(resultColumn2.getTypeServices());
            }
        }
    }

    @Override
    void generate(ActivationClassBuilder activationClassBuilder, MethodBuilder methodBuilder) throws StandardException {
        this.assignResultSetNumber();
        this.setCostEstimate(this.childResult.getFinalCostEstimate());
        int n = activationClassBuilder.addItem(this.makeResultDescription());
        activationClassBuilder.pushGetResultSetFactoryExpression(methodBuilder);
        this.childResult.generate(activationClassBuilder, methodBuilder);
        methodBuilder.push(this.getResultSetNumber());
        methodBuilder.push(n);
        methodBuilder.push(this.getCostEstimate().rowCount());
        methodBuilder.push(this.getCostEstimate().getEstimatedCost());
        methodBuilder.push(this.forUpdate);
        methodBuilder.callMethod((short)185, null, "getNormalizeResultSet", "org.apache.derby.iapi.sql.execute.NoPutResultSet", 6);
    }

    @Override
    void setRefActionInfo(long l, int[] nArray, String string, boolean bl) {
        this.childResult.setRefActionInfo(l, nArray, string, bl);
    }

    @Override
    public void pushQueryExpressionSuffix() {
        this.childResult.pushQueryExpressionSuffix();
    }

    @Override
    void pushOrderByList(OrderByList orderByList) {
        this.childResult.pushOrderByList(orderByList);
    }

    @Override
    void pushOffsetFetchFirst(ValueNode valueNode, ValueNode valueNode2, boolean bl) {
        this.childResult.pushOffsetFetchFirst(valueNode, valueNode2, bl);
    }
}

