/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.bridge;

import java.io.IOException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.Enumeration;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.sql.DataSource;
import org.eclipse.dirigible.ide.bridge.IInjector;
import org.eclipse.dirigible.ide.bridge.InitParametersInjector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseInjector
implements IInjector {
    public static final String DATASOURCE_DEFAULT = "DEFAULT_DATASOURCE";
    public static final String DATABASE_PRODUCT_NAME = "DATABASE_PRODUCT_NAME";
    public static final String DATABASE_PRODUCT_VERSION = "DATABASE_PRODUCT_VERSION";
    public static final String DATABASE_MINOR_VERSION = "DATABASE_MINOR_VERSION";
    public static final String DATABASE_MAJOR_VERSION = "DATABASE_MAJOR_VERSION";
    public static final String DATABASE_DRIVER_NAME = "DATABASE_DRIVER_NAME";
    public static final String DATABASE_DRIVER_MINOR_VERSION = "DATABASE_DRIVER_MINOR_VERSION";
    public static final String DATABASE_DRIVER_MAJOR_VERSION = "DATABASE_DRIVER_MAJOR_VERSION";
    public static final String DATABASE_CONNECTION_CLASS_NAME = "DATABASE_CONNECTION_CLASS_NAME";
    public static final String CUSTOM_DATASOURCE_PARAM_PREFIX = "jndiCustomDataSource-";
    public static final String DATASOURCE_PREFIX = "DATASOURCE_";
    private static final Logger logger = LoggerFactory.getLogger((String)DatabaseInjector.class.getCanonicalName());

    @Override
    public void injectOnRequest(ServletConfig servletConfig, HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        this.injectDefaultDataSourceOnRequest(req);
        this.injectCustomDataSourcesOnRequest(servletConfig, req);
    }

    private void injectCustomDataSourcesOnRequest(ServletConfig servletConfig, HttpServletRequest req) {
        Enumeration parameterNames = servletConfig.getInitParameterNames();
        while (parameterNames.hasMoreElements()) {
            String parameterName = (String)parameterNames.nextElement();
            String parameterValue = servletConfig.getInitParameter(parameterName);
            if (!parameterName.startsWith(CUSTOM_DATASOURCE_PARAM_PREFIX)) continue;
            String customDataSourceName = parameterName.substring(CUSTOM_DATASOURCE_PARAM_PREFIX.length());
            try {
                DataSource dataSource = this.lookupDataSource(parameterValue);
                logger.error(String.valueOf(parameterValue) + " found and injected in the request");
                req.setAttribute(DATASOURCE_PREFIX + customDataSourceName, (Object)dataSource);
            }
            catch (NamingException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    @Override
    public void injectOnStart(ServletConfig servletConfig) throws ServletException, IOException {
        this.injectDefaultDataSourceOnStart();
    }

    private void injectDefaultDataSourceOnRequest(HttpServletRequest req) {
        block11: {
            DataSource dataSource = (DataSource)System.getProperties().get(DATASOURCE_DEFAULT);
            if (dataSource == null) {
                try {
                    String defaultDataSourceType = System.getProperty("defaultDataSourceType");
                    if (!"jndi".equals(defaultDataSourceType)) {
                        return;
                    }
                    String key = InitParametersInjector.get("jndiDefaultDataSource");
                    dataSource = this.lookupDataSource(key);
                    if (dataSource != null) {
                        req.setAttribute(DATASOURCE_DEFAULT, (Object)dataSource);
                        System.getProperties().put(DATASOURCE_DEFAULT, dataSource);
                        Connection connection = null;
                        try {
                            try {
                                connection = dataSource.getConnection();
                                DatabaseMetaData metaData = connection.getMetaData();
                                this.setMetaDataToSession(req, connection, metaData);
                                this.setMetaDataToEnv(connection);
                                break block11;
                            }
                            finally {
                                if (connection != null) {
                                    connection.close();
                                }
                            }
                        }
                        catch (SQLException e) {
                            logger.error(e.getMessage(), (Throwable)e);
                        }
                        break block11;
                    }
                    logger.warn("jndiDefaultDataSource not present");
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private void injectDefaultDataSourceOnStart() {
        block11: {
            DataSource dataSource = (DataSource)System.getProperties().get(DATASOURCE_DEFAULT);
            if (dataSource == null) {
                try {
                    String defaultDataSourceType = System.getProperty("defaultDataSourceType");
                    if (!"jndi".equals(defaultDataSourceType)) {
                        return;
                    }
                    String key = InitParametersInjector.get("jndiDefaultDataSource");
                    dataSource = this.lookupDataSource(key);
                    if (dataSource != null) {
                        System.getProperties().put(DATASOURCE_DEFAULT, dataSource);
                        Connection connection = null;
                        try {
                            try {
                                connection = dataSource.getConnection();
                                this.setMetaDataToEnv(connection);
                                break block11;
                            }
                            finally {
                                if (connection != null) {
                                    connection.close();
                                }
                            }
                        }
                        catch (SQLException e) {
                            logger.error(e.getMessage(), (Throwable)e);
                        }
                        break block11;
                    }
                    logger.warn("jndiDefaultDataSource not present");
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    private void setMetaDataToSession(HttpServletRequest req, Connection connection, DatabaseMetaData metaData) throws SQLException {
        req.setAttribute(DATABASE_PRODUCT_NAME, (Object)metaData.getDatabaseProductName());
        req.setAttribute(DATABASE_PRODUCT_VERSION, (Object)metaData.getDatabaseProductVersion());
        req.setAttribute(DATABASE_MINOR_VERSION, (Object)metaData.getDatabaseMinorVersion());
        req.setAttribute(DATABASE_MAJOR_VERSION, (Object)metaData.getDatabaseMajorVersion());
        req.setAttribute(DATABASE_DRIVER_NAME, (Object)metaData.getDriverName());
        req.setAttribute(DATABASE_DRIVER_MINOR_VERSION, (Object)metaData.getDriverMinorVersion());
        req.setAttribute(DATABASE_DRIVER_MAJOR_VERSION, (Object)metaData.getDriverMajorVersion());
        req.setAttribute(DATABASE_CONNECTION_CLASS_NAME, (Object)connection.getClass().getCanonicalName());
    }

    private void setMetaDataToEnv(Connection connection) throws SQLException {
        DatabaseMetaData metaData = connection.getMetaData();
        System.getProperties().put(DATABASE_PRODUCT_NAME, metaData.getDatabaseProductName());
        System.getProperties().put(DATABASE_PRODUCT_VERSION, metaData.getDatabaseProductVersion());
        System.getProperties().put(DATABASE_MINOR_VERSION, (Object)metaData.getDatabaseMinorVersion());
        System.getProperties().put(DATABASE_MAJOR_VERSION, (Object)metaData.getDatabaseMajorVersion());
        System.getProperties().put(DATABASE_DRIVER_NAME, metaData.getDriverName());
        System.getProperties().put(DATABASE_DRIVER_MINOR_VERSION, (Object)metaData.getDriverMinorVersion());
        System.getProperties().put(DATABASE_DRIVER_MAJOR_VERSION, (Object)metaData.getDriverMajorVersion());
        System.getProperties().put(DATABASE_CONNECTION_CLASS_NAME, connection.getClass().getCanonicalName());
    }

    private DataSource lookupDataSource(String key) throws NamingException {
        InitialContext ctx = new InitialContext();
        if (key != null) {
            return (DataSource)ctx.lookup(key);
        }
        return null;
    }
}

