/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.bridge;

import java.io.IOException;
import java.net.URI;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.websocket.ContainerProvider;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import javax.websocket.WebSocketContainer;
import javax.websocket.server.PathParam;
import javax.websocket.server.ServerEndpoint;
import org.eclipse.dirigible.ide.bridge.WebSocketTunnelClient;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ServerEndpoint(value="/tunnel/{protocol}/{host}/{port}/{path}")
public class WebSocketTunnel {
    private static final String PARAM_CLIENT = "client";
    private static final Logger logger = LoggerFactory.getLogger((String)WebSocketTunnel.class.getCanonicalName());
    static Map<String, Session> INBOUND_SESSIONS = Collections.synchronizedMap(new HashMap());

    @OnOpen
    public void onOpen(Session session, @PathParam(value="protocol") String protocol, @PathParam(value="host") String host, @PathParam(value="port") String port, @PathParam(value="path") String path) throws IOException {
        try {
            WebSocketContainer container = ContainerProvider.getWebSocketContainer();
            String uri = String.valueOf(protocol) + "://" + host + ":" + port + "/" + path.replace("~", "/");
            logger.debug("Connecting to " + uri);
            Session client = container.connectToServer(WebSocketTunnelClient.class, URI.create(uri));
            session.getUserProperties().put(PARAM_CLIENT, client);
            INBOUND_SESSIONS.put(client.getId(), session);
            logger.debug("Connected to " + uri);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            session.getBasicRemote().sendText(e.getMessage());
        }
    }

    @OnMessage
    public void onMessage(String message, Session session) {
        Session client = (Session)session.getUserProperties().get(PARAM_CLIENT);
        if (client != null) {
            try {
                client.getBasicRemote().sendText(message);
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    @OnError
    public void onError(Session session, Throwable t) {
        logger.error(t.getMessage(), t);
        Session client = (Session)session.getUserProperties().get(PARAM_CLIENT);
        if (client != null) {
            INBOUND_SESSIONS.remove(client.getId());
            try {
                client.close();
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    @OnClose
    public void onClose(Session session) {
        Session client = (Session)session.getUserProperties().get(PARAM_CLIENT);
        if (client != null) {
            INBOUND_SESSIONS.remove(client.getId());
            try {
                client.close();
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

