/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.db.viewer.views;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.dirigible.ide.common.CommonIDEParameters;
import org.eclipse.dirigible.ide.db.viewer.views.DatabaseViewer;
import org.eclipse.dirigible.ide.db.viewer.views.TableDefinition;
import org.eclipse.dirigible.ide.db.viewer.views.TreeObject;
import org.eclipse.dirigible.ide.db.viewer.views.TreeParent;
import org.eclipse.dirigible.repository.datasource.DataSources;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

public class DatabaseViewContentProvider
implements IStructuredContentProvider,
ITreeContentProvider {
    private static final Logger logger = Logger.getLogger(DatabaseViewContentProvider.class);
    private static final String DIRIGIBLE_SYSTEM_TALBES_PREFIX = "DGB_";
    private static final String EMPTY = "";
    private static final long serialVersionUID = 8868769345708033548L;
    private TreeParent invisibleRoot;
    public DatabaseViewer databaseViewer;

    public DatabaseViewContentProvider(DatabaseViewer databaseViewer) {
        this.databaseViewer = databaseViewer;
    }

    public void inputChanged(Viewer v, Object oldInput, Object newInput) {
    }

    public void dispose() {
    }

    public Object[] getElements(Object parent) {
        if (parent.equals(this.databaseViewer.getViewSite())) {
            if (this.invisibleRoot == null) {
                this.initialize();
            }
            return this.getChildren(this.invisibleRoot);
        }
        return this.getChildren(parent);
    }

    public Object getParent(Object child) {
        if (child instanceof TreeObject) {
            return ((TreeObject)child).getParent();
        }
        return null;
    }

    public Object[] getChildren(Object parent) {
        if (parent instanceof TreeParent) {
            return ((TreeParent)parent).getChildren();
        }
        return new Object[0];
    }

    public boolean hasChildren(Object parent) {
        if (parent instanceof TreeParent) {
            return ((TreeParent)parent).hasChildren();
        }
        return false;
    }

    private void initialize() {
        block19: {
            Connection connection = null;
            try {
                try {
                    connection = this.databaseViewer.getDatabaseConnection();
                    DatabaseViewer.getSelectedDatasourceName();
                    this.invisibleRoot = new TreeParent(EMPTY, this.databaseViewer);
                    ArrayList<TreeParent> schemesContainerNode = new ArrayList<TreeParent>();
                    String catalogName = null;
                    List schemeNames = DataSources.listSchemeNames((Connection)connection, (String)CommonIDEParameters.getSelectedDatasource(), catalogName, null);
                    for (String schemeName : schemeNames) {
                        TreeParent schemeContainerNode = new TreeParent(schemeName, this.databaseViewer);
                        List tableNames = DataSources.listTableNames((Connection)connection, (String)CommonIDEParameters.getSelectedDatasource(), catalogName, (String)schemeName, (DataSources.Filter)new DataSources.Filter<String>(){

                            public boolean accepts(String tableName) {
                                return !tableName.startsWith(DatabaseViewContentProvider.DIRIGIBLE_SYSTEM_TALBES_PREFIX) || CommonIDEParameters.isUserInRole((String)"Operator");
                            }
                        });
                        for (String tableName : tableNames) {
                            TableDefinition tableDef = new TableDefinition(catalogName, schemeName, tableName);
                            TreeObject tableNode = new TreeObject(tableName, tableDef);
                            List<Capability> capabilities = tableNode.getTableDefinition().getCapabilities();
                            if (!DataSources.getDialect((Connection)connection, (String)CommonIDEParameters.getSelectedDatasource()).isSchemaless()) {
                                capabilities.add(Capability.ShowTableDefinition);
                            }
                            capabilities.add(Capability.ViewTableContent);
                            tableDef.setContentScript(DataSources.getDialect((Connection)connection, (String)CommonIDEParameters.getSelectedDatasource()).getContentQueryScript(catalogName, schemeName, tableName));
                            capabilities.add(Capability.ExportData);
                            capabilities.add(Capability.Delete);
                            schemeContainerNode.addChild(tableNode);
                        }
                        schemesContainerNode.add(schemeContainerNode);
                    }
                    TreeParent dataSourceContainerNode = new TreeParent(DataSources.getDataSourceLabel((Connection)connection, (String)CommonIDEParameters.getSelectedDatasource()), this.databaseViewer);
                    if (schemesContainerNode.size() == 1) {
                        TreeObject[] tableNodes = ((TreeParent)schemesContainerNode.get(0)).getChildren();
                        TreeObject[] treeObjectArray = tableNodes;
                        int n = tableNodes.length;
                        int n2 = 0;
                        while (n2 < n) {
                            Object tableNode = treeObjectArray[n2];
                            dataSourceContainerNode.addChild((TreeObject)tableNode);
                            ++n2;
                        }
                    } else {
                        for (TreeParent schemeContainer : schemesContainerNode) {
                            dataSourceContainerNode.addChild(schemeContainer);
                        }
                    }
                    this.invisibleRoot.addChild(dataSourceContainerNode);
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                    TreeParent root = new TreeParent(e.getMessage(), this.databaseViewer);
                    this.invisibleRoot = new TreeParent(EMPTY, this.databaseViewer);
                    this.invisibleRoot.addChild(root);
                    if (connection == null) break block19;
                    try {
                        connection.close();
                    }
                    catch (SQLException e2) {
                        logger.warn(e2.getMessage(), (Throwable)e2);
                    }
                }
            }
            finally {
                if (connection != null) {
                    try {
                        connection.close();
                    }
                    catch (SQLException e) {
                        logger.warn(e.getMessage(), (Throwable)e);
                    }
                }
            }
        }
    }

    public void requestRefreshContent() {
        this.invisibleRoot = null;
    }

    public static enum Capability {
        ShowTableDefinition,
        ViewTableContent,
        ExportData,
        Delete;

    }
}

