/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.template.ui.common;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.dirigible.ide.common.status.LogProgressMonitor;
import org.eclipse.dirigible.ide.template.ui.common.GenerationModel;
import org.eclipse.dirigible.ide.template.ui.common.Messages;
import org.eclipse.dirigible.ide.template.ui.common.TemplateSourceMetadata;
import org.eclipse.dirigible.ide.workspace.dual.WorkspaceLocator;
import org.eclipse.dirigible.ide.workspace.ui.viewer.WorkspaceViewerUtils;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.dirigible.repository.velocity.VelocityGenerator;

public abstract class TemplateGenerator {
    private static final Logger logger = Logger.getLogger(TemplateGenerator.class);
    private static final String THE_FILE_ALREADY_EXISTS_SKIPPED_GENERATION_OF = Messages.TemplateGenerator_THE_FILE_ALREADY_EXISTS_SKIPPED_GENERATION_OF;
    private static final String PARAMETER_PROJECT_NAME = "projectName";
    private static final String PARAMETER_PACKAGE_NAME = "packageName";
    private static final String PARAMETER_FILE_NAME = "fileName";
    private static final String PARAMETER_FILE_NAME_NO_EXTENSION = "fileNameNoExtension";
    private VelocityGenerator velocityGenerator = new VelocityGenerator();
    private List<IFile> createdFiles = new ArrayList<IFile>();

    public void generate() throws Exception {
        this.generate(null);
    }

    public void generate(HttpServletRequest request) throws Exception {
        TemplateSourceMetadata[] sources;
        TemplateSourceMetadata[] templateSourceMetadataArray = sources = this.getModel().getTemplate().getTemplateMetadata().getSources();
        int n = sources.length;
        int n2 = 0;
        while (n2 < n) {
            TemplateSourceMetadata next = templateSourceMetadataArray[n2];
            String templateLocation = next.getLocation();
            String targetLocation = this.getTargetLocation(next);
            String fileName = this.getFileName(next);
            if (next.isGenerate()) {
                this.generateFile(templateLocation, targetLocation, fileName, request);
            } else {
                this.copyFile(templateLocation, targetLocation, fileName, request);
            }
            ++n2;
        }
    }

    private String getFileName(TemplateSourceMetadata source) {
        String fileName = FilenameUtils.getBaseName((String)source.getName());
        String extension = FilenameUtils.getExtension((String)source.getName());
        if (source.isRenaming()) {
            fileName = String.format(source.getRename(), FilenameUtils.getBaseName((String)this.getModel().getFileName()));
        }
        return String.valueOf(fileName) + '.' + extension;
    }

    private String getTargetLocation(TemplateSourceMetadata next) {
        StringBuilder targetLocation = new StringBuilder().append(this.getModel().getProjectName()).append("/").append(next.getRootFolder() == null ? this.getDefaultRootFolder() : next.getRootFolder()).append("/").append(this.getModel().getProjectPackageName());
        if (next.getPackagePath() != null) {
            targetLocation.append("/").append(next.getPackagePath());
        }
        return targetLocation.toString();
    }

    public List<IFile> getGeneratedFiles() {
        return this.createdFiles;
    }

    protected abstract GenerationModel getModel();

    protected abstract String getLogTag();

    protected Map<String, Object> prepareParameters() {
        GenerationModel model = this.getModel();
        HashMap<String, Object> parameters = new HashMap<String, Object>();
        parameters.put(PARAMETER_PROJECT_NAME, model.getProjectName());
        if (model.getPackageName() != null) {
            parameters.put(PARAMETER_PACKAGE_NAME, model.getPackageName());
        } else {
            parameters.put(PARAMETER_PACKAGE_NAME, this.constructPackageName());
        }
        parameters.put(PARAMETER_FILE_NAME, model.getFileName());
        parameters.put(PARAMETER_FILE_NAME_NO_EXTENSION, model.getFileNameNoExtension());
        return parameters;
    }

    protected byte[] afterGeneration(byte[] bytes) {
        return bytes;
    }

    private void generateFile(String templateLocation, String targetLocation, String fileName, HttpServletRequest request) throws Exception {
        Map<String, Object> parameters = this.prepareParameters();
        InputStream in = GenerationModel.getInputStreamByTemplateLocation(templateLocation, request);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.velocityGenerator.generate(in, (OutputStream)out, parameters, this.getLogTag());
        byte[] bytes = out.toByteArray();
        bytes = this.afterGeneration(bytes);
        IPath location = new Path(targetLocation).append(fileName);
        this.createFile(location, bytes, request);
    }

    private void createFile(IPath location, byte[] bytes, HttpServletRequest request) throws Exception {
        IWorkspace workspace = WorkspaceLocator.getWorkspace((HttpServletRequest)request);
        IWorkspaceRoot root = workspace.getRoot();
        IFile file = root.getFile(location);
        if (file.exists()) {
            logger.warn(String.format(THE_FILE_ALREADY_EXISTS_SKIPPED_GENERATION_OF, location));
        } else {
            LogProgressMonitor monitor = null;
            if (request != null) {
                monitor = new LogProgressMonitor();
            }
            this.createMissingParents(file, (IProgressMonitor)monitor);
            file.create((InputStream)new ByteArrayInputStream(bytes), false, (IProgressMonitor)monitor);
            this.createdFiles.add(file);
        }
        if (request == null) {
            IContainer parent = file.getParent();
            if (parent != null) {
                WorkspaceViewerUtils.expandElement((Object)parent);
            }
            WorkspaceViewerUtils.selectElement((Object)file);
        }
    }

    private void createMissingParents(IFile file, IProgressMonitor monitor) throws CoreException {
        Stack<IContainer> missingParents = new Stack<IContainer>();
        IContainer parent = file.getParent();
        while (!parent.exists()) {
            missingParents.push(parent);
            parent = parent.getParent();
        }
        while (!missingParents.isEmpty()) {
            IContainer next = (IContainer)missingParents.pop();
            if (!(next instanceof IFolder)) continue;
            ((IFolder)next).create(false, true, monitor);
        }
    }

    private void copyFile(String templateLocation, String targetLocation, String fileName, HttpServletRequest request) throws IOException, Exception {
        IPath location = new Path(targetLocation).append(fileName);
        InputStream in = GenerationModel.getInputStreamByTemplateLocation(templateLocation, request);
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        IOUtils.copy((InputStream)in, (OutputStream)out);
        this.createFile(location, out.toByteArray(), request);
    }

    private String constructPackageName() {
        return this.getModel().constructPackageName();
    }

    protected abstract String getDefaultRootFolder();
}

