/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.workspace.ui.commands;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.dirigible.ide.common.CommonIDEParameters;
import org.eclipse.dirigible.ide.workspace.ui.commands.Messages;
import org.eclipse.dirigible.ide.workspace.ui.commands.UploadDataWizard;
import org.eclipse.dirigible.repository.datasource.DataSourceFacade;
import org.eclipse.dirigible.repository.ext.db.transfer.DBTableImporter;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.ui.handlers.HandlerUtil;

public class UploadDataHandler
extends AbstractHandler {
    private static final String CANNOT_CLOSE_INPUT_STREAM_TO_AN_UPLOADED_FILE = Messages.UploadDataHandler_CANNOT_CLOSE_INPUT_STREAM_TO_AN_UPLOADED_FILE;
    private static final String UPLOADING = Messages.UploadDataHandler_UPLOADING;
    private static final String NO_FILES_SPECIFIED = Messages.UploadDataHandler_NO_FILES_SPECIFIED;
    private static final String PLUGIN_ID = "org.eclipse.dirigible.ide.workspace.ui";
    private static final String UPLOAD_DATA_RESULT = Messages.UploadDataHandler_UPLOAD_DATA_RESULT;
    private static final String CANNOT_STORE_DATA_FROM = Messages.UploadDataHandler_CANNOT_STORE_DATA_FROM;
    private static final String SUCCESSFULLY_IMPORTED_FILE = Messages.UploadDataHandler_SUCCESSFULLY_IMPORTED_FILE;
    private static final Logger logger = Logger.getLogger(UploadDataHandler.class);

    public Object execute(ExecutionEvent event) throws ExecutionException {
        UploadDataWizard wizard = new UploadDataWizard(this);
        WizardDialog dialog = new WizardDialog(HandlerUtil.getActiveShell((ExecutionEvent)event), (IWizard)wizard);
        dialog.open();
        return null;
    }

    public void insertIntoDbAsync(final Collection<String> fileNames) {
        Job job = new Job(UPLOADING){

            protected IStatus run(IProgressMonitor monitor) {
                return UploadDataHandler.this.insertIntoDb(fileNames);
            }
        };
        job.setUser(true);
        job.schedule();
    }

    private IStatus insertIntoDb(Collection<String> fileNames) {
        if (fileNames == null || fileNames.isEmpty()) {
            return new Status(4, PLUGIN_ID, NO_FILES_SPECIFIED);
        }
        String fileName = null;
        MultiStatus multiStatus = new MultiStatus(PLUGIN_ID, 0, UPLOAD_DATA_RESULT, null);
        for (String fullFileName : fileNames) {
            fileName = fullFileName.substring(fullFileName.lastIndexOf(File.separatorChar) + 1);
            FileInputStream in = null;
            try {
                try {
                    in = new FileInputStream(fullFileName);
                    byte[] data = IOUtils.toByteArray((InputStream)in);
                    HttpServletRequest request = null;
                    try {
                        request = CommonIDEParameters.getRequest();
                    }
                    catch (IllegalStateException illegalStateException) {}
                    DBTableImporter dataInserter = new DBTableImporter(DataSourceFacade.getInstance().getDataSource(request), data, fileName);
                    dataInserter.insert();
                    multiStatus.add((IStatus)new Status(0, PLUGIN_ID, String.valueOf(SUCCESSFULLY_IMPORTED_FILE) + fileName));
                }
                catch (Exception e) {
                    logger.error(String.valueOf(CANNOT_STORE_DATA_FROM) + fileName, (Throwable)e);
                    String errMessage = String.valueOf(CANNOT_STORE_DATA_FROM) + fileName;
                    multiStatus.add((IStatus)new Status(4, PLUGIN_ID, errMessage, (Throwable)e));
                    if (in == null) continue;
                    try {
                        ((InputStream)in).close();
                    }
                    catch (IOException e2) {
                        logger.warn(CANNOT_CLOSE_INPUT_STREAM_TO_AN_UPLOADED_FILE, (Throwable)e2);
                    }
                    continue;
                }
            }
            catch (Throwable throwable) {
                if (in != null) {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (IOException e) {
                        logger.warn(CANNOT_CLOSE_INPUT_STREAM_TO_AN_UPLOADED_FILE, (Throwable)e);
                    }
                }
                throw throwable;
            }
            if (in == null) continue;
            try {
                ((InputStream)in).close();
            }
            catch (IOException e) {
                logger.warn(CANNOT_CLOSE_INPUT_STREAM_TO_AN_UPLOADED_FILE, (Throwable)e);
            }
        }
        if (multiStatus.getChildren().length == 1) {
            return multiStatus.getChildren()[0];
        }
        return multiStatus;
    }
}

