/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;

public class StatusUtil {
    protected static List<IStatus> flatten(IStatus aStatus) {
        ArrayList<IStatus> result = new ArrayList<IStatus>();
        if (aStatus.isMultiStatus()) {
            IStatus[] children;
            IStatus[] iStatusArray = children = aStatus.getChildren();
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IStatus currentChild = iStatusArray[n2];
                if (currentChild.isMultiStatus()) {
                    Iterator<IStatus> childStatiiEnum = StatusUtil.flatten(currentChild).iterator();
                    while (childStatiiEnum.hasNext()) {
                        result.add(childStatiiEnum.next());
                    }
                } else {
                    result.add(currentChild);
                }
                ++n2;
            }
        } else {
            result.add(aStatus);
        }
        return result;
    }

    protected static IStatus newStatus(IStatus[] stati, String message, Throwable exception) {
        if (message == null || message.trim().length() == 0) {
            throw new IllegalArgumentException();
        }
        return new MultiStatus("org.eclipse.ui.ide", 4, stati, message, exception);
    }

    public static IStatus newStatus(int severity, String message, Throwable exception) {
        String statusMessage = message;
        if (message == null || message.trim().length() == 0) {
            if (exception == null) {
                throw new IllegalArgumentException();
            }
            statusMessage = exception.getMessage() == null ? exception.toString() : exception.getMessage();
        }
        return new Status(severity, "org.eclipse.ui.ide", severity, statusMessage, exception);
    }

    public static IStatus newStatus(List<?> children, String message, Throwable exception) {
        ArrayList<IStatus> flatStatusCollection = new ArrayList<IStatus>();
        for (IStatus currentStatus : children) {
            Iterator<IStatus> childrenIter = StatusUtil.flatten(currentStatus).iterator();
            while (childrenIter.hasNext()) {
                flatStatusCollection.add(childrenIter.next());
            }
        }
        IStatus[] stati = new IStatus[flatStatusCollection.size()];
        flatStatusCollection.toArray(stati);
        return StatusUtil.newStatus(stati, message, exception);
    }
}

