/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.repository.datasource;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.NavigableMap;
import java.util.Properties;
import java.util.TreeMap;
import org.eclipse.dirigible.repository.datasource.DataSourceFacade;
import org.eclipse.dirigible.repository.datasource.db.dialect.DialectFactory;
import org.eclipse.dirigible.repository.datasource.db.dialect.IDialectSpecifier;
import org.eclipse.dirigible.repository.logging.Logger;

public class DataSources {
    private static final Logger logger = Logger.getLogger(DataSources.class);
    public static final String SYSTEM_TABLE = "SYSTEM TABLE";
    public static final String LOCAL_TEMPORARY = "LOCAL TEMPORARY";
    public static final String GLOBAL_TEMPORARY = "GLOBAL TEMPORARY";
    public static final String SYNONYM = "SYNONYM";
    public static final String ALIAS = "ALIAS";
    public static final String VIEW = "VIEW";
    public static final String TABLE = "TABLE";
    public static final String[] TABLE_TYPES = new String[]{"TABLE", "VIEW", "ALIAS", "SYNONYM", "GLOBAL TEMPORARY", "LOCAL TEMPORARY", "SYSTEM TABLE"};
    private static final String PRCNT = "%";
    private static final String CBC = "] ";
    private static final String CBO = " [";
    private static final String COLUMN_NAME = "COLUMN_NAME";
    private static final String TYPE_NAME = "TYPE_NAME";
    private static final String COLUMN_SIZE = "COLUMN_SIZE";
    private static final String EMPTY = "";
    private static final String PK = "PK";
    private static final String IS_NULLABLE = "IS_NULLABLE";
    private static final String INDEX_NAME = "INDEX_NAME";
    private static final String TYPE_INDEX = "TYPE";
    private static final String NON_UNIQUE = "NON_UNIQUE";
    private static final String INDEX_QUALIFIER = "INDEX_QUALIFIER";
    private static final String ORDINAL_POSITION = "ORDINAL_POSITION";
    private static final String ASC_OR_DESC = "ASC_OR_DESC";
    private static final String CARDINALITY = "CARDINALITY";
    private static final String PAGES_INDEX = "PAGES";
    private static final String FILTER_CONDITION = "FILTER_CONDITION";
    static final String DEFAULT_DATASOURCE_NAME = "Default";

    private DataSources() {
    }

    public static IDialectSpecifier getDialect(Connection conn, String dsName) throws SQLException {
        DatabaseMetaData dmd = conn.getMetaData();
        String productName = dmd.getDatabaseProductName();
        IDialectSpecifier dialectSpecifier = DialectFactory.getInstance(productName);
        if (dialectSpecifier == null) {
            dialectSpecifier = DialectFactory.getInstance(dsName);
        }
        return dialectSpecifier;
    }

    public static String getDataSourceLabel(Connection conn, String dsName) throws SQLException {
        DatabaseMetaData dmd = conn.getMetaData();
        Properties dsConfig = DataSourceFacade.getInstance().getNamedDataSourceConfig(dsName);
        String productName = dmd.getDatabaseProductName() != null ? dmd.getDatabaseProductName() : dsConfig.getProperty("ds.id");
        String productVersion = dmd.getDatabaseProductVersion() != null ? CBO + dmd.getDatabaseProductVersion() + CBC : EMPTY;
        String driverName = dmd.getDriverName() != null ? dmd.getDriverName() : EMPTY;
        return String.valueOf(productName) + productVersion + driverName;
    }

    public static List<String> listTableNames(Connection conn, String dsName, String catalogName, String schemeName, Filter<String> tableNameFilter) throws SQLException {
        DatabaseMetaData dmd = conn.getMetaData();
        IDialectSpecifier dialectSpecifier = DataSources.getDialect(conn, dsName);
        ArrayList<String> listOfTables = new ArrayList<String>();
        ResultSet rs = null;
        rs = dialectSpecifier.isCatalogForSchema() ? dmd.getTables(schemeName, null, PRCNT, TABLE_TYPES) : dmd.getTables(catalogName, schemeName, PRCNT, TABLE_TYPES);
        try {
            while (rs.next()) {
                String tableName = rs.getString(3);
                if (tableNameFilter != null && !tableNameFilter.accepts(tableName)) continue;
                listOfTables.add(tableName);
            }
        }
        finally {
            rs.close();
        }
        return listOfTables;
    }

    public static List<String> listSchemeNames(Connection conn, String dsName, String catalogName, Filter<String> schemaNameFilter) throws SQLException {
        DatabaseMetaData dmd = conn.getMetaData();
        ArrayList<String> listOfSchemes = new ArrayList<String>();
        ResultSet rs = null;
        IDialectSpecifier dialectSpecifier = DataSources.getDialect(conn, dsName);
        try {
            block16: {
                if (dialectSpecifier.isSchemaFilterSupported()) {
                    try {
                        try {
                            rs = conn.createStatement().executeQuery(dialectSpecifier.getSchemaFilterScript());
                        }
                        catch (Exception exception) {
                            rs = dmd.getSchemas(catalogName, null);
                            if (rs != null) {
                                rs.close();
                            }
                            break block16;
                        }
                    }
                    catch (Throwable throwable) {
                        if (rs != null) {
                            rs.close();
                        }
                        throw throwable;
                    }
                    if (rs != null) {
                        rs.close();
                    }
                } else {
                    rs = dialectSpecifier.isCatalogForSchema() ? dmd.getCatalogs() : dmd.getSchemas(catalogName, null);
                }
            }
            if (rs != null) {
                while (rs.next()) {
                    String schemeName = rs.getString(1);
                    if (schemaNameFilter != null && !schemaNameFilter.accepts(schemeName)) continue;
                    listOfSchemes.add(schemeName);
                }
            }
        }
        finally {
            if (rs != null) {
                rs.close();
            }
        }
        return listOfSchemes;
    }

    public static void iterateTableDefinition(Connection conn, String tableName, String catalogName, String schemaName, ColumnsIteratorCallback columnsIteratorCallback, IndicesIteratorCallback indicesIteratorCallback) throws SQLException {
        DatabaseMetaData dmd = conn.getMetaData();
        ResultSet columns = dmd.getColumns(catalogName, schemaName, tableName, null);
        if (columns == null) {
            throw new SQLException("DatabaseMetaData.getColumns returns null");
        }
        ResultSet pks = dmd.getPrimaryKeys(catalogName, schemaName, tableName);
        if (pks == null) {
            throw new SQLException("DatabaseMetaData.getPrimaryKeys returns null");
        }
        ResultSet indexes = dmd.getIndexInfo(catalogName, schemaName, tableName, false, false);
        if (indexes == null) {
            throw new SQLException("DatabaseMetaData.getIndexInfo returns null");
        }
        try {
            ArrayList<String> pkList = new ArrayList<String>();
            while (pks.next()) {
                String pkName = pks.getString(COLUMN_NAME);
                pkList.add(pkName);
            }
            while (columns.next()) {
                if (columnsIteratorCallback == null) continue;
                String cname = columns.getString(COLUMN_NAME);
                columnsIteratorCallback.onColumn(cname, columns.getString(TYPE_NAME), String.valueOf(columns.getInt(COLUMN_SIZE)), columns.getString(IS_NULLABLE), pkList.contains(cname) ? PK : EMPTY);
            }
            while (indexes.next()) {
                if (indicesIteratorCallback == null) continue;
                indicesIteratorCallback.onIndex(indexes.getString(INDEX_NAME), indexes.getString(TYPE_INDEX), indexes.getString(COLUMN_NAME), indexes.getString(NON_UNIQUE), indexes.getString(INDEX_QUALIFIER), String.valueOf(indexes.getShort(ORDINAL_POSITION)), indexes.getString(ASC_OR_DESC), String.valueOf(indexes.getInt(CARDINALITY)), String.valueOf(indexes.getInt(PAGES_INDEX)), indexes.getString(FILTER_CONDITION));
            }
        }
        finally {
            columns.close();
            indexes.close();
            pks.close();
        }
    }

    public static void executeSingleStatement(Connection connection, String sql, boolean isQuery, RequestExecutionCallback callback) {
        block14: {
            ResultSet resultSet = null;
            PreparedStatement preparedStatement = null;
            try {
                try {
                    preparedStatement = connection.prepareStatement(sql);
                    if (isQuery) {
                        resultSet = preparedStatement.executeQuery();
                        callback.queryDone(resultSet);
                        break block14;
                    }
                    preparedStatement.executeUpdate();
                    callback.updateDone(preparedStatement.getUpdateCount());
                }
                catch (Exception e) {
                    callback.error(e);
                    try {
                        if (resultSet != null) {
                            resultSet.close();
                        }
                    }
                    catch (SQLException e2) {
                        logger.warn(e2.getMessage(), (Throwable)e2);
                    }
                }
            }
            finally {
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (SQLException e) {
                    logger.warn(e.getMessage(), (Throwable)e);
                }
            }
        }
    }

    public static void executeQueryStatement(Connection connection, String sql, ResultSetIteratorCallback callback) {
        ResultSet resultSet = null;
        PreparedStatement preparedStatement = null;
        try {
            try {
                preparedStatement = connection.prepareStatement(sql);
                resultSet = preparedStatement.executeQuery();
                int columnsCount = resultSet.getMetaData().getColumnCount();
                ArrayList<NavigableMap<String, Object>> table = new ArrayList<NavigableMap<String, Object>>();
                TreeMap<String, Object> row = new TreeMap<String, Object>();
                int i = 1;
                while (i <= columnsCount) {
                    row.put(resultSet.getMetaData().getColumnName(i), resultSet.getObject(i));
                    callback.onRowConstruction(connection, row);
                    table.add(row);
                    ++i;
                }
                callback.onQueryDone(connection, table);
            }
            catch (Exception e) {
                callback.onError(connection, e);
                try {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
                catch (SQLException e2) {
                    logger.warn(e2.getMessage(), (Throwable)e2);
                }
            }
        }
        finally {
            try {
                if (resultSet != null) {
                    resultSet.close();
                }
            }
            catch (SQLException e) {
                logger.warn(e.getMessage(), (Throwable)e);
            }
        }
    }

    public static interface ColumnsIteratorCallback {
        public void onColumn(String var1, String var2, String var3, String var4, String var5);
    }

    public static enum Config {
        ShowTableContentScript,
        SchemaFilterScript;

    }

    public static interface Filter<T> {
        public boolean accepts(T var1);
    }

    public static interface IndicesIteratorCallback {
        public void onIndex(String var1, String var2, String var3, String var4, String var5, String var6, String var7, String var8, String var9, String var10);
    }

    public static interface RequestExecutionCallback {
        public void updateDone(int var1);

        public void queryDone(ResultSet var1);

        public void error(Throwable var1);
    }

    public static interface ResultSetIteratorCallback {
        public void onQueryDone(Connection var1, List<NavigableMap<String, Object>> var2);

        public void onRowConstruction(Connection var1, NavigableMap<String, Object> var2);

        public void onError(Connection var1, Throwable var2);
    }
}

