/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.repository.zip;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.eclipse.dirigible.repository.api.ICollection;
import org.eclipse.dirigible.repository.api.IEntity;
import org.eclipse.dirigible.repository.api.IRepository;
import org.eclipse.dirigible.repository.api.IResource;
import org.eclipse.dirigible.repository.zip.Messages;

public class ZipExporter {
    private static final String RELATIVE_ROOT_S_DOESN_T_EXIST = Messages.getString("ZipExporter.RELATIVE_ROOT_S_DOESN_T_EXIST");

    public static byte[] exportZip(IRepository repository, List<String> relativeRoots) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        ZipOutputStream zipOutputStream = null;
        try {
            zipOutputStream = new ZipOutputStream(baos);
            for (String relativeRoot : relativeRoots) {
                ICollection collection = repository.getCollection(relativeRoot);
                if (collection.exists()) {
                    ZipExporter.traverseCollection(zipOutputStream, collection, relativeRoot.length() - collection.getName().length());
                    continue;
                }
                IResource iResource = repository.getResource(relativeRoot);
                if (iResource.exists()) {
                    ZipEntry zipEntry = new ZipEntry(iResource.getPath().substring(relativeRoot.length() - iResource.getName().length()));
                    zipOutputStream.putNextEntry(zipEntry);
                    zipOutputStream.write(iResource.getContent() == null ? new byte[]{} : iResource.getContent());
                    zipOutputStream.closeEntry();
                    continue;
                }
                throw new IOException(String.format(RELATIVE_ROOT_S_DOESN_T_EXIST, relativeRoot));
            }
        }
        finally {
            if (zipOutputStream != null) {
                zipOutputStream.finish();
                zipOutputStream.flush();
                zipOutputStream.close();
            }
        }
        byte[] result = baos.toByteArray();
        return result;
    }

    public static byte[] exportZip(IRepository repository, String relativeRoot, boolean inclusive) throws IOException {
        ArrayList<String> relativeRoots = new ArrayList<String>();
        ICollection collection = repository.getCollection(relativeRoot);
        if (collection.exists()) {
            if (inclusive) {
                relativeRoots.add(relativeRoot);
            } else {
                List entities = collection.getChildren();
                for (IEntity iEntity : entities) {
                    relativeRoots.add(iEntity.getPath());
                }
            }
            return ZipExporter.exportZip(repository, relativeRoots);
        }
        IResource resource = repository.getResource(relativeRoot);
        if (resource.exists()) {
            relativeRoots.add(resource.getPath());
            return ZipExporter.exportZip(repository, relativeRoots);
        }
        throw new IOException(String.format(RELATIVE_ROOT_S_DOESN_T_EXIST, relativeRoot));
    }

    private static void traverseCollection(ZipOutputStream zipOutputStream, ICollection collection, int substring) throws IOException {
        ZipEntry zipEntry = null;
        if (collection.getPath().length() >= substring) {
            zipEntry = new ZipEntry(String.valueOf(collection.getPath().substring(substring)) + "/");
            zipOutputStream.putNextEntry(zipEntry);
            zipOutputStream.closeEntry();
        }
        List collections = collection.getCollections();
        for (ICollection iCollection : collections) {
            ZipExporter.traverseCollection(zipOutputStream, iCollection, substring);
        }
        List resources = collection.getResources();
        for (IResource iResource : resources) {
            zipEntry = new ZipEntry(iResource.getPath().substring(substring));
            zipOutputStream.putNextEntry(zipEntry);
            zipOutputStream.write(iResource.getContent() == null ? new byte[]{} : iResource.getContent());
            zipOutputStream.closeEntry();
        }
    }
}

