/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.command;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.util.Iterator;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.websocket.OnClose;
import javax.websocket.OnError;
import javax.websocket.OnMessage;
import javax.websocket.OnOpen;
import javax.websocket.Session;
import org.eclipse.dirigible.repository.ext.command.Piper;
import org.eclipse.dirigible.repository.ext.command.ProcessUtils;
import org.eclipse.dirigible.repository.logging.Logger;

public class WebSocketTerminalBridgeServletInternal {
    private static final String Ctrl_C = "^C";
    private static final Logger logger = Logger.getLogger(WebSocketTerminalBridgeServletInternal.class);
    private static Map<String, Session> openSessions = new ConcurrentHashMap<String, Session>();
    private static Map<String, ProcessRunnable> session2process = new ConcurrentHashMap<String, ProcessRunnable>();

    @OnOpen
    public void onOpen(Session session) throws IOException {
        openSessions.put(session.getId(), session);
        logger.debug("[ws:terminal] onOpen: " + session.getId());
        this.startProcessRunnable(session);
    }

    protected void startProcessRunnable(Session session) {
        try {
            ProcessRunnable processRunnable = new ProcessRunnable(session);
            new Thread(processRunnable).start();
            logger.debug("process started");
            session2process.put(session.getId(), processRunnable);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    @OnMessage
    public void onMessage(String message, Session session) {
        logger.debug("[ws:terminal] onMessage: " + message);
        ProcessRunnable processRunnable = session2process.get(session.getId());
        Process process = processRunnable.getProcess();
        if (process != null) {
            try {
                if (Ctrl_C.equalsIgnoreCase(message.trim())) {
                    logger.debug("onMessage: exit command received");
                    process.destroy();
                    session2process.remove(session.getId());
                    session.close();
                } else {
                    byte[] data = message.getBytes(StandardCharsets.UTF_8);
                    process.getOutputStream().write(data);
                    process.getOutputStream().flush();
                }
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }

    private Process startProcess(String message, Session session) throws IOException {
        logger.debug("entering startProcess: " + message + " | " + session.getId());
        String[] args = ProcessUtils.translateCommandline((String)message);
        ProcessBuilder processBuilder = ProcessUtils.createProcess((String[])args);
        ProcessUtils.addEnvironmentVariables((ProcessBuilder)processBuilder, null);
        ProcessUtils.removeEnvironmentVariables((ProcessBuilder)processBuilder, null);
        processBuilder.redirectErrorStream(true);
        Process process = ProcessUtils.startProcess((String[])args, (ProcessBuilder)processBuilder);
        logger.debug("exiting startProcess: " + message + " | " + session.getId());
        return process;
    }

    protected void removeProcess(Process process) {
        Iterator<Map.Entry<String, ProcessRunnable>> iter = session2process.entrySet().iterator();
        while (iter.hasNext()) {
            Map.Entry<String, ProcessRunnable> entry = iter.next();
            if (!entry.getValue().getProcess().equals(process)) continue;
            iter.remove();
            break;
        }
    }

    @OnError
    public void onError(Session session, String error) {
        logger.debug("[ws:terminal] onError: " + error);
    }

    @OnClose
    public void onClose(Session session) {
        ProcessRunnable processRunnable = session2process.get(session.getId());
        processRunnable.getProcess().destroy();
        openSessions.remove(session.getId());
        logger.debug("[ws:terminal] onClose: Session " + session.getId() + " has ended");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void closeAll() {
        for (Session session : openSessions.values()) {
            try {
                Session session2 = session;
                synchronized (session2) {
                    ProcessRunnable processRunnable = session2process.get(session.getId());
                    processRunnable.getProcess().destroy();
                    session.close();
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    class ProcessRunnable
    implements Runnable {
        private static final String BASH_COMMAND = "bash";
        private static final String CMD_COMMAND = "cmd";
        private Session session;
        private Process process;

        public Process getProcess() {
            return this.process;
        }

        public ProcessRunnable(Session session) {
            this.session = session;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void run() {
            try {
                String os = System.getProperty("os.name").toLowerCase();
                String command = BASH_COMMAND;
                if (os.indexOf("windows") >= 0) {
                    command = CMD_COMMAND;
                }
                this.process = WebSocketTerminalBridgeServletInternal.this.startProcess(command, this.session);
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                Piper pipe = new Piper(this.process.getInputStream(), (OutputStream)out);
                new Thread((Runnable)pipe).start();
                try {
                    int i = 0;
                    boolean deadYet = false;
                    do {
                        Thread.sleep(ProcessUtils.DEFAULT_WAIT_TIME);
                        try {
                            Session session = this.session;
                            synchronized (session) {
                                BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(out.toByteArray()), StandardCharsets.UTF_8));
                                String line = null;
                                while ((line = reader.readLine()) != null) {
                                    logger.debug("sending process data: " + line);
                                    if (!this.session.isOpen()) continue;
                                    this.session.getBasicRemote().sendText(line);
                                }
                                out.reset();
                            }
                            this.process.exitValue();
                            deadYet = true;
                            WebSocketTerminalBridgeServletInternal.this.removeProcess(this.process);
                        }
                        catch (IllegalThreadStateException illegalThreadStateException) {
                            if (++i < 600) continue;
                            this.process.destroy();
                            throw new RuntimeException("Exeeds timeout: " + ProcessUtils.DEFAULT_WAIT_TIME / 1000 * 600);
                        }
                    } while (!deadYet);
                    this.session.close();
                }
                catch (Exception e) {
                    logger.error(e.getMessage(), (Throwable)e);
                }
                Session session = this.session;
                synchronized (session) {
                    if (this.session.isOpen()) {
                        this.session.getBasicRemote().sendText(new String(out.toByteArray(), StandardCharsets.UTF_8));
                    }
                }
            }
            catch (IOException e) {
                logger.error(e.getMessage(), (Throwable)e);
            }
        }
    }
}

