/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.filter;

import java.io.IOException;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.dirigible.runtime.filter.Messages;
import org.eclipse.dirigible.runtime.filter.SecuredLocationVerifier;
import org.eclipse.dirigible.runtime.registry.PathUtils;

public abstract class AbstractRegistrySecureFilter
implements Filter {
    private static final String EMPTY = "";
    private static final String Q = "?";
    private static final String ACCEPT = "Accept";
    private static final String GET_METHOD = "GET";
    private static final String HTTP_METHOD_CANNOT_BE_REDIRECTED_AUTOMATICALLY = "AbstractRegistrySecureFilter.2";
    private static final String JSON = "json";

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest request = (HttpServletRequest)req;
        String location = PathUtils.extractPath((HttpServletRequest)request);
        String queryString = request.getQueryString();
        if (this.isLocationSecured(location) != null) {
            String acceptHeader = request.getHeader(ACCEPT);
            if (acceptHeader != null && acceptHeader.contains(JSON) && request.getUserPrincipal() == null) {
                ((HttpServletResponse)res).sendError(403, String.format(Messages.getString(HTTP_METHOD_CANNOT_BE_REDIRECTED_AUTOMATICALLY), request.getMethod(), String.valueOf(req.getServletContext().getContextPath()) + this.getSecuredMapping()));
                return;
            }
            if (GET_METHOD.equalsIgnoreCase(request.getMethod())) {
                ((HttpServletResponse)res).sendRedirect(String.valueOf(req.getServletContext().getContextPath()) + this.getSecuredMapping() + location + (queryString != null ? Q + queryString : EMPTY));
            } else {
                ((HttpServletResponse)res).sendError(403, String.format(Messages.getString(HTTP_METHOD_CANNOT_BE_REDIRECTED_AUTOMATICALLY), request.getMethod(), String.valueOf(req.getServletContext().getContextPath()) + this.getSecuredMapping()));
            }
            return;
        }
        chain.doFilter(req, res);
    }

    protected abstract String getSecuredMapping();

    protected String isLocationSecured(String location) throws ServletException {
        return SecuredLocationVerifier.isLocationSecured(location);
    }

    public void init(FilterConfig config) throws ServletException {
    }

    public void destroy() {
    }
}

