/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.web;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.dirigible.repository.api.IEntity;
import org.eclipse.dirigible.repository.api.IResource;
import org.eclipse.dirigible.runtime.registry.PathUtils;
import org.eclipse.dirigible.runtime.registry.RegistryServlet;
import org.eclipse.dirigible.runtime.repository.RepositoryFacade;
import org.eclipse.dirigible.runtime.scripting.IScriptExecutor;
import org.eclipse.dirigible.runtime.web.WebExecutor;

public class WebRegistryServlet
extends RegistryServlet {
    private static final String WEB_CONTENT = "/WebContent";
    protected static final String PARAMETER_LIST = "list";
    private static final long serialVersionUID = -1484072696377972535L;

    protected String extractRepositoryPath(HttpServletRequest request) throws IllegalArgumentException {
        String requestPath = PathUtils.extractPath((HttpServletRequest)request);
        if (request.getAttribute("sandbox") != null && ((Boolean)request.getAttribute("sandbox")).booleanValue()) {
            return "/db/dirigible/sandbox/" + RepositoryFacade.getUser((HttpServletRequest)request) + this.getContentFolder() + requestPath;
        }
        return "/db/dirigible/registry/public" + this.getContentFolder() + requestPath;
    }

    protected String getWebRegistryPath(HttpServletRequest request) throws IllegalArgumentException {
        if (request.getAttribute("sandbox") != null && ((Boolean)request.getAttribute("sandbox")).booleanValue()) {
            return "/db/dirigible/sandbox/" + RepositoryFacade.getUser((HttpServletRequest)request) + this.getContentFolder();
        }
        return "/db/dirigible/registry/public" + this.getContentFolder();
    }

    protected String getContentFolder() {
        return WEB_CONTENT;
    }

    protected byte[] buildResourceData(IEntity entity, HttpServletRequest request, HttpServletResponse response) throws IOException {
        boolean list;
        byte[] rawContent = this.retrieveResourceData(entity, request, response);
        boolean bl = list = request.getParameter(PARAMETER_LIST) != null;
        if (list) {
            return super.buildResourceData(entity, request, response);
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        outputStream.write(this.preprocessContent(rawContent, entity));
        outputStream.flush();
        return outputStream.toByteArray();
    }

    protected byte[] preprocessContent(byte[] rawContent, IEntity entity) throws IOException {
        return rawContent;
    }

    protected byte[] buildCollectionData(boolean deep, IEntity entity, String collectionPath) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintWriter writer = new PrintWriter(baos);
        IResource index = entity.getParent().getResource("index.html");
        if (!index.exists()) {
            return super.buildCollectionData(deep, entity, collectionPath);
        }
        writer.print(new String(index.getContent()));
        writer.flush();
        byte[] data = baos.toByteArray();
        return this.preprocessContent(data, entity);
    }

    public IScriptExecutor createExecutor(HttpServletRequest request) throws IOException {
        WebExecutor executor = new WebExecutor(this.getRepository(request), this.getWebRegistryPath(request), "/db/dirigible/registry/public" + this.getContentFolder());
        return executor;
    }
}

