/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.workspace.dual;

import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang.StringEscapeUtils;
import org.eclipse.dirigible.ide.workspace.dual.Messages;
import org.eclipse.dirigible.ide.workspace.dual.RepositoryDataStore;
import org.eclipse.dirigible.repository.api.ICommonConstants;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.rap.rwt.RWT;
import org.eclipse.rap.rwt.service.ServiceHandler;
import org.eclipse.rap.rwt.service.ServiceManager;

public class DownloadProjectServiceHandler
implements ServiceHandler {
    private static final String SLASH = "/";
    private static final String ZIP = ".zip";
    private static final String EQ = "=";
    private static final String AMP = "&";
    private static final String CONTENT_DISPOSITION_KEY = "Content-Disposition";
    private static final String CONTENT_DISPOSITION_PARAM = "attachment; filename=\"%s\"";
    private static final String ERROR_TXT = "error.txt";
    private static final String TEXT_PLAIN = "text/plain";
    private static final String APPLICATION_ZIP = "application/zip";
    private static final String FILENAME_PARAM = "filename";
    private static final String ERROR_WHILE_GETTING_CONTENT_FROM_LOCATION = Messages.DownloadProjectServiceHandler_ERROR_WHILE_GETTING_CONTENT_FROM_LOCATION;
    static final String SERVICE_HANDLER_ID = "org.eclipse.dirigible.ide.workspace.wizard.project.export.DownloadProjectServiceHandler";
    private static final Logger logger = Logger.getLogger(DownloadProjectServiceHandler.class);

    public void service(HttpServletRequest request, HttpServletResponse response) throws IOException, ServletException {
        byte[] download;
        String fileName = request.getParameter(FILENAME_PARAM);
        fileName = StringEscapeUtils.escapeHtml((String)fileName);
        fileName = StringEscapeUtils.escapeJavaScript((String)fileName);
        try {
            download = RepositoryDataStore.getByteArrayData(fileName);
            response.setContentType(APPLICATION_ZIP);
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            download = (String.valueOf(ERROR_WHILE_GETTING_CONTENT_FROM_LOCATION) + fileName).getBytes(ICommonConstants.UTF8);
            response.setContentType(TEXT_PLAIN);
            fileName = ERROR_TXT;
        }
        response.setContentLength(download.length);
        String contentDisposition = String.format(CONTENT_DISPOSITION_PARAM, fileName);
        response.setHeader(CONTENT_DISPOSITION_KEY, contentDisposition);
        response.getOutputStream().write(download);
    }

    public static String getUrl(String token) {
        ServiceManager manager = RWT.getServiceManager();
        String rootURL = manager.getServiceHandlerUrl(SERVICE_HANDLER_ID);
        StringBuffer url = new StringBuffer();
        url.append(rootURL);
        url.append(AMP);
        url.append(FILENAME_PARAM).append(EQ).append(token).append(ZIP);
        int relativeIndex = url.lastIndexOf(SLASH);
        if (relativeIndex > -1) {
            url.delete(0, relativeIndex + 1);
        }
        return RWT.getResponse().encodeURL(url.toString());
    }
}

