/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.ide;

import com.ibm.icu.text.MessageFormat;
import java.util.ArrayList;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IBundleGroup;
import org.eclipse.core.runtime.IBundleGroupProvider;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProduct;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.dirigible.ide.workspace.RemoteResourcesPlugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.jface.resource.LocalResourceManager;
import org.eclipse.jface.resource.ResourceManager;
import org.eclipse.swt.custom.BusyIndicator;
import org.eclipse.ui.internal.ide.AboutInfo;
import org.eclipse.ui.internal.ide.StatusUtil;
import org.eclipse.ui.internal.ide.registry.MarkerImageProviderRegistry;
import org.eclipse.ui.internal.ide.registry.ProjectImageRegistry;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;
import org.osgi.framework.BundleException;

public class IDEWorkbenchPlugin
extends AbstractUIPlugin {
    private static final String EXCEPTION_IN_0_1_2 = "Exception in {0}.{1}: {2}";
    private static IDEWorkbenchPlugin inst;
    public static boolean DEBUG;
    public static final String IDE_WORKBENCH = "org.eclipse.ui.ide";
    public static final String DEFAULT_TEXT_EDITOR_ID = "org.eclipse.ui.DefaultTextEditor";
    public static final String PL_MARKER_IMAGE_PROVIDER = "markerImageProviders";
    public static final String PL_MARKER_HELP = "markerHelp";
    public static final String PL_MARKER_RESOLUTION = "markerResolution";
    public static final String PL_CAPABILITIES = "capabilities";
    public static final String PL_PROJECT_NATURE_IMAGES = "projectNatureImages";
    private static final String ICONS_PATH = "$nl$/icons/full/";
    private ProjectImageRegistry projectImageRegistry = null;
    private MarkerImageProviderRegistry markerImageProviderRegistry = null;
    private ResourceManager resourceManager;

    static {
        DEBUG = false;
    }

    public IDEWorkbenchPlugin() {
        inst = this;
    }

    public static Object createExtension(final IConfigurationElement element, final String classAttribute) throws CoreException {
        Bundle plugin = Platform.getBundle((String)element.getNamespace());
        if (plugin.getState() == 32) {
            return element.createExecutableExtension(classAttribute);
        }
        final Object[] ret = new Object[1];
        final CoreException[] exc = new CoreException[1];
        BusyIndicator.showWhile(null, (Runnable)new Runnable(){

            @Override
            public void run() {
                try {
                    ret[0] = element.createExecutableExtension(classAttribute);
                }
                catch (CoreException e) {
                    exc[0] = e;
                }
            }
        });
        if (exc[0] != null) {
            throw exc[0];
        }
        return ret[0];
    }

    public static IDEWorkbenchPlugin getDefault() {
        return inst;
    }

    public static IWorkspace getPluginWorkspace() {
        return RemoteResourcesPlugin.getWorkspace();
    }

    public static void log(String message) {
        IDEWorkbenchPlugin.getDefault().getLog().log(StatusUtil.newStatus(4, message, null));
    }

    public static void log(String message, Throwable t) {
        IStatus status = StatusUtil.newStatus(4, message, t);
        IDEWorkbenchPlugin.log(message, status);
    }

    public static void log(Class<?> clazz, String methodName, Throwable t) {
        String msg = MessageFormat.format((String)EXCEPTION_IN_0_1_2, (Object[])new Object[]{clazz.getName(), methodName, t});
        IDEWorkbenchPlugin.log(msg, t);
    }

    public static void log(String message, IStatus status) {
        if (message != null) {
            IDEWorkbenchPlugin.getDefault().getLog().log(StatusUtil.newStatus(4, message, null));
        }
        IDEWorkbenchPlugin.getDefault().getLog().log(status);
    }

    protected void refreshPluginActions() {
    }

    public ProjectImageRegistry getProjectImageRegistry() {
        if (this.projectImageRegistry == null) {
            this.projectImageRegistry = new ProjectImageRegistry();
            this.projectImageRegistry.load();
        }
        return this.projectImageRegistry;
    }

    public MarkerImageProviderRegistry getMarkerImageProviderRegistry() {
        if (this.markerImageProviderRegistry == null) {
            this.markerImageProviderRegistry = new MarkerImageProviderRegistry();
        }
        return this.markerImageProviderRegistry;
    }

    public AboutInfo[] getFeatureInfos() {
        ArrayList<AboutInfo> infos = new ArrayList<AboutInfo>();
        IBundleGroupProvider[] providers = Platform.getBundleGroupProviders();
        if (providers != null) {
            IBundleGroupProvider[] iBundleGroupProviderArray = providers;
            int n = providers.length;
            int n2 = 0;
            while (n2 < n) {
                IBundleGroup[] bundleGroups;
                IBundleGroupProvider provider = iBundleGroupProviderArray[n2];
                IBundleGroup[] iBundleGroupArray = bundleGroups = provider.getBundleGroups();
                int n3 = bundleGroups.length;
                int n4 = 0;
                while (n4 < n3) {
                    IBundleGroup bundleGroup = iBundleGroupArray[n4];
                    infos.add(new AboutInfo(bundleGroup));
                    ++n4;
                }
                ++n2;
            }
        }
        return infos.toArray(new AboutInfo[infos.size()]);
    }

    public AboutInfo getPrimaryInfo() {
        IProduct product = Platform.getProduct();
        return product == null ? null : new AboutInfo(product);
    }

    public static ImageDescriptor getIDEImageDescriptor(String relativePath) {
        return IDEWorkbenchPlugin.imageDescriptorFromPlugin((String)IDE_WORKBENCH, (String)(ICONS_PATH + relativePath));
    }

    public ResourceManager getResourceManager() {
        if (this.resourceManager == null) {
            this.resourceManager = new LocalResourceManager(JFaceResources.getResources());
        }
        return this.resourceManager;
    }

    public void stop(BundleContext context) throws Exception {
        super.stop(context);
        if (this.resourceManager != null) {
            this.resourceManager.dispose();
        }
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        Bundle bundleGroupBundle = Platform.getBundle((String)"org.eclipse.update.configurator");
        if (bundleGroupBundle != null) {
            try {
                bundleGroupBundle.start(1);
            }
            catch (BundleException bundleException) {}
        }
    }
}

