/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.bridge;

import java.io.IOException;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.dirigible.ide.bridge.DirigibleBridge;
import org.eclipse.dirigible.ide.bridge.IInjector;
import org.eclipse.dirigible.ide.bridge.InitParametersInjector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectivityInjector
implements IInjector {
    public static final String CONNECTIVITY_CONFIGURATION = "ConnectivityConfiguration";
    private static final Logger logger = LoggerFactory.getLogger((String)ConnectivityInjector.class.getCanonicalName());

    @Override
    public void injectOnRequest(ServletConfig servletConfig, HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        Object connectivityConfiguration = System.getProperties().get(CONNECTIVITY_CONFIGURATION);
        if (connectivityConfiguration == null) {
            try {
                connectivityConfiguration = ConnectivityInjector.lookupConnectivityConfiguration();
                if (connectivityConfiguration != null) {
                    req.setAttribute(CONNECTIVITY_CONFIGURATION, connectivityConfiguration);
                    System.getProperties().put(CONNECTIVITY_CONFIGURATION, connectivityConfiguration);
                } else {
                    logger.warn("jndiConnectivityService not present");
                }
            }
            catch (Exception e) {
                logger.error(DirigibleBridge.class.getCanonicalName(), (Throwable)e);
            }
        }
    }

    @Override
    public void injectOnStart(ServletConfig servletConfig) throws ServletException, IOException {
        Object connectivityConfiguration = System.getProperties().get(CONNECTIVITY_CONFIGURATION);
        if (connectivityConfiguration == null) {
            try {
                connectivityConfiguration = ConnectivityInjector.lookupConnectivityConfiguration();
                if (connectivityConfiguration != null) {
                    System.getProperties().put(CONNECTIVITY_CONFIGURATION, connectivityConfiguration);
                } else {
                    logger.warn("jndiConnectivityService not present");
                }
            }
            catch (Exception e) {
                logger.error(DirigibleBridge.class.getCanonicalName(), (Throwable)e);
            }
        }
    }

    static Object lookupConnectivityConfiguration() throws NamingException {
        InitialContext ctx = new InitialContext();
        String key = InitParametersInjector.get("jndiConnectivityService");
        if (key != null) {
            return ctx.lookup(key);
        }
        return null;
    }
}

