/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.ide.jgit.command;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.io.IOUtils;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.dirigible.ide.common.CommonIDEParameters;
import org.eclipse.dirigible.ide.workspace.dual.WorkspaceLocator;
import org.eclipse.dirigible.repository.api.ICommonConstants;
import org.eclipse.dirigible.repository.project.ProjectMetadata;
import org.eclipse.dirigible.repository.project.ProjectMetadataDependency;
import org.eclipse.dirigible.repository.project.ProjectMetadataRepository;
import org.eclipse.dirigible.repository.project.ProjectMetadataUtils;

public class ProjectMetadataManager {
    public static void ensureProjectMetadata(String projectName, String repositoryURI, String branch) throws CoreException {
        IProject[] projects;
        IProject[] iProjectArray = projects = WorkspaceLocator.getWorkspace((HttpServletRequest)CommonIDEParameters.getRequest()).getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IFile projectFile;
            IProject project = iProjectArray[n2];
            if (project.getName().equals(projectName) && !(projectFile = project.getFile("project.json")).exists()) {
                ProjectMetadata projectMetadata = new ProjectMetadata();
                projectMetadata.setGuid(project.getName());
                ProjectMetadataRepository projectMetadataRepository = new ProjectMetadataRepository();
                projectMetadataRepository.setType("git");
                projectMetadataRepository.setUrl(repositoryURI);
                projectMetadataRepository.setBranch(branch);
                projectMetadata.setRepository(projectMetadataRepository);
                String projectMetadataJson = ProjectMetadataUtils.toJson((ProjectMetadata)projectMetadata);
                ByteArrayInputStream in = new ByteArrayInputStream(projectMetadataJson.getBytes(ICommonConstants.UTF8));
                projectFile.create((InputStream)in, true, (IProgressMonitor)new NullProgressMonitor());
            }
            ++n2;
        }
    }

    public static String getBranch(IProject selectedProject) throws IOException, CoreException {
        IFile projectFile = selectedProject.getFile("project.json");
        String content = IOUtils.toString((InputStream)projectFile.getContents());
        ProjectMetadata projectMetadata = ProjectMetadataUtils.fromJson((String)content);
        ProjectMetadataRepository repository = projectMetadata.getRepository();
        String branch = "master";
        if (repository != null) {
            branch = repository.getBranch();
        }
        return branch;
    }

    public static ProjectMetadataDependency[] getDependencies(IProject selectedProject) throws IOException, CoreException {
        IFile projectFile = selectedProject.getFile("project.json");
        if (!projectFile.exists()) {
            return null;
        }
        String content = IOUtils.toString((InputStream)projectFile.getContents());
        ProjectMetadata projectMetadata = ProjectMetadataUtils.fromJson((String)content);
        ProjectMetadataDependency[] dependencies = projectMetadata.getDependencies();
        return dependencies;
    }
}

