/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.repository.ext.security;

import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonParser;
import java.io.IOException;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.sql.DataSource;
import org.eclipse.dirigible.repository.api.ICollection;
import org.eclipse.dirigible.repository.api.ICommonConstants;
import org.eclipse.dirigible.repository.api.IRepository;
import org.eclipse.dirigible.repository.api.IResource;
import org.eclipse.dirigible.repository.ext.db.AbstractDataUpdater;
import org.eclipse.dirigible.repository.ext.security.SecurityException;
import org.eclipse.dirigible.repository.ext.security.SecurityManager;
import org.eclipse.dirigible.repository.logging.Logger;

public class SecurityUpdater
extends AbstractDataUpdater {
    private static final String NODE_ROLE = "role";
    private static final String NODE_ROLES = "roles";
    private static final String NODE_LOCATION = "location";
    public static final String EXTENSION_ACCESS = ".access";
    public static final String REGISTRY_SECURITY_CONSTRAINTS_DEFAULT = "/db/dirigible/registry/public/SecurityConstraints";
    private static final Logger logger = Logger.getLogger(SecurityUpdater.class);
    private IRepository repository;
    private DataSource dataSource;
    private String location;
    private SecurityManager securityManager;

    public SecurityUpdater(IRepository repository, DataSource dataSource, String location) {
        this.repository = repository;
        this.dataSource = dataSource;
        this.location = location;
        this.securityManager = SecurityManager.getInstance(repository, dataSource);
    }

    @Override
    public void executeUpdate(List<String> knownFiles, HttpServletRequest request, List<String> errors) throws Exception {
        if (knownFiles.size() == 0) {
            return;
        }
        try {
            Connection connection = this.dataSource.getConnection();
            try {
                for (String dsDefinition : knownFiles) {
                    try {
                        if (!dsDefinition.endsWith(EXTENSION_ACCESS)) continue;
                        this.executeAccessUpdate(connection, dsDefinition, request);
                    }
                    catch (Exception e) {
                        logger.error(e.getMessage(), (Throwable)e);
                        if (errors == null) continue;
                        errors.add(e.getMessage());
                    }
                }
            }
            finally {
                if (connection != null) {
                    connection.close();
                }
            }
        }
        catch (SQLException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
    }

    private void executeAccessUpdate(Connection connection, String scDefinition, HttpServletRequest request) throws SQLException, IOException, SecurityException {
        JsonArray scDefinitionArray = this.parseAccess(scDefinition);
        for (Object name : scDefinitionArray) {
            JsonObject locationObject = (JsonObject)name;
            String locationName = locationObject.get(NODE_LOCATION).getAsString();
            JsonArray rolesArray = locationObject.get(NODE_ROLES).getAsJsonArray();
            for (Object name2 : rolesArray) {
                JsonObject rolesObject = (JsonObject)name2;
                String roleName = rolesObject.get(NODE_ROLE).getAsString();
                this.updateRole(locationName, roleName, request);
            }
        }
    }

    private void updateRole(String locationName, String roleName, HttpServletRequest request) throws SecurityException {
        this.securityManager.secureLocationWithRole(locationName, roleName, request);
    }

    private JsonArray parseAccess(String dsDefinition) throws IOException {
        IRepository repository = this.repository;
        IResource resource = repository.getResource(dsDefinition);
        String content = new String(resource.getContent(), ICommonConstants.UTF8);
        JsonParser parser = new JsonParser();
        JsonArray dsDefinitionObject = (JsonArray)parser.parse(content);
        return dsDefinitionObject;
    }

    @Override
    public void enumerateKnownFiles(ICollection collection, List<String> dsDefinitions) throws IOException {
        if (collection.exists()) {
            List resources = collection.getResources();
            for (IResource resource : resources) {
                if (resource == null || resource.getName() == null || !resource.getName().endsWith(EXTENSION_ACCESS)) continue;
                String fullPath = resource.getPath();
                dsDefinitions.add(fullPath);
            }
            List collections = collection.getCollections();
            for (ICollection subCollection : collections) {
                this.enumerateKnownFiles(subCollection, dsDefinitions);
            }
        }
    }

    @Override
    public void applyUpdates() throws IOException, Exception {
        ArrayList<String> knownFiles = new ArrayList<String>();
        ICollection srcContainer = this.repository.getCollection(this.location);
        if (srcContainer.exists()) {
            this.enumerateKnownFiles(srcContainer, knownFiles);
            this.executeUpdate(knownFiles, null);
        }
    }

    @Override
    public IRepository getRepository() {
        return this.repository;
    }

    @Override
    public String getLocation() {
        return this.location;
    }

    @Override
    public void executeUpdate(List<String> knownFiles, List<String> errors) throws Exception {
        this.executeUpdate(knownFiles, null, errors);
    }
}

