/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.repository.local;

import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import org.eclipse.dirigible.repository.local.LocalBaseException;
import org.eclipse.dirigible.repository.local.ZipRepository;

public class JarRepository
extends ZipRepository {
    private String jarRepositoryRootFolder;

    public JarRepository(String user, String zip) throws LocalBaseException {
        JarRepository.class.getClassLoader();
        InputStream in = ClassLoader.getSystemResourceAsStream(zip);
        if (in == null) {
            in = JarRepository.class.getClassLoader().getParent().getResourceAsStream(zip);
        }
        if (in == null) {
            in = JarRepository.class.getResourceAsStream(zip);
        }
        if (in != null) {
            try {
                Path rootFolder = Files.createTempDirectory("jar_repository", new FileAttribute[0]);
                this.unpackZip(in, rootFolder.toString());
                String zipFileName = zip.substring(zip.lastIndexOf("/") + 1);
                this.jarRepositoryRootFolder = zipFileName.substring(0, zipFileName.lastIndexOf("."));
                this.createRepository(user, rootFolder.toString(), true);
            }
            catch (IOException e) {
                throw new LocalBaseException(e);
            }
        } else {
            throw new LocalBaseException(String.format("Zip file containing Repository content does not exist at path: %s", zip));
        }
    }

    protected JarRepository(String user, String rootFolder, boolean absolute) throws LocalBaseException {
        super(user, rootFolder, absolute);
    }

    protected JarRepository(String user) throws LocalBaseException {
        super(user);
    }

    protected JarRepository() throws LocalBaseException {
    }

    @Override
    protected String getRepositoryRootFolder() {
        return this.jarRepositoryRootFolder;
    }
}

