/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.runtime.listener.mail;

import com.google.gson.Gson;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import org.apache.commons.io.IOUtils;
import org.eclipse.dirigible.repository.logging.Logger;
import org.eclipse.dirigible.runtime.listener.IListenerEventProcessor;
import org.eclipse.dirigible.runtime.listener.Listener;
import org.eclipse.dirigible.runtime.listener.ListenerProcessor;
import org.eclipse.dirigible.runtime.listener.mail.IMailHandler;
import org.eclipse.dirigible.runtime.listener.mail.ImapsClient;
import org.eclipse.dirigible.runtime.listener.mail.MailMessage;

public class ImapsListenerEventProcessor
implements IListenerEventProcessor,
IMailHandler {
    private static final String PARAM_USER = "username";
    private static final String PARAM_PASSWORD = "password";
    private static final String PARAM_HOST = "host";
    private static final String PARAM_PORT = "port";
    private static final String PARAM_TIMEOUT = "timeout";
    private static final String PARAM_DEBUG = "debug";
    private static final String PARAM_FOLDER = "folder";
    private static final Logger logger = Logger.getLogger(ImapsListenerEventProcessor.class);
    private static final Object PARAM_MAIL = "message";
    private Listener listener;
    private String username;
    private String password;
    private String host;
    private String port;
    private String timeout;
    private String debug;
    private String folder;
    private ImapsClient imapsClient;
    private Gson gson = new Gson();

    @Override
    public Listener getListener() {
        return this.listener;
    }

    @Override
    public String getUsername() {
        return this.username;
    }

    @Override
    public String getPassword() {
        return this.password;
    }

    @Override
    public String getHost() {
        return this.host;
    }

    @Override
    public String getPort() {
        return this.port;
    }

    @Override
    public String getTimeout() {
        return this.timeout;
    }

    @Override
    public String getDebug() {
        return this.debug;
    }

    @Override
    public String getFolder() {
        return this.folder;
    }

    @Override
    public void handleMail(Message message) {
        HashMap<Object, Object> executionContext = new HashMap<Object, Object>();
        String mail = null;
        try {
            mail = this.parseMail(message);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        catch (MessagingException e) {
            logger.error(e.getMessage(), (Throwable)e);
        }
        logger.debug("Mail: " + mail);
        executionContext.put(PARAM_MAIL, mail);
        Object result = ListenerProcessor.executeByEngineType(this.getListener().getModule(), executionContext, this.getListener());
        if (result != null) {
            logger.info(result.toString());
        }
    }

    private String parseMail(Message message) throws IOException, MessagingException {
        MailMessage mail = new MailMessage();
        mail.setSubject(message.getSubject());
        mail.setContent(new String(IOUtils.toByteArray((InputStream)message.getInputStream()), StandardCharsets.UTF_8));
        ArrayList<String> fromList = new ArrayList<String>();
        Address[] addressArray = message.getFrom();
        int n = addressArray.length;
        int n2 = 0;
        while (n2 < n) {
            Address address = addressArray[n2];
            fromList.add(address.toString());
            ++n2;
        }
        ArrayList<String> toList = new ArrayList<String>();
        Address[] addressArray2 = message.getAllRecipients();
        int n3 = addressArray2.length;
        n = 0;
        while (n < n3) {
            Address address = addressArray2[n];
            toList.add(address.toString());
            ++n;
        }
        mail.setTo(toList.toArray(new String[0]));
        mail.setSent(message.getSentDate());
        mail.setReceived(message.getReceivedDate());
        return this.gson.toJson((Object)mail);
    }

    @Override
    public void start(Listener listener) {
        this.listener = listener;
        this.username = listener.getParams().get(PARAM_USER);
        this.password = listener.getParams().get(PARAM_PASSWORD);
        this.host = listener.getParams().get(PARAM_HOST);
        this.port = listener.getParams().get(PARAM_PORT);
        this.timeout = listener.getParams().get(PARAM_TIMEOUT);
        this.debug = listener.getParams().get(PARAM_DEBUG);
        this.folder = listener.getParams().get(PARAM_FOLDER);
        this.imapsClient = new ImapsClient();
        this.imapsClient.connect(this);
    }

    @Override
    public void stop() {
        this.imapsClient.disconnect();
    }
}

