/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.confluence.core.block;

import java.util.Stack;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.internal.wikitext.confluence.core.block.ParagraphBlock;
import org.eclipse.mylyn.wikitext.core.parser.Attributes;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.markup.Block;
import org.eclipse.mylyn.wikitext.core.parser.markup.MarkupLanguage;

public class ListBlock
extends Block {
    private static final int LINE_REMAINDER_GROUP_OFFSET = 2;
    private static final Pattern LIST_PATTERN = Pattern.compile("\\s*((?:(?:\\*)|(?:#)|(?:-))+)\\s(.*+)");
    private int blockLineCount = 0;
    private Matcher matcher;
    private Stack<ListState> listState;

    public int processLineContent(String line, int offset) {
        boolean continuation = false;
        if (this.blockLineCount == 0) {
            this.listState = new Stack();
            Attributes attributes = new Attributes();
            String listSpec = this.matcher.group(1);
            int level = this.calculateLevel(listSpec);
            DocumentBuilder.BlockType type = this.calculateType(listSpec);
            if (type == DocumentBuilder.BlockType.BULLETED_LIST && "-".equals(listSpec)) {
                attributes.setCssStyle("list-style: square");
            }
            offset = this.matcher.start(2);
            this.listState.push(new ListState(1, type));
            this.builder.beginBlock(type, attributes);
            this.adjustLevel(listSpec, level, type);
        } else {
            Matcher matcher = LIST_PATTERN.matcher(line);
            if (!matcher.matches()) {
                boolean empty = offset == 0 && this.markupLanguage.isEmptyLine(line);
                boolean breaking = ParagraphBlock.paragraphBreakingBlockMatches((MarkupLanguage)this.getMarkupLanguage(), line, offset);
                if (empty || breaking) {
                    this.setClosed(true);
                    return 0;
                }
                continuation = true;
            } else {
                String listSpec = matcher.group(1);
                int level = this.calculateLevel(listSpec);
                DocumentBuilder.BlockType type = this.calculateType(listSpec);
                offset = matcher.start(2);
                this.adjustLevel(listSpec, level, type);
            }
        }
        ++this.blockLineCount;
        ListState listState = this.listState.peek();
        if (listState.openItem) {
            if (continuation) {
                this.builder.lineBreak();
            } else {
                this.builder.endBlock();
                listState.openItem = false;
            }
        }
        if (!listState.openItem) {
            listState.openItem = true;
            this.builder.beginBlock(DocumentBuilder.BlockType.LIST_ITEM, new Attributes());
        }
        this.markupLanguage.emitMarkupLine(this.getParser(), this.state, line, offset);
        return -1;
    }

    private void adjustLevel(String listSpec, int level, DocumentBuilder.BlockType type) {
        ListState previousState = this.listState.peek();
        while (level != previousState.level || previousState.type != type) {
            Attributes blockAttributes;
            if (level > previousState.level) {
                if (!previousState.openItem) {
                    this.builder.beginBlock(DocumentBuilder.BlockType.LIST_ITEM, new Attributes());
                    previousState.openItem = true;
                }
                blockAttributes = new Attributes();
                if (type == DocumentBuilder.BlockType.BULLETED_LIST && "-".equals(listSpec)) {
                    blockAttributes.setCssStyle("list-style: square");
                }
                this.listState.push(new ListState(previousState.level + 1, type));
                this.builder.beginBlock(type, blockAttributes);
            } else {
                this.closeOne();
                if (this.listState.isEmpty()) {
                    blockAttributes = new Attributes();
                    if (type == DocumentBuilder.BlockType.BULLETED_LIST && "-".equals(listSpec)) {
                        blockAttributes.setCssStyle("list-style: square");
                    }
                    this.listState.push(new ListState(1, type));
                    this.builder.beginBlock(type, blockAttributes);
                }
            }
            previousState = this.listState.peek();
        }
    }

    private int calculateLevel(String listSpec) {
        return listSpec.length();
    }

    private DocumentBuilder.BlockType calculateType(String listSpec) {
        return listSpec.charAt(listSpec.length() - 1) == '#' ? DocumentBuilder.BlockType.NUMERIC_LIST : DocumentBuilder.BlockType.BULLETED_LIST;
    }

    public boolean canStart(String line, int lineOffset) {
        int level;
        String listSpec;
        this.blockLineCount = 0;
        this.listState = null;
        this.matcher = LIST_PATTERN.matcher(line);
        this.matcher.region(lineOffset, line.length());
        boolean matches = this.matcher.matches();
        if (matches && (listSpec = this.matcher.group(1)).charAt(0) == '-' && (level = this.calculateLevel(listSpec)) > 1) {
            return false;
        }
        return matches;
    }

    public void setClosed(boolean closed) {
        if (closed && !this.isClosed()) {
            while (this.listState != null && !this.listState.isEmpty()) {
                this.closeOne();
            }
            this.listState = null;
        }
        super.setClosed(closed);
    }

    private void closeOne() {
        ListState e = this.listState.pop();
        if (e.openItem) {
            this.builder.endBlock();
        }
        this.builder.endBlock();
    }

    private static class ListState {
        int level;
        DocumentBuilder.BlockType type;
        boolean openItem;

        private ListState(int level, DocumentBuilder.BlockType type) {
            this.level = level;
            this.type = type;
        }
    }
}

