/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.mylyn.internal.wikitext.textile.core.block;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.mylyn.wikitext.core.parser.Attributes;
import org.eclipse.mylyn.wikitext.core.parser.DocumentBuilder;
import org.eclipse.mylyn.wikitext.core.parser.ListAttributes;
import org.eclipse.mylyn.wikitext.core.parser.markup.Block;

public class DefinitionListBlock
extends Block {
    private static final Pattern START_PATTERN = Pattern.compile("(?:(;\\s+(.+))|(-\\s+(.+?)\\s*(:=)\\s*((.+?)\\s*(=:)?)?))");
    private static final Pattern END_ITEM_PATTERN = Pattern.compile("(.*?)\\s*(=:)\\s*");
    private static final Pattern COLON_START_PATTERN = Pattern.compile(":\\s+(.+)");
    private Matcher matcher;
    private int blockLineCount;
    private int levelsOpen = 0;
    private int linesThisItem = 0;

    /*
     * Enabled aggressive block sorting
     */
    protected int processLineContent(String line, int offset) {
        ++this.blockLineCount;
        if (this.blockLineCount == 1) {
            this.beginBlock(DocumentBuilder.BlockType.DEFINITION_LIST, (Attributes)new ListAttributes());
            this.handleStartTerm();
            return -1;
        }
        this.matcher = START_PATTERN.matcher(line);
        if (this.matcher.matches()) {
            this.closeItems();
            this.handleStartTerm();
            return -1;
        }
        String content = line;
        int contentOffset = 0;
        boolean closeThisLine = false;
        if (this.levelsOpen < 2) {
            Matcher ddMatcher = COLON_START_PATTERN.matcher(line);
            if (!ddMatcher.matches()) {
                this.setClosed(true);
                return 0;
            }
            content = ddMatcher.group(1);
            contentOffset = ddMatcher.start(1);
            this.closeItems();
            this.beginBlock(DocumentBuilder.BlockType.DEFINITION_ITEM, new Attributes());
            this.linesThisItem = 0;
            closeThisLine = true;
        } else {
            if (this.markupLanguage.isEmptyLine(line)) {
                this.setClosed(true);
                return 0;
            }
            Matcher endMatcher = END_ITEM_PATTERN.matcher(line);
            if (endMatcher.matches()) {
                content = endMatcher.group(1);
            }
        }
        if (this.markupLanguage.isEmptyLine(content)) {
            this.closeItems();
            return -1;
        }
        if (++this.linesThisItem > 1) {
            this.builder.lineBreak();
        }
        this.markupLanguage.emitMarkupLine(this.getParser(), this.state, contentOffset, content, offset);
        if (closeThisLine) {
            this.endBlock();
        }
        return -1;
    }

    protected void handleStartTerm() {
        int textLineOffset;
        this.linesThisItem = 0;
        String term = this.matcher.group(2);
        String definition = null;
        int definitionOffset = 0;
        int definitionSegmentOffset = 0;
        boolean definitionEnd = false;
        if (term == null) {
            term = this.matcher.group(4);
            textLineOffset = this.matcher.start(4);
            definition = this.matcher.group(7);
            definitionOffset = this.matcher.start(7);
            definitionEnd = this.matcher.group(8) != null;
            definitionSegmentOffset = this.matcher.start(5);
            this.state.setLineSegmentEndOffset(definitionSegmentOffset);
        } else {
            textLineOffset = this.matcher.start(2);
        }
        this.beginBlock(DocumentBuilder.BlockType.DEFINITION_TERM, new Attributes());
        this.markupLanguage.emitMarkupLine(this.getParser(), this.state, textLineOffset, term, 0);
        this.endBlock();
        if (definition != null) {
            this.state.setLineCharacterOffset(definitionSegmentOffset);
            this.beginBlock(DocumentBuilder.BlockType.DEFINITION_ITEM, new Attributes());
            this.markupLanguage.emitMarkupLine(this.getParser(), this.state, definitionOffset, definition, 0);
            if (definitionEnd) {
                this.endBlock();
            } else {
                this.linesThisItem = 1;
            }
        }
    }

    private void closeItems() {
        while (this.levelsOpen > 1) {
            this.endBlock();
        }
    }

    public void beginBlock(DocumentBuilder.BlockType type, Attributes attributes) {
        ++this.levelsOpen;
        this.builder.beginBlock(type, attributes);
    }

    public void endBlock() {
        --this.levelsOpen;
        this.builder.endBlock();
    }

    public void setClosed(boolean closed) {
        if (closed && !this.isClosed()) {
            while (this.levelsOpen > 0) {
                this.endBlock();
            }
        }
        super.setClosed(closed);
    }

    public boolean canStart(String line, int lineOffset) {
        this.blockLineCount = 0;
        this.matcher = START_PATTERN.matcher(line);
        if (lineOffset > 0) {
            this.matcher.region(lineOffset, line.length());
        }
        if (this.matcher.matches()) {
            return true;
        }
        this.matcher = null;
        return false;
    }
}

