/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.dirigible.repository.ext.db;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.sql.DataSource;
import org.eclipse.dirigible.repository.api.ICollection;
import org.eclipse.dirigible.repository.api.ICommonConstants;
import org.eclipse.dirigible.repository.api.IRepository;
import org.eclipse.dirigible.repository.api.IResource;
import org.eclipse.dirigible.repository.ext.db.AbstractDataUpdater;
import org.eclipse.dirigible.repository.ext.db.DBSequenceUtils;
import org.eclipse.dirigible.repository.ext.db.DBUtils;
import org.eclipse.dirigible.repository.ext.db.transfer.DBTableDataReader;
import org.eclipse.dirigible.repository.ext.db.transfer.DBTableImporter;
import org.eclipse.dirigible.repository.ext.utils.CommonUtils;
import org.eclipse.dirigible.repository.logging.Logger;

public class DsvUpdater
extends AbstractDataUpdater {
    private static final String DELETE_FROM = "DELETE FROM ";
    private static final String DELETE_FROM_WHERE = "DELETE FROM %s WHERE %s = %s";
    private static final String SELECT_FROM_WHERE = "SELECT * FROM %s WHERE %s = %s";
    private static final String SELECT_COUNT_FROM = "SELECT COUNT(*) FROM ";
    private static final String EXTENSION_TABLE = ".table";
    private static final String EXTENSION_DSV = ".dsv";
    private static final String EXTENSION_REPLACE = ".replace";
    private static final String EXTENSION_APPEND = ".append";
    private static final String EXTENSION_DELETE = ".delete";
    private static final String EXTENSION_UPDATE = ".update";
    private static final String COLUMN_NAME = "COLUMN_NAME";
    private static final Logger logger = Logger.getLogger(DsvUpdater.class);
    private IRepository repository;
    private DataSource dataSource;
    private String location;

    public DsvUpdater(IRepository repository, DataSource dataSource, String location) {
        this.repository = repository;
        this.dataSource = dataSource;
        this.location = location;
    }

    @Override
    public void enumerateKnownFiles(ICollection collection, List<String> dsDefinitions) throws IOException {
        if (collection.exists()) {
            List resources = collection.getResources();
            for (IResource resource : resources) {
                if (resource == null || resource.getName() == null || !resource.getName().endsWith(EXTENSION_DSV) && !resource.getName().endsWith(EXTENSION_REPLACE) && !resource.getName().endsWith(EXTENSION_APPEND) && !resource.getName().endsWith(EXTENSION_DELETE) && !resource.getName().endsWith(EXTENSION_UPDATE)) continue;
                String fullPath = resource.getPath();
                dsDefinitions.add(fullPath);
            }
            List collections = collection.getCollections();
            for (ICollection subCollection : collections) {
                this.enumerateKnownFiles(subCollection, dsDefinitions);
            }
        }
    }

    @Override
    public void executeUpdate(List<String> knownFiles, List<String> errors) throws Exception {
        if (knownFiles.size() == 0) {
            return;
        }
        for (String dsDefinition : knownFiles) {
            try {
                if (dsDefinition.endsWith(EXTENSION_DSV)) {
                    this.executeReplaceRows(dsDefinition);
                    continue;
                }
                if (dsDefinition.endsWith(EXTENSION_REPLACE)) {
                    this.executeReplaceRows(dsDefinition);
                    continue;
                }
                if (dsDefinition.endsWith(EXTENSION_APPEND)) {
                    this.executeAppendRows(dsDefinition);
                    continue;
                }
                if (dsDefinition.endsWith(EXTENSION_DELETE)) {
                    this.executeDeleteRows(dsDefinition);
                    continue;
                }
                if (!dsDefinition.endsWith(EXTENSION_UPDATE)) continue;
                this.executeUpdateRows(dsDefinition);
            }
            catch (Exception e) {
                logger.error(e.getMessage(), (Throwable)e);
                if (errors == null) continue;
                errors.add(e.getMessage());
            }
        }
    }

    @Override
    public void executeUpdate(List<String> knownFiles, HttpServletRequest request, List<String> errors) throws Exception {
        this.executeUpdate(knownFiles, errors);
    }

    private void executeReplaceRows(String dsDefinition) throws Exception {
        logger.info("Processing rows with type 'replace': " + dsDefinition);
        String tableName = CommonUtils.getFileNameFromRepositoryPathNoExtension(dsDefinition);
        this.deleteAllDataFromTable(tableName);
        IResource resource = this.repository.getResource(dsDefinition);
        byte[] content = resource.getContent();
        if (content.length != 0) {
            DBTableImporter tableDataInserter = new DBTableImporter(this.dataSource, content, String.valueOf(tableName) + EXTENSION_TABLE);
            tableDataInserter.insert();
            this.moveSequence(tableName);
        }
    }

    private void executeAppendRows(String dsDefinition) throws Exception {
        IResource resource;
        byte[] content;
        logger.info("Processing rows with type 'append': " + dsDefinition);
        String tableName = CommonUtils.getFileNameFromRepositoryPathNoExtension(dsDefinition);
        int tableRowsCount = this.getTableRowsCount(tableName);
        if (tableRowsCount == 0 && (content = (resource = this.repository.getResource(dsDefinition)).getContent()).length != 0) {
            DBTableImporter tableDataInserter = new DBTableImporter(this.dataSource, content, String.valueOf(tableName) + EXTENSION_TABLE);
            tableDataInserter.insert();
            this.moveSequence(tableName);
        }
    }

    protected void moveSequence(String tableName) throws Exception, SQLException {
        int tableRowsCount = this.getTableRowsCount(tableName);
        String primaryKey = this.getPrimaryKey(tableName);
        String sequenceName = String.valueOf(tableName.toUpperCase()) + "_" + primaryKey.toUpperCase();
        DBSequenceUtils dbSequenceUtils = new DBSequenceUtils(this.dataSource);
        dbSequenceUtils.createSequence(sequenceName, ++tableRowsCount);
    }

    private void executeDeleteRows(String dsDefinition) throws Exception {
        logger.info("Processing rows with type 'delete': " + dsDefinition);
        IResource resource = this.repository.getResource(dsDefinition);
        if (resource != null) {
            String tableName = CommonUtils.getFileNameFromRepositoryPathNoExtension(dsDefinition);
            String primaryKey = this.getPrimaryKey(tableName);
            byte[] content = resource.getContent();
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)new ByteArrayInputStream(content), ICommonConstants.UTF8));
            String firstLine = reader.readLine();
            if (firstLine != null && firstLine.trim().equals("*")) {
                this.deleteAllDataFromTable(tableName);
            } else {
                this.deleteRowsDataFromTable(tableName, primaryKey, resource.getContent());
            }
        }
    }

    private void executeUpdateRows(String dsDefinition) throws Exception {
        logger.info("Processing rows with type 'delete': " + dsDefinition);
        IResource resource = this.repository.getResource(dsDefinition);
        if (resource != null) {
            String tableName = CommonUtils.getFileNameFromRepositoryPathNoExtension(dsDefinition);
            String primaryKey = this.getPrimaryKey(tableName);
            resource.getContent();
            this.updateRowsDataInTable(tableName, primaryKey, resource.getContent());
        }
    }

    private String getPrimaryKey(String tableName) throws Exception {
        String result = null;
        Connection connection = null;
        try {
            connection = this.dataSource.getConnection();
            ResultSet primaryKeys = DBUtils.getPrimaryKeys(connection, tableName);
            ArrayList<String> primaryKeysList = new ArrayList<String>();
            while (primaryKeys.next()) {
                String columnName = primaryKeys.getString(COLUMN_NAME);
                primaryKeysList.add(columnName);
            }
            if (primaryKeysList.size() == 0) {
                throw new Exception(String.format("Trying to manipulate data records for a table without a primary key: %s", tableName));
            }
            if (primaryKeysList.size() > 1) {
                throw new Exception(String.format("Trying to manipulate data records for a table with more than one columns in the primary key: %s", tableName));
            }
            result = (String)primaryKeysList.get(0);
        }
        finally {
            if (connection != null) {
                connection.close();
            }
        }
        return result;
    }

    private void deleteAllDataFromTable(String tableName) throws Exception {
        Connection con = null;
        try {
            con = this.getConnection();
            PreparedStatement deleteStatement = con.prepareStatement(DELETE_FROM + tableName);
            deleteStatement.execute();
        }
        finally {
            if (con != null) {
                con.close();
            }
        }
    }

    private void deleteRowsDataFromTable(String tableName, String primaryKey, byte[] fileContent) throws Exception {
        Connection con = null;
        try {
            con = this.getConnection();
            List<String[]> records = DBTableDataReader.readRecords(new ByteArrayInputStream(fileContent));
            for (String[] record : records) {
                if (record.length > 0) {
                    PreparedStatement deleteStatement = con.prepareStatement(String.format(DELETE_FROM_WHERE, tableName, primaryKey, record[0]));
                    deleteStatement.execute();
                    continue;
                }
                logger.error(String.format("Skipping deletion of an empty data row for table: %s", tableName));
            }
        }
        finally {
            if (con != null) {
                con.close();
            }
        }
    }

    private void updateRowsDataInTable(String tableName, String primaryKey, byte[] fileContent) throws Exception {
        Connection con = null;
        try {
            con = this.getConnection();
            List<String[]> records = DBTableDataReader.readRecords(new ByteArrayInputStream(fileContent));
            for (String[] record : records) {
                if (record.length > 0) {
                    PreparedStatement stmt = con.prepareStatement(String.format(SELECT_FROM_WHERE, tableName, primaryKey, record[0]));
                    ResultSet rs = stmt.executeQuery();
                    if (rs.next()) continue;
                    StringBuffer buff = new StringBuffer();
                    String[] stringArray = record;
                    int n = record.length;
                    int n2 = 0;
                    while (n2 < n) {
                        String value = stringArray[n2];
                        buff.append(value).append("|");
                        ++n2;
                    }
                    buff.deleteCharAt(buff.length() - 1);
                    buff.append("\n");
                    DBTableImporter tableDataInserter = new DBTableImporter(this.dataSource, buff.toString().getBytes(), String.valueOf(tableName) + EXTENSION_TABLE);
                    tableDataInserter.insert();
                    continue;
                }
                logger.error(String.format("Skipping update of an empty data row for table: %s", tableName));
            }
        }
        finally {
            if (con != null) {
                con.close();
            }
        }
    }

    private int getTableRowsCount(String tableName) throws Exception {
        Connection con = null;
        try {
            con = this.getConnection();
            PreparedStatement countStatement = con.prepareStatement(SELECT_COUNT_FROM + tableName);
            ResultSet rs = countStatement.executeQuery();
            if (rs.next()) {
                int count;
                int n = count = rs.getInt(1);
                return n;
            }
        }
        finally {
            if (con != null) {
                con.close();
            }
        }
        return -1;
    }

    private Connection getConnection() throws Exception {
        return this.dataSource.getConnection();
    }

    @Override
    public IRepository getRepository() {
        return this.repository;
    }

    @Override
    public String getLocation() {
        return this.location;
    }
}

