/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.pde.internal.ui.search.dependencies;

import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.ListIterator;
import java.util.Stack;
import java.util.Vector;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jdt.core.IClassFile;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragment;
import org.eclipse.jdt.core.IType;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.core.search.IJavaSearchScope;
import org.eclipse.jdt.core.search.SearchEngine;
import org.eclipse.jdt.core.search.SearchMatch;
import org.eclipse.jdt.core.search.SearchParticipant;
import org.eclipse.jdt.core.search.SearchPattern;
import org.eclipse.jdt.core.search.SearchRequestor;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.pde.core.plugin.IPluginImport;
import org.eclipse.pde.core.plugin.IPluginModelBase;
import org.eclipse.pde.core.plugin.PluginRegistry;
import org.eclipse.pde.internal.core.ClasspathUtilCore;
import org.eclipse.pde.internal.core.ibundle.IBundle;
import org.eclipse.pde.internal.core.ibundle.IBundlePluginModelBase;
import org.eclipse.pde.internal.core.ibundle.IManifestHeader;
import org.eclipse.pde.internal.core.search.PluginJavaSearchUtil;
import org.eclipse.pde.internal.core.text.bundle.ExportPackageHeader;
import org.eclipse.pde.internal.core.text.bundle.ImportPackageHeader;
import org.eclipse.pde.internal.core.text.bundle.ImportPackageObject;
import org.eclipse.pde.internal.core.text.bundle.PackageObject;
import org.eclipse.pde.internal.ui.PDEUIMessages;

public class GatherUnusedDependenciesOperation
implements IRunnableWithProgress {
    private IPluginModelBase fModel;
    private ArrayList fList;

    public GatherUnusedDependenciesOperation(IPluginModelBase model) {
        this.fModel = model;
    }

    public void run(IProgressMonitor monitor) throws InvocationTargetException, InterruptedException {
        ImportPackageObject[] packages = null;
        Vector exportedPackages = null;
        if (ClasspathUtilCore.hasBundleStructure((IPluginModelBase)this.fModel)) {
            IBundle bundle = ((IBundlePluginModelBase)this.fModel).getBundleModel().getBundle();
            IManifestHeader header = bundle.getManifestHeader("Import-Package");
            if (header instanceof ImportPackageHeader) {
                packages = ((ImportPackageHeader)header).getPackages();
            } else if (header != null && header.getValue() != null) {
                header = new ImportPackageHeader("Import-Package", header.getValue(), bundle, System.getProperty("line.separator"));
                packages = ((ImportPackageHeader)header).getPackages();
            }
            header = bundle.getManifestHeader("Export-Package");
            if (header instanceof ExportPackageHeader) {
                exportedPackages = ((ExportPackageHeader)header).getPackageNames();
            } else if (header != null && header.getValue() != null) {
                header = new ExportPackageHeader("Export-Package", header.getValue(), bundle, System.getProperty("line.seperator"));
                exportedPackages = ((ExportPackageHeader)header).getPackageNames();
            }
        }
        IPluginImport[] imports = this.fModel.getPluginBase().getImports();
        int totalWork = imports.length * 3 + (packages != null ? packages.length : 0) + 1;
        monitor.beginTask("", totalWork);
        HashMap<String, IPluginImport> usedPlugins = new HashMap<String, IPluginImport>();
        this.fList = new ArrayList();
        int i = 0;
        while (i < imports.length) {
            if (monitor.isCanceled()) break;
            if (this.isUnused(imports[i], new SubProgressMonitor(monitor, 3))) {
                this.fList.add(imports[i]);
            } else {
                usedPlugins.put(imports[i].getId(), imports[i]);
            }
            this.updateMonitor(monitor, this.fList.size());
            ++i;
        }
        ArrayList<ImportPackageObject> usedPackages = new ArrayList<ImportPackageObject>();
        if (packages != null && !monitor.isCanceled()) {
            int i2 = 0;
            while (i2 < packages.length) {
                if (monitor.isCanceled()) break;
                if (this.isUnused(packages[i2], exportedPackages, new SubProgressMonitor(monitor, 1))) {
                    this.fList.add(packages[i2]);
                    this.updateMonitor(monitor, this.fList.size());
                } else {
                    usedPackages.add(packages[i2]);
                }
                ++i2;
            }
        }
        if (!monitor.isCanceled()) {
            this.minimizeDependencies(usedPlugins, usedPackages, monitor);
        }
        monitor.done();
    }

    private void updateMonitor(IProgressMonitor monitor, int size) {
        monitor.setTaskName(String.valueOf(PDEUIMessages.UnusedDependencies_analyze) + size + " " + PDEUIMessages.UnusedDependencies_unused + " " + (size == 1 ? PDEUIMessages.DependencyExtent_singular : PDEUIMessages.DependencyExtent_plural) + " " + PDEUIMessages.DependencyExtent_found);
    }

    private boolean isUnused(IPluginImport plugin, SubProgressMonitor monitor) {
        IPluginModelBase[] models = PluginJavaSearchUtil.getPluginImports((IPluginImport)plugin);
        return !this.provideJavaClasses(models, (IProgressMonitor)monitor);
    }

    private boolean isUnused(ImportPackageObject pkg, Collection exportedPackages, SubProgressMonitor monitor) {
        if (exportedPackages != null && exportedPackages.contains(pkg.getValue())) {
            monitor.done();
            return false;
        }
        return !this.provideJavaClasses(pkg, (IProgressMonitor)monitor);
    }

    /*
     * Unable to fully structure code
     */
    private boolean provideJavaClasses(IPluginModelBase[] models, IProgressMonitor monitor) {
        try {
            project = this.fModel.getUnderlyingResource().getProject();
            if (!project.hasNature("org.eclipse.jdt.core.javanature")) {
                return false;
            }
            jProject = JavaCore.create((IProject)project);
            packageFragments = PluginJavaSearchUtil.collectPackageFragments((IPluginModelBase[])models, (IJavaProject)jProject, (boolean)true);
            engine = new SearchEngine();
            searchScope = PluginJavaSearchUtil.createSeachScope((IJavaProject)jProject);
            monitor.beginTask("", packageFragments.length * 2);
            i = 0;
            while (i < packageFragments.length) {
                block11: {
                    pkgFragment = packageFragments[i];
                    if (!pkgFragment.hasChildren()) ** GOTO lbl24
                    requestor = new Requestor();
                    engine.search(SearchPattern.createPattern((IJavaElement)pkgFragment, (int)2), new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, searchScope, (SearchRequestor)requestor, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                    if (!requestor.foundMatches()) break block11;
                    if (this.provideJavaClasses(packageFragments[i], engine, searchScope, (IProgressMonitor)new SubProgressMonitor(monitor, 1))) {
                        return true;
                    }
                    ** GOTO lbl25
                }
                try {
                    block12: {
                        monitor.worked(1);
                        break block12;
lbl24:
                        // 1 sources

                        monitor.worked(2);
                    }
                    ++i;
                    continue;
                }
                catch (CoreException v0) {}
                break;
            }
        }
        finally {
            monitor.done();
        }
        return false;
    }

    private boolean provideJavaClasses(IPackageFragment packageFragment, SearchEngine engine, IJavaSearchScope searchScope, IProgressMonitor monitor) throws JavaModelException, CoreException {
        IJavaElement[] children = packageFragment.getChildren();
        monitor.beginTask("", children.length);
        try {
            int j = 0;
            while (j < children.length) {
                IType[] types = null;
                if (children[j] instanceof ICompilationUnit) {
                    types = ((ICompilationUnit)children[j]).getAllTypes();
                } else if (children[j] instanceof IClassFile) {
                    types = new IType[]{((IClassFile)children[j]).getType()};
                }
                if (types != null) {
                    int t = 0;
                    while (t < types.length) {
                        Requestor requestor = new Requestor();
                        engine.search(SearchPattern.createPattern((IJavaElement)types[t], (int)2), new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, searchScope, (SearchRequestor)requestor, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
                        if (requestor.foundMatches()) {
                            return true;
                        }
                        ++t;
                    }
                }
                ++j;
            }
        }
        finally {
            monitor.done();
        }
        return false;
    }

    private boolean provideJavaClasses(ImportPackageObject pkg, IProgressMonitor monitor) {
        try {
            IProject project = this.fModel.getUnderlyingResource().getProject();
            if (!project.hasNature("org.eclipse.jdt.core.javanature")) {
                return false;
            }
            monitor.beginTask("", 1);
            IJavaProject jProject = JavaCore.create((IProject)project);
            SearchEngine engine = new SearchEngine();
            IJavaSearchScope searchScope = PluginJavaSearchUtil.createSeachScope((IJavaProject)jProject);
            Requestor requestor = new Requestor();
            String packageName = pkg.getName();
            engine.search(SearchPattern.createPattern((String)packageName, (int)2, (int)2, (int)0), new SearchParticipant[]{SearchEngine.getDefaultSearchParticipant()}, searchScope, (SearchRequestor)requestor, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            if (requestor.foundMatches()) {
                return true;
            }
        }
        catch (CoreException coreException) {
        }
        finally {
            monitor.done();
        }
        return false;
    }

    public ArrayList getList() {
        return this.fList;
    }

    public static void removeDependencies(IPluginModelBase model, Object[] elements) {
        ImportPackageHeader pkgHeader = null;
        int i = 0;
        while (i < elements.length) {
            if (elements[i] instanceof IPluginImport) {
                try {
                    model.getPluginBase().remove((IPluginImport)elements[i]);
                }
                catch (CoreException coreException) {}
            } else if (elements[i] instanceof ImportPackageObject) {
                if (pkgHeader == null) {
                    pkgHeader = (ImportPackageHeader)((ImportPackageObject)elements[i]).getHeader();
                }
                pkgHeader.removePackage((PackageObject)((ImportPackageObject)elements[i]));
            }
            ++i;
        }
    }

    private void minimizeDependencies(HashMap usedPlugins, ArrayList usedPackages, IProgressMonitor monitor) {
        ListIterator li = usedPackages.listIterator();
        while (li.hasNext()) {
            ImportPackageObject ipo = (ImportPackageObject)li.next();
            String bundle = ipo.getAttribute("bundle-symbolic-name");
            if (!usedPlugins.containsKey(bundle)) continue;
            this.fList.add(ipo);
        }
        Iterator it = usedPlugins.keySet().iterator();
        Stack<String> plugins = new Stack<String>();
        while (it.hasNext()) {
            plugins.push(it.next().toString());
        }
        while (!plugins.isEmpty()) {
            String pluginId = (String)plugins.pop();
            IPluginModelBase base = PluginRegistry.findModel((String)pluginId);
            if (base == null) continue;
            IPluginImport[] imports = base.getPluginBase().getImports();
            int j = 0;
            while (j < imports.length) {
                if (imports[j].isReexported()) {
                    String reExportedId = imports[j].getId();
                    Object pluginImport = usedPlugins.remove(imports[j].getId());
                    if (pluginImport != null) {
                        this.fList.add(pluginImport);
                        this.updateMonitor(monitor, this.fList.size());
                    }
                    plugins.push(reExportedId);
                }
                ++j;
            }
        }
    }

    class Requestor
    extends SearchRequestor {
        boolean fFound = false;

        Requestor() {
        }

        public void acceptSearchMatch(SearchMatch match) throws CoreException {
            this.fFound = true;
        }

        public boolean foundMatches() {
            return this.fFound;
        }
    }
}

