/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.e4.xwt.tools.ui.designer.loader;

import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.IWorkspaceRoot;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.e4.xwt.ILoadingContext;
import org.eclipse.e4.xwt.XWTLoader;
import org.eclipse.e4.xwt.metadata.IMetaclass;
import org.eclipse.e4.xwt.metadata.IProperty;
import org.eclipse.e4.xwt.tools.ui.designer.editor.XWTDesigner;
import org.eclipse.e4.xwt.tools.ui.designer.editor.model.XWTModelBuilder;
import org.eclipse.e4.xwt.tools.ui.designer.loader.XWTProxy;
import org.eclipse.e4.xwt.tools.ui.designer.loader.metadata.HeightProperty;
import org.eclipse.e4.xwt.tools.ui.designer.loader.metadata.WidthProperty;
import org.eclipse.e4.xwt.tools.ui.xaml.XamlDocument;
import org.eclipse.e4.xwt.ui.utils.ProjectContext;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.swt.widgets.Control;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XWTVisualLoader
extends XWTLoader {
    private static IProperty widthProperty;
    private static IProperty heightProperty;
    private IFile file;

    public XWTVisualLoader(IFile file) {
        if (file != null && file.exists()) {
            IJavaProject project = JavaCore.create((IProject)file.getProject());
            if (project != null && project.exists()) {
                ProjectContext context = ProjectContext.getContext((IJavaProject)project);
                this.setLoadingContext((ILoadingContext)context);
            }
            this.file = file;
        }
    }

    public URL getResourcePath() {
        if (this.file != null && this.file.exists()) {
            try {
                return this.file.getLocation().toFile().toURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {}
        }
        return null;
    }

    public synchronized Control loadWithOptions(InputStream stream, URL base, Map<String, Object> options) throws Exception {
        return super.loadWithOptions(stream, base, options);
    }

    public synchronized Control loadWithOptions(URL url, Map<String, Object> options) throws Exception {
        IFile file;
        block12: {
            IWorkspace workspace = ResourcesPlugin.getWorkspace();
            IWorkspaceRoot root = workspace.getRoot();
            String fileStr = url.getFile();
            if (fileStr.indexOf("%20") != -1) {
                fileStr = fileStr.replace("%20", " ");
            }
            if ((file = root.getFileForLocation((IPath)new Path(fileStr))) != null) {
                try {
                    IPackageFragmentRoot[] allPackageFragmentRoots;
                    IProject project = file.getProject();
                    String fullPath = file.getFullPath().toString();
                    IJavaProject javaProject = JavaCore.create((IProject)project);
                    String outputPath = javaProject.getOutputLocation().toString();
                    if (fullPath == null || outputPath == null || !fullPath.startsWith(outputPath)) break block12;
                    String fileSourcePath = fullPath.substring(outputPath.length());
                    IPackageFragmentRoot[] iPackageFragmentRootArray = allPackageFragmentRoots = javaProject.getAllPackageFragmentRoots();
                    int n = allPackageFragmentRoots.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IFolder resource;
                        IFile sourceFile;
                        IPackageFragmentRoot pRoot = iPackageFragmentRootArray[n2];
                        if (pRoot.getKind() == 1 && (sourceFile = (resource = (IFolder)pRoot.getResource()).getFile((IPath)new Path(fileSourcePath))) != null && sourceFile.exists()) {
                            file = sourceFile;
                            break;
                        }
                        ++n2;
                    }
                }
                catch (Exception exception) {}
            }
        }
        if (file != null) {
            IWorkbenchPage activePage = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
            IEditorPart activeEditor = activePage.getActiveEditor();
            try {
                XWTDesigner designer = (XWTDesigner)activePage.openEditor((IEditorInput)new FileEditorInput(file), "org.eclipse.e4.xwt.tools.ui.designer.XWTDesigner", false);
                XamlDocument xamlDocument = (XamlDocument)designer.getDocumentRoot();
                XWTModelBuilder builder = null;
                if (xamlDocument == null) {
                    builder = new XWTModelBuilder();
                    builder.doLoad((IEditorPart)designer, null);
                    xamlDocument = builder.getDiagram();
                }
                Control control = (Control)new XWTProxy(file).load(xamlDocument.getRootElement(), options);
                if (builder != null) {
                    builder.dispose();
                }
                Control control2 = control;
                return control2;
            }
            finally {
                activePage.activate((IWorkbenchPart)activeEditor);
            }
        }
        return null;
    }

    public synchronized IMetaclass registerMetaclass(Class<?> type) {
        IProperty[] properties;
        IMetaclass metaclass = super.registerMetaclass(type);
        if (metaclass != null && type != null && Control.class.isAssignableFrom(type) && (properties = metaclass.getProperties()) != null) {
            List<IProperty> propList;
            if (widthProperty == null) {
                widthProperty = new WidthProperty();
            }
            if (heightProperty == null) {
                heightProperty = new HeightProperty();
            }
            if (!(propList = Arrays.asList(properties)).contains(widthProperty)) {
                metaclass.addProperty(widthProperty);
            }
            if (!propList.contains(heightProperty)) {
                metaclass.addProperty(heightProperty);
            }
        }
        return metaclass;
    }
}

