/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.corext.refactoring.typeconstraints;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import org.eclipse.core.runtime.Assert;

public final class ConstraintOperator {
    private final String fOperatorString;
    private final int fOperatorCode;
    private static final int CODE_SUBTYPE = 0;
    private static final int CODE_EQUALS = 1;
    private static final int CODE_DEFINES = 2;
    private static final int CODE_STRICT_SUBTYPE = 3;
    private static final String STRING_SUBTYPE = "<=";
    private static final String STRING_EQUALS = "==";
    private static final String STRING_DEFINES = "=^=";
    private static final String STRING_STRICT_SUBTYPE = "<";
    private static final Collection fgOperatorStrings = new HashSet<String>(Arrays.asList("<=", "==", "=^=", "<"));
    private static final ConstraintOperator fgSubtype = new ConstraintOperator("<=", 0);
    private static final ConstraintOperator fgEquals = new ConstraintOperator("==", 1);
    private static final ConstraintOperator fgDefines = new ConstraintOperator("=^=", 2);
    private static final ConstraintOperator fgStrictSubtype = new ConstraintOperator("<", 3);

    public static ConstraintOperator createSubTypeOperator() {
        return fgSubtype;
    }

    public static ConstraintOperator createEqualsOperator() {
        return fgEquals;
    }

    public static ConstraintOperator createDefinesOperator() {
        return fgDefines;
    }

    public static ConstraintOperator createStrictSubtypeOperator() {
        return fgStrictSubtype;
    }

    private ConstraintOperator(String string, int code) {
        Assert.isTrue((boolean)fgOperatorStrings.contains(string));
        Assert.isTrue((code == 2 || code == 1 || code == 3 || code == 0 ? 1 : 0) != 0);
        this.fOperatorString = string;
        this.fOperatorCode = code;
    }

    public String getOperatorString() {
        return this.fOperatorString;
    }

    public String toString() {
        return this.getOperatorString();
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ConstraintOperator)) {
            return false;
        }
        ConstraintOperator other = (ConstraintOperator)obj;
        return this.fOperatorCode == other.fOperatorCode;
    }

    public int hashCode() {
        return this.fOperatorString.hashCode();
    }

    public final boolean isSubtypeOperator() {
        return this.fOperatorCode == 0;
    }

    public final boolean isStrictSubtypeOperator() {
        return this.fOperatorCode == 3;
    }

    public final boolean isEqualsOperator() {
        return this.fOperatorCode == 1;
    }

    public final boolean isDefinesOperator() {
        return this.fOperatorCode == 2;
    }
}

