/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.correction;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jdt.core.ICompilationUnit;
import org.eclipse.jdt.core.ITypeRoot;
import org.eclipse.jdt.core.dom.AST;
import org.eclipse.jdt.core.dom.ASTNode;
import org.eclipse.jdt.core.dom.ASTVisitor;
import org.eclipse.jdt.core.dom.Assignment;
import org.eclipse.jdt.core.dom.Block;
import org.eclipse.jdt.core.dom.BodyDeclaration;
import org.eclipse.jdt.core.dom.CompilationUnit;
import org.eclipse.jdt.core.dom.Expression;
import org.eclipse.jdt.core.dom.IBinding;
import org.eclipse.jdt.core.dom.ITypeBinding;
import org.eclipse.jdt.core.dom.IVariableBinding;
import org.eclipse.jdt.core.dom.SimpleName;
import org.eclipse.jdt.core.dom.SingleVariableDeclaration;
import org.eclipse.jdt.core.dom.Statement;
import org.eclipse.jdt.core.dom.StructuralPropertyDescriptor;
import org.eclipse.jdt.core.dom.SwitchStatement;
import org.eclipse.jdt.core.dom.ThisExpression;
import org.eclipse.jdt.core.dom.Type;
import org.eclipse.jdt.core.dom.VariableDeclaration;
import org.eclipse.jdt.core.dom.VariableDeclarationExpression;
import org.eclipse.jdt.core.dom.VariableDeclarationFragment;
import org.eclipse.jdt.core.dom.VariableDeclarationStatement;
import org.eclipse.jdt.core.dom.rewrite.ASTRewrite;
import org.eclipse.jdt.core.dom.rewrite.ITrackedNodePosition;
import org.eclipse.jdt.core.dom.rewrite.ImportRewrite;
import org.eclipse.jdt.core.dom.rewrite.ListRewrite;
import org.eclipse.jdt.internal.corext.codemanipulation.ContextSensitiveImportRewriteContext;
import org.eclipse.jdt.internal.corext.codemanipulation.StubUtility;
import org.eclipse.jdt.internal.corext.dom.ASTNodes;
import org.eclipse.jdt.internal.corext.dom.GenericVisitor;
import org.eclipse.jdt.internal.corext.dom.LocalVariableIndex;
import org.eclipse.jdt.internal.corext.dom.ModifierRewrite;
import org.eclipse.jdt.internal.corext.dom.Selection;
import org.eclipse.jdt.internal.corext.dom.VariableDeclarationRewrite;
import org.eclipse.jdt.internal.corext.refactoring.code.flow.FlowContext;
import org.eclipse.jdt.internal.corext.refactoring.code.flow.FlowInfo;
import org.eclipse.jdt.internal.corext.refactoring.code.flow.InOutFlowAnalyzer;
import org.eclipse.jdt.internal.corext.refactoring.surround.SurroundWithAnalyzer;
import org.eclipse.jdt.ui.SharedASTProvider;
import org.eclipse.jdt.ui.text.java.IInvocationContext;

public abstract class SurroundWith {
    private final CompilationUnit fRootNode;
    private final Statement[] fSelectedStatements;
    private boolean fIsNewContext;
    private ITrackedNodePosition fFirstInsertedPosition;
    private ITrackedNodePosition fLastInsertedPosition;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;

    public SurroundWith(CompilationUnit root, Statement[] selectedStatements) {
        this.fRootNode = root;
        this.fSelectedStatements = selectedStatements;
    }

    public static boolean isApplicable(IInvocationContext context) throws CoreException {
        ICompilationUnit unit = context.getCompilationUnit();
        CompilationUnit ast = SharedASTProvider.getAST((ITypeRoot)unit, SharedASTProvider.WAIT_NO, null);
        if (ast == null) {
            return true;
        }
        Selection selection = Selection.createFromStartLength(context.getSelectionOffset(), context.getSelectionLength());
        SurroundWithAnalyzer analyzer = new SurroundWithAnalyzer(unit, selection);
        context.getASTRoot().accept((ASTVisitor)analyzer);
        return analyzer.getStatus().isOK() && analyzer.hasSelectedNodes();
    }

    public static Statement[] getSelectedStatements(IInvocationContext context) throws CoreException {
        Selection selection = Selection.createFromStartLength(context.getSelectionOffset(), context.getSelectionLength());
        SurroundWithAnalyzer analyzer = new SurroundWithAnalyzer(context.getCompilationUnit(), selection);
        context.getASTRoot().accept((ASTVisitor)analyzer);
        if (!analyzer.getStatus().isOK() || !analyzer.hasSelectedNodes()) {
            return null;
        }
        return analyzer.getSelectedStatements();
    }

    public int getBodyStart() {
        return this.fFirstInsertedPosition.getStartPosition();
    }

    public int getBodyLength() {
        return this.fLastInsertedPosition.getStartPosition() + this.fLastInsertedPosition.getLength() - this.getBodyStart();
    }

    public ASTRewrite getRewrite() throws CoreException {
        Statement[] selectedStatements = this.fSelectedStatements;
        AST ast = this.getAst();
        ASTRewrite rewrite = ASTRewrite.create((AST)ast);
        Statement statement = selectedStatements[0];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.jdt.core.dom.BodyDeclaration");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        BodyDeclaration enclosingBodyDeclaration = (BodyDeclaration)ASTNodes.getParent((ASTNode)statement, clazz);
        int maxVariableId = LocalVariableIndex.perform(enclosingBodyDeclaration) + 1;
        this.fIsNewContext = this.isNewContext();
        List accessedAfter = this.getVariableDeclarationsAccessedAfter((ASTNode)selectedStatements[selectedStatements.length - 1], maxVariableId);
        List readInside = this.getVariableDeclarationReadsInside(selectedStatements, maxVariableId);
        ArrayList inserted = new ArrayList();
        this.moveToBlock(selectedStatements, inserted, accessedAfter, readInside, rewrite);
        if (this.fIsNewContext) {
            ImportRewrite importRewrite = StubUtility.createImportRewrite((CompilationUnit)selectedStatements[0].getRoot(), false);
            ContextSensitiveImportRewriteContext importRewriteContext = new ContextSensitiveImportRewriteContext((ASTNode)selectedStatements[0], importRewrite);
            int i = 0;
            while (i < selectedStatements.length) {
                this.qualifyThisExpressions((ASTNode)selectedStatements[i], rewrite, importRewrite, importRewriteContext);
                ++i;
            }
        }
        if (selectedStatements.length == 1 && ASTNodes.isControlStatementBody(selectedStatements[0].getLocationInParent())) {
            Block wrap = ast.newBlock();
            rewrite.replace((ASTNode)selectedStatements[0], (ASTNode)wrap, null);
            ListRewrite listRewrite = rewrite.getListRewrite((ASTNode)wrap, Block.STATEMENTS_PROPERTY);
            Iterator iterator = inserted.iterator();
            while (iterator.hasNext()) {
                ASTNode node = (ASTNode)iterator.next();
                listRewrite.insertLast(node, null);
            }
        } else {
            ListRewrite listRewrite = this.getListRewrite((ASTNode)selectedStatements[0], rewrite);
            Statement current = selectedStatements[selectedStatements.length - 1];
            Iterator iterator = inserted.iterator();
            while (iterator.hasNext()) {
                ASTNode node = (ASTNode)iterator.next();
                listRewrite.insertAfter(node, (ASTNode)current, null);
                current = node;
            }
        }
        this.fFirstInsertedPosition = rewrite.track((ASTNode)inserted.get(0));
        this.fLastInsertedPosition = rewrite.track((ASTNode)inserted.get(inserted.size() - 1));
        return rewrite;
    }

    protected abstract boolean isNewContext();

    protected List getVariableDeclarationReadsInside(Statement[] selectedNodes, int maxVariableId) {
        ArrayList<ASTNode> result = new ArrayList<ASTNode>();
        if (!this.fIsNewContext) {
            return result;
        }
        IVariableBinding[] reads = this.getReads((ASTNode[])selectedNodes, maxVariableId);
        int i = 0;
        while (i < reads.length) {
            ASTNode readDecl;
            IVariableBinding read = reads[i];
            if (!read.isField() && (readDecl = this.getRootNode().findDeclaringNode((IBinding)read)) instanceof VariableDeclaration) {
                result.add(readDecl);
            }
            ++i;
        }
        return result;
    }

    protected List getVariableDeclarationsAccessedAfter(ASTNode startNode, int maxVariableId) {
        List statements;
        SwitchStatement block;
        if (startNode.getLocationInParent() == SwitchStatement.STATEMENTS_PROPERTY) {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.jdt.core.dom.SwitchStatement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            block = (SwitchStatement)ASTNodes.getParent(startNode, clazz);
            statements = block.statements();
        } else {
            Class<?> clazz = class$2;
            if (clazz == null) {
                try {
                    clazz = class$2 = Class.forName("org.eclipse.jdt.core.dom.Block");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            block = (Block)ASTNodes.getParent(startNode, clazz);
            statements = block.statements();
        }
        List bodyAfterSelection = statements.subList(statements.indexOf(startNode) + 1, statements.size());
        ArrayList<ASTNode> result = new ArrayList<ASTNode>();
        if (!bodyAfterSelection.isEmpty()) {
            IVariableBinding[] accesses = this.getAccesses(bodyAfterSelection.toArray(new ASTNode[bodyAfterSelection.size()]), maxVariableId);
            int i = 0;
            while (i < accesses.length) {
                ASTNode readDecl;
                IVariableBinding curVar = accesses[i];
                if (!curVar.isField() && (readDecl = ASTNodes.findDeclaration((IBinding)curVar, (ASTNode)this.getRootNode())) instanceof VariableDeclarationFragment) {
                    result.add(readDecl);
                }
                ++i;
            }
        }
        return result;
    }

    private IVariableBinding[] getReads(ASTNode[] region, int maxVariableId) {
        FlowContext flowContext = new FlowContext(0, maxVariableId);
        flowContext.setConsiderAccessMode(true);
        flowContext.setComputeMode(FlowContext.ARGUMENTS);
        FlowInfo argInfo = new InOutFlowAnalyzer(flowContext).perform(region);
        IVariableBinding[] reads = argInfo.get(flowContext, 38);
        return reads;
    }

    private IVariableBinding[] getAccesses(ASTNode[] region, int maxVariableId) {
        FlowContext flowContext = new FlowContext(0, maxVariableId);
        flowContext.setConsiderAccessMode(true);
        flowContext.setComputeMode(FlowContext.ARGUMENTS);
        FlowInfo argInfo = new InOutFlowAnalyzer(flowContext).perform(region);
        IVariableBinding[] varsAccessedAfter = argInfo.get(flowContext, 62);
        return varsAccessedAfter;
    }

    private final void moveToBlock(Statement[] toMove, List statements, List accessedAfter, List accessedInside, ASTRewrite rewrite) {
        int i = 0;
        while (i < toMove.length) {
            Statement node = toMove[i];
            if (node instanceof VariableDeclarationStatement) {
                VariableDeclarationStatement statement = (VariableDeclarationStatement)node;
                ListRewrite blockRewrite = this.getListRewrite((ASTNode)statement, rewrite);
                this.splitVariableDeclarationStatement(statement, this.createSplitSelectedOperator(accessedAfter, accessedInside, rewrite, statements, blockRewrite), rewrite);
                Iterator iter = statement.fragments().iterator();
                while (iter.hasNext()) {
                    accessedInside.remove(iter.next());
                }
            } else {
                this.insertNodeAtEnd(rewrite, statements, (ASTNode)node);
            }
            ++i;
        }
        while (!accessedInside.isEmpty()) {
            VariableDeclaration variableDeclaration = (VariableDeclaration)accessedInside.get(0);
            if (variableDeclaration instanceof SingleVariableDeclaration) {
                if (ASTNodes.findModifierNode(16, ASTNodes.getModifiers(variableDeclaration)) == null) {
                    ModifierRewrite.create(rewrite, (ASTNode)variableDeclaration).setModifiers(16, 0, null);
                }
                accessedInside.remove(0);
                continue;
            }
            if (variableDeclaration.getParent() instanceof VariableDeclarationStatement) {
                VariableDeclarationStatement statement = (VariableDeclarationStatement)variableDeclaration.getParent();
                ListRewrite blockRewrite = this.getListRewrite((ASTNode)statement, rewrite);
                this.splitVariableDeclarationStatement(statement, this.createSplitUnselectedOperator(accessedInside, rewrite, blockRewrite), rewrite);
                Iterator iter = statement.fragments().iterator();
                while (iter.hasNext()) {
                    VariableDeclarationFragment fragment = (VariableDeclarationFragment)iter.next();
                    accessedInside.remove(fragment);
                }
                continue;
            }
            if (!(variableDeclaration.getParent() instanceof VariableDeclarationExpression)) continue;
            VariableDeclarationExpression expression = (VariableDeclarationExpression)variableDeclaration.getParent();
            VariableDeclarationRewrite.rewriteModifiers(expression, 16, 0, rewrite, null);
            Iterator iter = expression.fragments().iterator();
            while (iter.hasNext()) {
                VariableDeclarationFragment fragment = (VariableDeclarationFragment)iter.next();
                accessedInside.remove(fragment);
            }
        }
    }

    private void insertNodeAtEnd(ASTRewrite rewrite, List statements, ASTNode node) {
        statements.add(rewrite.createMoveTarget(node));
    }

    protected ISplitOperation createSplitUnselectedOperator(List accessedInside, ASTRewrite rewrite, ListRewrite blockRewrite) {
        return new SplitUnselectedOperator(accessedInside, blockRewrite, rewrite);
    }

    protected ISplitOperation createSplitSelectedOperator(List accessedAfter, List accessedInside, ASTRewrite rewrite, List statements, ListRewrite blockRewrite) {
        return new SplitSelectedOperator(accessedInside, accessedAfter, blockRewrite, rewrite, statements);
    }

    private void splitVariableDeclarationStatement(VariableDeclarationStatement statement, ISplitOperation splitOperator, ASTRewrite rewrite) {
        List fragments = statement.fragments();
        Iterator iter = fragments.iterator();
        VariableDeclarationFragment lastFragment = (VariableDeclarationFragment)iter.next();
        VariableDeclarationStatement lastStatement = statement;
        splitOperator.initializeStatement(lastStatement, lastFragment);
        ListRewrite fragmentsRewrite = null;
        while (iter.hasNext()) {
            VariableDeclarationFragment currentFragment = (VariableDeclarationFragment)iter.next();
            if (splitOperator.needsSplit(lastFragment, currentFragment)) {
                VariableDeclarationStatement newStatement = this.getAst().newVariableDeclarationStatement((VariableDeclarationFragment)rewrite.createMoveTarget((ASTNode)currentFragment));
                ListRewrite modifierRewrite = rewrite.getListRewrite((ASTNode)newStatement, VariableDeclarationStatement.MODIFIERS2_PROPERTY);
                Iterator iterator = statement.modifiers().iterator();
                while (iterator.hasNext()) {
                    modifierRewrite.insertLast(rewrite.createCopyTarget((ASTNode)iterator.next()), null);
                }
                newStatement.setType((Type)rewrite.createCopyTarget((ASTNode)statement.getType()));
                splitOperator.initializeStatement(newStatement, currentFragment);
                fragmentsRewrite = rewrite.getListRewrite((ASTNode)newStatement, VariableDeclarationStatement.FRAGMENTS_PROPERTY);
                lastStatement = newStatement;
            } else if (fragmentsRewrite != null) {
                ASTNode fragment0 = rewrite.createMoveTarget((ASTNode)currentFragment);
                fragmentsRewrite.insertLast(fragment0, null);
            }
            lastFragment = currentFragment;
        }
    }

    protected static void makeFinal(VariableDeclarationStatement statement, ASTRewrite rewrite) {
        VariableDeclaration fragment = (VariableDeclaration)statement.fragments().get(0);
        if (ASTNodes.findModifierNode(16, ASTNodes.getModifiers(fragment)) == null) {
            ModifierRewrite.create(rewrite, (ASTNode)statement).setModifiers(16, 0, null);
        }
    }

    private void qualifyThisExpressions(ASTNode node, final ASTRewrite rewrite, final ImportRewrite importRewrite, final ImportRewrite.ImportRewriteContext importRewriteContext) {
        node.accept((ASTVisitor)new GenericVisitor(){

            public boolean visit(ThisExpression thisExpr) {
                ITypeBinding typeBinding;
                if (thisExpr.getQualifier() == null && (typeBinding = thisExpr.resolveTypeBinding()) != null) {
                    String typeName = importRewrite.addImport(typeBinding.getTypeDeclaration(), importRewriteContext);
                    SimpleName simpleName = thisExpr.getAST().newSimpleName(typeName);
                    rewrite.set((ASTNode)thisExpr, (StructuralPropertyDescriptor)ThisExpression.QUALIFIER_PROPERTY, (Object)simpleName, null);
                }
                return super.visit(thisExpr);
            }
        });
    }

    protected static void splitOffInitializer(List statements, VariableDeclarationFragment fragment, ASTRewrite rewrite) {
        Expression initializer = fragment.getInitializer();
        if (initializer != null) {
            AST ast = rewrite.getAST();
            Assignment assignment = ast.newAssignment();
            assignment.setLeftHandSide((Expression)rewrite.createCopyTarget((ASTNode)fragment.getName()));
            assignment.setRightHandSide((Expression)rewrite.createMoveTarget((ASTNode)initializer));
            statements.add(ast.newExpressionStatement((Expression)assignment));
        }
    }

    private ListRewrite getListRewrite(ASTNode node, ASTRewrite rewrite) {
        if (node.getLocationInParent() == SwitchStatement.STATEMENTS_PROPERTY) {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.jdt.core.dom.SwitchStatement");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            ASTNode block = ASTNodes.getParent(node, clazz);
            return rewrite.getListRewrite(block, SwitchStatement.STATEMENTS_PROPERTY);
        }
        Class<?> clazz = class$2;
        if (clazz == null) {
            try {
                clazz = class$2 = Class.forName("org.eclipse.jdt.core.dom.Block");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ASTNode block = ASTNodes.getParent(node, clazz);
        return rewrite.getListRewrite(block, Block.STATEMENTS_PROPERTY);
    }

    protected final AST getAst() {
        return this.getRootNode().getAST();
    }

    protected final Statement[] getSelectedStatements() {
        return this.fSelectedStatements;
    }

    private CompilationUnit getRootNode() {
        if (this.fSelectedStatements.length > 0) {
            return (CompilationUnit)this.fSelectedStatements[0].getRoot();
        }
        return this.fRootNode;
    }

    protected static interface ISplitOperation {
        public boolean needsSplit(VariableDeclarationFragment var1, VariableDeclarationFragment var2);

        public void initializeStatement(VariableDeclarationStatement var1, VariableDeclarationFragment var2);
    }

    private static final class SplitSelectedOperator
    implements ISplitOperation {
        private List fAccessedInside;
        private List fStatements;
        private List fAccessedAfter;
        private ASTRewrite fRewrite;
        private ListRewrite fBlockRewrite;
        private VariableDeclarationStatement fLastStatement = null;

        public SplitSelectedOperator(List inside, List after, ListRewrite blockRewrite, ASTRewrite rewrite, List statements) {
            this.fAccessedInside = inside;
            this.fStatements = statements;
            this.fAccessedAfter = after;
            this.fRewrite = rewrite;
            this.fBlockRewrite = blockRewrite;
        }

        public boolean needsSplit(VariableDeclarationFragment last, VariableDeclarationFragment current) {
            return this.fAccessedInside.contains(last) != this.fAccessedInside.contains(current) || this.fAccessedAfter.contains(last) != this.fAccessedAfter.contains(current);
        }

        public void initializeStatement(VariableDeclarationStatement statement, VariableDeclarationFragment current) {
            if (this.fAccessedAfter.contains(current)) {
                if (this.fAccessedInside.contains(current)) {
                    SurroundWith.makeFinal(statement, this.fRewrite);
                }
                this.handleInitializer(current);
                if (this.fLastStatement != null) {
                    this.fBlockRewrite.insertAfter((ASTNode)statement, (ASTNode)this.fLastStatement, null);
                }
                this.fLastStatement = statement;
            } else if (this.fLastStatement != null) {
                this.handleNewStatement((Statement)statement);
            } else {
                this.handleStatement((Statement)statement);
                this.fLastStatement = statement;
            }
        }

        protected void handleStatement(Statement statement) {
            this.fStatements.add(this.fRewrite.createMoveTarget((ASTNode)statement));
        }

        protected void handleNewStatement(Statement statement) {
            this.fStatements.add(statement);
        }

        protected void handleInitializer(VariableDeclarationFragment fragment) {
            SurroundWith.splitOffInitializer(this.fStatements, fragment, this.fRewrite);
        }
    }

    private static final class SplitUnselectedOperator
    implements ISplitOperation {
        private List fAccessedInside;
        private ListRewrite fBlockRewrite;
        private ASTRewrite fRewrite;
        private VariableDeclarationStatement fLastStatement;

        private SplitUnselectedOperator(List accessedInside, ListRewrite blockRewrite, ASTRewrite rewrite) {
            this.fAccessedInside = accessedInside;
            this.fBlockRewrite = blockRewrite;
            this.fRewrite = rewrite;
            this.fLastStatement = null;
        }

        public boolean needsSplit(VariableDeclarationFragment last, VariableDeclarationFragment current) {
            return this.fAccessedInside.contains(last) ^ this.fAccessedInside.contains(current);
        }

        public void initializeStatement(VariableDeclarationStatement statement, VariableDeclarationFragment current) {
            if (this.fAccessedInside.contains(current)) {
                SurroundWith.makeFinal(statement, this.fRewrite);
            }
            if (this.fLastStatement != null) {
                this.fBlockRewrite.insertAfter((ASTNode)statement, (ASTNode)this.fLastStatement, null);
            }
            this.fLastStatement = statement;
        }
    }
}

