/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.text.java;

import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.JavaModelException;
import org.eclipse.jdt.internal.ui.JavaPlugin;
import org.eclipse.jdt.internal.ui.text.javadoc.JavadocContentAccess2;

public class ProposalInfo {
    private boolean fJavadocResolved = false;
    private String fJavadoc = null;
    protected IJavaElement fElement;

    public ProposalInfo(IMember member) {
        this.fElement = member;
    }

    protected ProposalInfo() {
        this.fElement = null;
    }

    public IJavaElement getJavaElement() throws JavaModelException {
        return this.fElement;
    }

    public final String getInfo(IProgressMonitor monitor) {
        if (!this.fJavadocResolved) {
            this.fJavadocResolved = true;
            this.fJavadoc = this.computeInfo(monitor);
        }
        return this.fJavadoc;
    }

    private String computeInfo(IProgressMonitor monitor) {
        try {
            IJavaElement javaElement = this.getJavaElement();
            if (javaElement instanceof IMember) {
                IMember member = (IMember)javaElement;
                return this.extractJavadoc(member, monitor);
            }
        }
        catch (JavaModelException e) {
            JavaPlugin.log(e);
        }
        return null;
    }

    private String extractJavadoc(IMember member, IProgressMonitor monitor) throws JavaModelException {
        if (member != null) {
            return JavadocContentAccess2.getHTMLContent(member, true, true);
        }
        return null;
    }
}

