/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.jdt.internal.ui.workingsets;

import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.IPath;
import org.eclipse.jdt.core.IJarEntryResource;
import org.eclipse.jdt.core.IJavaElement;
import org.eclipse.jdt.core.IJavaProject;
import org.eclipse.jdt.core.IMember;
import org.eclipse.jdt.core.IPackageFragmentRoot;
import org.eclipse.jdt.core.JavaCore;
import org.eclipse.jdt.internal.ui.packageview.ClassPathContainer;
import org.eclipse.jdt.internal.ui.packageview.PackageFragmentRootContainer;
import org.eclipse.jdt.internal.ui.viewsupport.JavaViewerFilter;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.ui.IWorkingSet;

public class WorkingSetFilter
extends JavaViewerFilter {
    private IWorkingSet fWorkingSet = null;
    private WorkingSetCompareEntry[] fCachedCompareEntries = null;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public IWorkingSet getWorkingSet() {
        return this.fWorkingSet;
    }

    public void setWorkingSet(IWorkingSet workingSet) {
        if (this.fWorkingSet != workingSet) {
            this.fWorkingSet = workingSet;
            this.notifyWorkingSetContentChange();
        }
    }

    protected void initFilter() {
        this.notifyWorkingSetContentChange();
    }

    public final void notifyWorkingSetContentChange() {
        if (this.fWorkingSet != null) {
            IAdaptable[] elements = this.fWorkingSet.getElements();
            this.fCachedCompareEntries = new WorkingSetCompareEntry[elements.length];
            int i = 0;
            while (i < elements.length) {
                this.fCachedCompareEntries[i] = new WorkingSetCompareEntry(elements[i]);
                ++i;
            }
        } else {
            this.fCachedCompareEntries = null;
        }
    }

    protected void freeFilter() {
        this.fCachedCompareEntries = null;
    }

    public boolean select(Viewer viewer, Object parentElement, Object element) {
        if (this.fWorkingSet == null || this.fWorkingSet.isAggregateWorkingSet() && this.fWorkingSet.isEmpty()) {
            return true;
        }
        if (element instanceof PackageFragmentRootContainer) {
            return this.isEnclosing((PackageFragmentRootContainer)element);
        }
        if (element instanceof IAdaptable) {
            return this.isEnclosing((IAdaptable)element);
        }
        return true;
    }

    public boolean isEnclosing(IAdaptable a) {
        WorkingSetCompareEntry curr = new WorkingSetCompareEntry(a);
        if (this.fCachedCompareEntries != null) {
            int i = 0;
            while (i < this.fCachedCompareEntries.length) {
                if (this.fCachedCompareEntries[i].contains(curr)) {
                    return true;
                }
                ++i;
            }
            return false;
        }
        if (this.fWorkingSet != null) {
            IAdaptable[] elements = this.fWorkingSet.getElements();
            int i = 0;
            while (i < elements.length) {
                if (new WorkingSetCompareEntry(elements[i]).contains(curr)) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    private boolean isEnclosing(PackageFragmentRootContainer container) {
        IAdaptable[] roots = container.getChildren();
        int i = 0;
        while (i < roots.length) {
            if (this.isEnclosing(roots[i])) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static class WorkingSetCompareEntry {
        private IPath fResourcePath;
        private IJavaElement fJavaElement;

        public WorkingSetCompareEntry(IAdaptable a) {
            if (a instanceof IJavaElement) {
                this.init((IJavaElement)a);
            } else if (a instanceof IResource) {
                this.init((IResource)a);
            } else if (a instanceof ClassPathContainer.RequiredProjectWrapper) {
                ClassPathContainer.RequiredProjectWrapper wrapper = (ClassPathContainer.RequiredProjectWrapper)a;
                IJavaProject proj = wrapper.getParentClassPathContainer().getJavaProject();
                IFile fakeInternal = proj.getProject().getFile(String.valueOf(wrapper.getProject().getElementName()) + "-fake-jar.jar");
                this.init((IJavaElement)proj.getPackageFragmentRoot((IResource)fakeInternal));
            } else if (a instanceof IJarEntryResource) {
                this.init((IJarEntryResource)a);
            } else {
                IJavaElement je;
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("org.eclipse.jdt.core.IJavaElement");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                if ((je = (IJavaElement)a.getAdapter((Class)clazz)) != null) {
                    this.init(je);
                } else {
                    IResource resource;
                    Class<?> clazz2 = class$1;
                    if (clazz2 == null) {
                        try {
                            clazz2 = class$1 = Class.forName("org.eclipse.core.resources.IResource");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    if ((resource = (IResource)a.getAdapter((Class)clazz2)) != null) {
                        this.init(resource);
                    } else {
                        this.fResourcePath = null;
                        this.fJavaElement = null;
                    }
                }
            }
        }

        private void init(IResource resource) {
            this.fJavaElement = JavaCore.create((IResource)resource);
            this.fResourcePath = resource.getFullPath();
        }

        private void init(IJavaElement curr) {
            this.fJavaElement = curr;
            this.fResourcePath = curr.getPath();
        }

        private void init(IJarEntryResource jarEntryResource) {
            Object parent = jarEntryResource.getParent();
            while (parent instanceof IJarEntryResource) {
                parent = ((IJarEntryResource)parent).getParent();
            }
            this.fJavaElement = (IJavaElement)parent;
            this.fResourcePath = null;
        }

        public boolean contains(WorkingSetCompareEntry element) {
            IPath other;
            if (this.fJavaElement != null && element.fJavaElement != null) {
                IPackageFragmentRoot pkgRoot;
                IJavaElement other2 = element.fJavaElement;
                if (this.fJavaElement.getElementType() == 2 && (pkgRoot = (IPackageFragmentRoot)other2.getAncestor(3)) != null && pkgRoot.isExternal() && ((IJavaProject)this.fJavaElement).isOnClasspath(other2)) {
                    return true;
                }
                return this.isAncestor(other2, this.fJavaElement) || this.isAncestor(this.fJavaElement, other2) && element.fResourcePath != null;
            }
            return this.fResourcePath != null && element.fResourcePath != null && ((other = element.fResourcePath).isPrefixOf(this.fResourcePath) || this.fResourcePath.isPrefixOf(other));
        }

        /*
         * Unable to fully structure code
         */
        private boolean isAncestor(IJavaElement elem, IJavaElement parent) {
            anc = elem.getAncestor(parent.getElementType());
            if (!parent.equals(anc)) ** GOTO lbl6
            return true;
lbl-1000:
            // 1 sources

            {
                if (!parent.equals(anc = anc.getParent().getAncestor(parent.getElementType()))) continue;
                return true;
lbl6:
                // 2 sources

                ** while (anc instanceof IMember)
            }
lbl7:
            // 1 sources

            return false;
        }
    }
}

