/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.wst.common.componentcore.internal.flat;

import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.wst.common.componentcore.internal.flat.ChildModuleReference;
import org.eclipse.wst.common.componentcore.internal.flat.FlatFile;
import org.eclipse.wst.common.componentcore.internal.flat.FlatResource;
import org.eclipse.wst.common.componentcore.internal.flat.IChildModuleReference;
import org.eclipse.wst.common.componentcore.internal.flat.IFlatFile;
import org.eclipse.wst.common.componentcore.internal.flat.IFlatFolder;
import org.eclipse.wst.common.componentcore.internal.flat.IFlatResource;
import org.eclipse.wst.common.componentcore.internal.flat.IFlatVirtualComponent;
import org.eclipse.wst.common.componentcore.internal.flat.IFlattenParticipant;
import org.eclipse.wst.common.componentcore.internal.flat.VirtualComponentFlattenUtility;
import org.eclipse.wst.common.componentcore.resources.IVirtualComponent;
import org.eclipse.wst.common.componentcore.resources.IVirtualFolder;
import org.eclipse.wst.common.componentcore.resources.IVirtualReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FlatVirtualComponent
implements IFlatVirtualComponent,
VirtualComponentFlattenUtility.ShouldIncludeUtilityCallback {
    private FlatComponentTaskModel dataModel;
    private IVirtualComponent component;
    private IFlattenParticipant[] participants;
    private List<IFlatResource> members = null;
    private List<IChildModuleReference> children = null;

    public FlatVirtualComponent(IVirtualComponent component) {
        this(component, new FlatComponentTaskModel());
    }

    public FlatVirtualComponent(IVirtualComponent component, FlatComponentTaskModel dataModel) {
        this.component = component;
        this.dataModel = dataModel;
        this.participants = this.setParticipants();
        dataModel.put("org.eclipse.wst.common.componentcore.export.exportModel", this);
    }

    protected IFlattenParticipant[] setParticipants() {
        Object o = this.dataModel.get("org.eclipse.wst.common.componentcore.export.participantList");
        if (o != null) {
            if (o instanceof IFlattenParticipant) {
                return new IFlattenParticipant[]{(IFlattenParticipant)o};
            }
            if (o instanceof IFlattenParticipant[]) {
                return (IFlattenParticipant[])o;
            }
            if (o instanceof List) {
                List l = (List)o;
                return l.toArray(new IFlattenParticipant[l.size()]);
            }
        }
        return new IFlattenParticipant[0];
    }

    @Override
    public IFlatResource[] fetchResources() throws CoreException {
        if (this.members == null) {
            this.cacheResources();
        }
        return this.members.toArray(new FlatResource[this.members.size()]);
    }

    @Override
    public IChildModuleReference[] getChildModules() throws CoreException {
        if (this.members == null) {
            this.cacheResources();
        }
        return this.children.toArray(new ChildModuleReference[this.children.size()]);
    }

    protected void cacheResources() throws CoreException {
        this.runInitializations();
        if (this.canOptimize()) {
            this.optimize(this.members, this.children);
        } else {
            this.treeWalk();
            this.runFinalizations(this.members);
        }
    }

    protected void runInitializations() {
        this.members = new ArrayList<IFlatResource>();
        this.children = new ArrayList<IChildModuleReference>();
        int i = 0;
        while (i < this.participants.length) {
            this.participants[i].initialize(this.component, this.dataModel, this.members);
            ++i;
        }
    }

    protected boolean canOptimize() {
        int i = 0;
        while (i < this.participants.length) {
            if (this.participants[i].canOptimize(this.component, this.dataModel)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void optimize(List<IFlatResource> resources, List<IChildModuleReference> children) {
        int i = 0;
        while (i < this.participants.length) {
            if (this.participants[i].canOptimize(this.component, this.dataModel)) {
                this.participants[i].optimize(this.component, this.dataModel, resources, children);
                return;
            }
            ++i;
        }
    }

    protected void runFinalizations(List<IFlatResource> resources) {
        int i = 0;
        while (i < this.participants.length) {
            this.participants[i].finalize(this.component, this.dataModel, resources);
            ++i;
        }
    }

    protected void treeWalk() throws CoreException {
        if (this.component != null) {
            VirtualComponentFlattenUtility util = new VirtualComponentFlattenUtility(this.members, this);
            IVirtualFolder vFolder = this.component.getRootFolder();
            util.addMembers(this.component, vFolder, (IPath)Path.EMPTY);
            this.addConsumedReferences(util, this.component, (IPath)new Path(""));
            this.addUsedReferences(util, this.component, (IPath)new Path(""));
        }
    }

    protected void addConsumedReferences(VirtualComponentFlattenUtility util, IVirtualComponent vc, IPath root) throws CoreException {
        new ArrayList();
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("REQUESTED_REFERENCE_TYPE", "FLATTENABLE_REFERENCES");
        IVirtualReference[] refComponents = vc.getReferences(options);
        int i = 0;
        while (i < refComponents.length) {
            IVirtualComponent consumedComponent;
            IVirtualReference reference = refComponents[i];
            if (reference != null && reference.getDependencyType() == 1 && (consumedComponent = reference.getReferencedComponent()).getRootFolder() != null) {
                IVirtualFolder vFolder = consumedComponent.getRootFolder();
                util.addMembers(consumedComponent, vFolder, root.append(reference.getRuntimePath().makeRelative()));
                this.addConsumedReferences(util, consumedComponent, root.append(reference.getRuntimePath().makeRelative()));
                this.addUsedReferences(util, consumedComponent, root.append(reference.getRuntimePath().makeRelative()));
            }
            ++i;
        }
    }

    @Override
    public boolean shouldAddComponentFile(IVirtualComponent current, IFlatFile file) {
        int i = 0;
        while (i < this.participants.length) {
            if (this.participants[i].isChildModule(this.component, this.dataModel, file)) {
                ChildModuleReference child = new ChildModuleReference(current.getProject(), file);
                this.children.add(child);
                return false;
            }
            if (!this.participants[i].shouldAddExportableFile(this.component, current, this.dataModel, file)) {
                return false;
            }
            ++i;
        }
        return true;
    }

    protected void addUsedReferences(VirtualComponentFlattenUtility util, IVirtualComponent vc, IPath root) throws CoreException {
        HashMap<String, Object> options = new HashMap<String, Object>();
        options.put("REQUESTED_REFERENCE_TYPE", "FLATTENABLE_REFERENCES");
        IVirtualReference[] allReferences = vc.getReferences(options);
        int i = 0;
        while (i < allReferences.length) {
            IVirtualReference reference = allReferences[i];
            reference.getReferencedComponent();
            if (reference.getDependencyType() == 0 && !this.shouldIgnoreReference(reference)) {
                if (!this.isChildModule(reference)) {
                    this.addNonChildUsedReference(util, vc, reference, root.append(reference.getRuntimePath()));
                } else {
                    ChildModuleReference cm = new ChildModuleReference(reference, root);
                    ArrayList<IChildModuleReference> duplicates = new ArrayList<IChildModuleReference>();
                    for (IChildModuleReference tmp : this.children) {
                        if (!tmp.getRelativeURI().equals((Object)cm.getRelativeURI())) continue;
                        duplicates.add(tmp);
                    }
                    this.children.removeAll(duplicates);
                    this.children.add(cm);
                }
            }
            ++i;
        }
    }

    protected boolean isChildModule(IVirtualReference referencedComponent) {
        int i = 0;
        while (i < this.participants.length) {
            if (this.participants[i].isChildModule(this.component, referencedComponent, this.dataModel)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected boolean shouldIgnoreReference(IVirtualReference referencedComponent) {
        int i = 0;
        while (i < this.participants.length) {
            if (this.participants[i].shouldIgnoreReference(this.component, referencedComponent, this.dataModel)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    protected void addNonChildUsedReference(VirtualComponentFlattenUtility util, IVirtualComponent parent, IVirtualReference reference, IPath runtimePath) throws CoreException {
        if (reference.getReferencedComponent().isBinary()) {
            this.handleNonChildUsedBinaryReference(util, parent, reference, runtimePath);
        } else {
            util.addMembers(reference.getReferencedComponent(), reference.getReferencedComponent().getRootFolder(), runtimePath.append(reference.getArchiveName()));
        }
    }

    protected void handleNonChildUsedBinaryReference(VirtualComponentFlattenUtility util, IVirtualComponent parent, IVirtualReference reference, IPath runtimePath) throws CoreException {
        String archiveName2 = reference.getArchiveName();
        String archiveName = new Path(archiveName2).lastSegment();
        IVirtualComponent virtualComp = reference.getReferencedComponent();
        FlatFile mf = null;
        IFile ifile = (IFile)virtualComp.getAdapter(IFile.class);
        if (ifile != null) {
            String name = archiveName != null ? archiveName : ifile.getName();
            mf = new FlatFile(ifile, name, runtimePath.makeRelative());
        } else {
            File extFile = (File)virtualComp.getAdapter(File.class);
            if (extFile != null) {
                String name = archiveName != null ? archiveName : extFile.getName();
                mf = new FlatFile(extFile, name, runtimePath.makeRelative());
            }
        }
        if (mf != null) {
            IFlatResource moduleParent = VirtualComponentFlattenUtility.getExistingModuleResource(this.members, mf.getModuleRelativePath());
            if (moduleParent != null && moduleParent instanceof IFlatFolder) {
                IFlatResource[] mf_members = ((IFlatFolder)moduleParent).members();
                int i = 0;
                while (i < mf_members.length) {
                    if (mf_members[i].getName().equals(mf.getName())) {
                        return;
                    }
                    ++i;
                }
                VirtualComponentFlattenUtility.addMembersToModuleFolder((IFlatFolder)moduleParent, new FlatResource[]{mf});
            } else if (this.shouldAddComponentFile(virtualComp, mf)) {
                if (mf.getModuleRelativePath().isEmpty()) {
                    for (IFlatResource tmp : this.members) {
                        if (!tmp.getName().equals(mf.getName())) continue;
                        return;
                    }
                    this.members.add(mf);
                } else {
                    if (moduleParent == null) {
                        moduleParent = VirtualComponentFlattenUtility.ensureParentExists(this.members, mf.getModuleRelativePath(), (IContainer)parent.getRootFolder().getUnderlyingResource());
                    }
                    VirtualComponentFlattenUtility.addMembersToModuleFolder((IFlatFolder)moduleParent, new FlatResource[]{mf});
                }
            }
        }
    }

    public IVirtualComponent getComponent() {
        return this.component;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class FlatComponentTaskModel
    extends HashMap<Object, Object> {
        private static final long serialVersionUID = 1L;
    }
}

