/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.team.internal.ccvs.ui;

import org.eclipse.core.resources.IResource;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogSettings;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.team.internal.ccvs.ui.CVSUIMessages;
import org.eclipse.team.internal.ccvs.ui.CVSUIPlugin;
import org.eclipse.team.internal.ccvs.ui.CommitCommentArea;
import org.eclipse.team.internal.ui.dialogs.DetailsDialog;

public class ReleaseCommentDialog
extends DetailsDialog {
    CommitCommentArea commitCommentArea;
    private IDialogSettings settings;
    private static final int DEFAULT_WIDTH_IN_CHARS = 80;
    private static final String HEIGHT_KEY = "width-key";
    private static final String WIDTH_KEY = "height-key";

    public ReleaseCommentDialog(Shell parentShell, IResource[] resourcesToCommit, String proposedComment, int depth) {
        super(parentShell, CVSUIMessages.ReleaseCommentDialog_title);
        int shellStyle = this.getShellStyle();
        this.setShellStyle(shellStyle | 0x10 | 0x400);
        this.commitCommentArea = new CommitCommentArea();
        if (resourcesToCommit.length > 0) {
            this.commitCommentArea.setProject(resourcesToCommit[0].getProject());
        }
        this.commitCommentArea.setProposedComment(proposedComment);
        IDialogSettings workbenchSettings = CVSUIPlugin.getPlugin().getDialogSettings();
        this.settings = workbenchSettings.getSection("ReleaseCommentDialog");
        if (this.settings == null) {
            this.settings = workbenchSettings.addNewSection("ReleaseCommentDialog");
        }
    }

    protected boolean includeDetailsButton() {
        return false;
    }

    protected boolean includeErrorMessage() {
        return false;
    }

    protected void createMainDialogArea(Composite parent) {
        this.getShell().setText(CVSUIMessages.ReleaseCommentDialog_title);
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(1808));
        this.commitCommentArea.createArea(composite);
        this.commitCommentArea.addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if (event.getProperty() == "OkRequested") {
                    ReleaseCommentDialog.this.okPressed();
                }
            }
        });
        Dialog.applyDialogFont((Control)parent);
    }

    protected String getHelpContextId() {
        return "org.eclipse.team.cvs.ui.release_comment_dialog_context";
    }

    protected Point getInitialSize() {
        try {
            return new Point(this.settings.getInt(WIDTH_KEY), this.settings.getInt(HEIGHT_KEY));
        }
        catch (NumberFormatException numberFormatException) {
            Point size = super.getInitialSize();
            size.x = this.convertWidthInCharsToPixels(80);
            size.y += this.convertHeightInCharsToPixels(8);
            return size;
        }
    }

    public String getComment() {
        return this.commitCommentArea.getComment(true);
    }

    protected Composite createDropDownDialogArea(Composite parent) {
        return null;
    }

    protected void updateEnablements() {
    }

    public boolean close() {
        Rectangle bounds = this.getShell().getBounds();
        this.settings.put(HEIGHT_KEY, bounds.height);
        this.settings.put(WIDTH_KEY, bounds.width);
        return super.close();
    }

    protected Control createContents(Composite parent) {
        Control c = super.createContents(parent);
        this.commitCommentArea.setFocus();
        return c;
    }
}

