/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.core;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import org.eclipse.equinox.internal.p2.core.AgentLocation;
import org.eclipse.equinox.p2.core.IAgentLocation;
import org.eclipse.equinox.p2.core.IProvisioningAgent;
import org.eclipse.equinox.p2.core.spi.IAgentService;
import org.eclipse.equinox.p2.core.spi.IAgentServiceFactory;
import org.osgi.framework.BundleContext;
import org.osgi.framework.FrameworkUtil;
import org.osgi.framework.InvalidSyntaxException;
import org.osgi.framework.ServiceReference;
import org.osgi.framework.ServiceRegistration;
import org.osgi.util.tracker.ServiceTracker;
import org.osgi.util.tracker.ServiceTrackerCustomizer;

public class ProvisioningAgent
implements IProvisioningAgent,
ServiceTrackerCustomizer {
    private final Map<String, Object> agentServices = Collections.synchronizedMap(new HashMap());
    private BundleContext context;
    private volatile boolean stopped = false;
    private ServiceRegistration reg;
    private final Map<ServiceReference, ServiceTracker> trackers = Collections.synchronizedMap(new HashMap());

    public ProvisioningAgent() {
        this.registerService("org.eclipse.equinox.p2.installer.agent", this);
        this.registerService("org.eclipse.equinox.p2.installer.profile.id", "_SELF_");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object getService(String serviceName) {
        Map<String, Object> map = this.agentServices;
        synchronized (map) {
            ServiceTracker tracker;
            ServiceReference[] refs;
            Object service;
            block12: {
                IAgentServiceFactory factory;
                block11: {
                    block10: {
                        this.checkRunning();
                        service = this.agentServices.get(serviceName);
                        if (service != null) {
                            return service;
                        }
                        try {
                            refs = this.context.getServiceReferences(IAgentServiceFactory.SERVICE_NAME, "(p2.agent.servicename=" + serviceName + ')');
                        }
                        catch (InvalidSyntaxException e) {
                            e.printStackTrace();
                            return null;
                        }
                        if (refs != null && refs.length != 0) break block10;
                        return null;
                    }
                    tracker = new ServiceTracker(this.context, refs[0], (ServiceTrackerCustomizer)this);
                    tracker.open();
                    factory = (IAgentServiceFactory)tracker.getService();
                    if (factory != null) break block11;
                    tracker.close();
                    return null;
                }
                service = factory.createService(this);
                if (service != null) break block12;
                tracker.close();
                return null;
            }
            this.registerService(serviceName, service);
            this.trackers.put(refs[0], tracker);
            return service;
        }
    }

    private void checkRunning() {
        if (this.stopped) {
            throw new IllegalStateException("Attempt to access stopped agent: " + this);
        }
    }

    public void registerService(String serviceName, Object service) {
        this.checkRunning();
        this.agentServices.put(serviceName, service);
        if (service instanceof IAgentService) {
            ((IAgentService)service).start();
        }
    }

    public void setBundleContext(BundleContext context) {
        this.context = context;
    }

    public void setLocation(URI location) {
        IAgentLocation agentLocation = null;
        if (location == null) {
            ServiceReference ref = this.context.getServiceReference(IAgentLocation.SERVICE_NAME);
            if (ref != null) {
                agentLocation = (IAgentLocation)this.context.getService(ref);
                this.context.ungetService(ref);
            }
        } else {
            agentLocation = new AgentLocation(location);
        }
        this.registerService(IAgentLocation.SERVICE_NAME, agentLocation);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unregisterService(String serviceName, Object service) {
        Map<String, Object> map = this.agentServices;
        synchronized (map) {
            if (this.stopped) {
                return;
            }
            if (this.agentServices.get(serviceName) == service) {
                this.agentServices.remove(serviceName);
            }
        }
        if (service instanceof IAgentService) {
            ((IAgentService)service).stop();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        ArrayList<Object> toStop;
        Map<String, Object> map = this.agentServices;
        synchronized (map) {
            toStop = new ArrayList<Object>(this.agentServices.values());
        }
        Iterator iterator = toStop.iterator();
        while (iterator.hasNext()) {
            Object service = iterator.next();
            if (!(service instanceof IAgentService) || service == this) continue;
            ((IAgentService)service).stop();
        }
        this.stopped = true;
        map = this.trackers;
        synchronized (map) {
            Iterator<ServiceTracker> iterator2 = this.trackers.values().iterator();
            while (iterator2.hasNext()) {
                ServiceTracker t = iterator2.next();
                t.close();
            }
            this.trackers.clear();
        }
        if (this.reg != null) {
            this.reg.unregister();
            this.reg = null;
        }
    }

    public void setServiceRegistration(ServiceRegistration reg) {
        this.reg = reg;
    }

    public Object addingService(ServiceReference reference) {
        if (this.stopped) {
            return null;
        }
        return this.context.getService(reference);
    }

    public void modifiedService(ServiceReference reference, Object service) {
    }

    public void removedService(ServiceReference reference, Object factoryService) {
        if (this.stopped) {
            return;
        }
        String serviceName = (String)reference.getProperty("p2.agent.servicename");
        if (serviceName == null) {
            return;
        }
        Object registered = this.agentServices.get(serviceName);
        if (registered == null) {
            return;
        }
        if (FrameworkUtil.getBundle(registered.getClass()) == FrameworkUtil.getBundle(factoryService.getClass())) {
            this.unregisterService(serviceName, registered);
            ServiceTracker toRemove = this.trackers.remove(reference);
            if (toRemove != null) {
                toRemove.close();
            }
        }
    }
}

