/*
 * Decompiled with CFR 0.152.
 */
package edu.umd.cs.piccolo.util;

import edu.umd.cs.piccolo.PCamera;
import edu.umd.cs.piccolo.PNode;
import edu.umd.cs.piccolo.event.PInputEvent;
import edu.umd.cs.piccolo.event.PInputEventListener;
import edu.umd.cs.piccolo.util.PAffineTransform;
import edu.umd.cs.piccolo.util.PBounds;
import edu.umd.cs.piccolo.util.PStack;
import java.util.EventListener;
import java.util.HashMap;
import javax.swing.event.EventListenerList;
import org.eclipse.e4.tm.graphics.util.Dimension;
import org.eclipse.e4.tm.graphics.util.Point;
import org.eclipse.e4.tm.graphics.util.Rectangle;

public class PPickPath
implements PInputEventListener {
    public static PPickPath CURRENT_PICK_PATH;
    private static double[] PTS;
    private PStack nodeStack;
    private PStack transformStack;
    private PStack pickBoundsStack = new PStack();
    private PCamera topCamera;
    private PCamera bottomCamera;
    private HashMap excludedNodes;

    static {
        PTS = new double[4];
    }

    public PPickPath(PCamera aCamera, PBounds aScreenPickBounds) {
        this.topCamera = aCamera;
        this.nodeStack = new PStack();
        this.transformStack = new PStack();
        this.pickBoundsStack.push(aScreenPickBounds);
        CURRENT_PICK_PATH = this;
    }

    public PBounds getPickBounds() {
        return (PBounds)this.pickBoundsStack.peek();
    }

    public boolean acceptsNode(PNode node) {
        if (this.excludedNodes != null) {
            return !this.excludedNodes.containsKey(node);
        }
        return true;
    }

    public void pushNode(PNode aNode) {
        this.nodeStack.push(aNode);
    }

    public void popNode(PNode aNode) {
        this.nodeStack.pop();
    }

    public PNode getPickedNode() {
        return (PNode)this.nodeStack.peek();
    }

    public PNode nextPickedNode() {
        PNode picked = this.getPickedNode();
        if (picked == this.topCamera) {
            return null;
        }
        if (this.excludedNodes == null) {
            this.excludedNodes = new HashMap();
        }
        this.excludedNodes.put(picked, picked);
        Object screenPickBounds = this.pickBoundsStack.get(0);
        this.pickBoundsStack = new PStack();
        this.nodeStack = new PStack();
        this.transformStack = new PStack();
        this.pickBoundsStack = new PStack();
        this.pickBoundsStack.push(screenPickBounds);
        this.topCamera.fullPick(this);
        if (this.getNodeStackReference().size() == 0) {
            this.pushNode(this.topCamera);
            this.pushTransform(this.topCamera.getTransformReference(false));
        }
        return this.getPickedNode();
    }

    public PCamera getTopCamera() {
        return this.topCamera;
    }

    public PCamera getBottomCamera() {
        if (this.bottomCamera == null) {
            int i = this.nodeStack.size() - 1;
            while (i >= 0) {
                PNode each = (PNode)this.nodeStack.get(i);
                if (each instanceof PCamera) {
                    this.bottomCamera = (PCamera)each;
                    return this.bottomCamera;
                }
                --i;
            }
        }
        return this.bottomCamera;
    }

    public PStack getNodeStackReference() {
        return this.nodeStack;
    }

    public double getScale() {
        PPickPath.PTS[0] = 0.0;
        PPickPath.PTS[1] = 0.0;
        PPickPath.PTS[2] = 1.0;
        PPickPath.PTS[3] = 0.0;
        int count = this.transformStack.size();
        int i = 0;
        while (i < count) {
            PAffineTransform each = ((PTuple)this.transformStack.get((int)i)).transform;
            if (each != null) {
                each.transform(PTS, 0, PTS, 0, 2);
            }
            ++i;
        }
        return Point.distance(PTS[0], PTS[1], PTS[2], PTS[3]);
    }

    public void pushTransform(PAffineTransform aTransform) {
        this.transformStack.push(new PTuple(this.getPickedNode(), aTransform));
        if (aTransform != null) {
            Rectangle newPickBounds = (Rectangle)this.getPickBounds().clone();
            aTransform.inverseTransform(newPickBounds, newPickBounds);
            this.pickBoundsStack.push(newPickBounds);
        }
    }

    public void popTransform(PAffineTransform aTransform) {
        this.transformStack.pop();
        if (aTransform != null) {
            this.pickBoundsStack.pop();
        }
    }

    public PAffineTransform getPathTransformTo(PNode nodeOnPath) {
        PAffineTransform aTransform = new PAffineTransform();
        int count = this.transformStack.size();
        int i = 0;
        while (i < count) {
            PTuple each = (PTuple)this.transformStack.get(i);
            if (each.transform != null) {
                aTransform.concatenate(each.transform);
            }
            if (nodeOnPath == each.node) {
                return aTransform;
            }
            ++i;
        }
        throw new RuntimeException("Node could not be found on pick path");
    }

    public void processEvent(PInputEvent aEvent, int type) {
        aEvent.setPath(this);
        int i = this.nodeStack.size() - 1;
        while (i >= 0) {
            PNode each = (PNode)this.nodeStack.get(i);
            EventListenerList list = each.getListenerList();
            if (list != null) {
                EventListener[] listeners = list.getListeners(PInputEventListener.class);
                int j = 0;
                while (j < listeners.length) {
                    PInputEventListener listener = (PInputEventListener)listeners[j];
                    listener.processEvent(aEvent, type);
                    ++j;
                }
            }
            --i;
        }
    }

    public Point canvasToLocal(Point canvasPoint, PNode nodeOnPath) {
        try {
            return this.getPathTransformTo(nodeOnPath).inverseTransform(canvasPoint, canvasPoint);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public Dimension canvasToLocal(Dimension canvasDimension, PNode nodeOnPath) {
        return this.getPathTransformTo(nodeOnPath).inverseTransform(canvasDimension, canvasDimension);
    }

    public Rectangle canvasToLocal(Rectangle canvasRectangle, PNode nodeOnPath) {
        return this.getPathTransformTo(nodeOnPath).inverseTransform(canvasRectangle, canvasRectangle);
    }

    private static class PTuple {
        public PNode node;
        public PAffineTransform transform;

        public PTuple(PNode n, PAffineTransform t) {
            this.node = n;
            this.transform = t;
        }
    }
}

