/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.equinox.internal.p2.ui.model;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import org.eclipse.core.runtime.URIUtil;
import org.eclipse.equinox.internal.p2.ui.ElementWrapper;
import org.eclipse.equinox.internal.p2.ui.ProvUI;
import org.eclipse.equinox.internal.p2.ui.ProvUIMessages;
import org.eclipse.equinox.internal.p2.ui.model.EmptyElementExplanation;
import org.eclipse.equinox.internal.p2.ui.model.MetadataRepositories;
import org.eclipse.equinox.internal.p2.ui.model.MetadataRepositoryElement;
import org.eclipse.equinox.internal.p2.ui.model.QueriedElement;
import org.eclipse.equinox.internal.p2.ui.query.IUViewQueryContext;
import org.eclipse.equinox.p2.operations.RepositoryTracker;
import org.eclipse.equinox.p2.query.Collector;
import org.eclipse.equinox.p2.query.IQueryable;
import org.eclipse.equinox.p2.ui.ProvisioningUI;
import org.eclipse.osgi.util.NLS;

/*
 * This class specifies class file version 48.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class QueriedElementWrapper
extends ElementWrapper {
    protected IQueryable<?> queryable;
    protected Object parent;
    protected String emptyExplanationString;
    protected int emptyExplanationSeverity;
    protected String emptyExplanationDescription;

    public QueriedElementWrapper(IQueryable<?> queryable, Object parent) {
        this.queryable = queryable;
        this.parent = parent;
    }

    @Override
    protected Object wrap(Object item) {
        QueriedElement element;
        if (item instanceof QueriedElement && !(element = (QueriedElement)item).knowsQueryable()) {
            element.setQueryable(this.queryable);
        }
        return item;
    }

    @Override
    public Collection<?> getElements(Collector<?> collector) {
        this.emptyExplanationString = null;
        this.emptyExplanationSeverity = 1;
        this.emptyExplanationDescription = null;
        if (collector.isEmpty()) {
            MetadataRepositoryElement repo;
            RepositoryTracker manipulator;
            if (this.parent instanceof MetadataRepositoryElement && (manipulator = ProvisioningUI.getDefaultUI().getRepositoryTracker()).hasNotFoundStatusBeenReported((repo = (MetadataRepositoryElement)this.parent).getLocation())) {
                return this.emptyExplanation(4, NLS.bind((String)ProvUIMessages.QueriedElementWrapper_SiteNotFound, (Object)URIUtil.toUnencodedString((URI)repo.getLocation())), "");
            }
            if (this.parent instanceof QueriedElement) {
                QueriedElement element = (QueriedElement)this.parent;
                IUViewQueryContext context = element.getQueryContext();
                if (context == null) {
                    context = ProvUI.getQueryContext(element.getPolicy());
                }
                if (this.parent instanceof MetadataRepositoryElement || this.parent instanceof MetadataRepositories) {
                    if (context != null && context.getViewType() == 1 && context.getUseCategories()) {
                        return this.emptyExplanation(1, ProvUIMessages.QueriedElementWrapper_NoCategorizedItemsExplanation, context.getUsingCategoriesDescription());
                    }
                    return this.emptyExplanation(1, ProvUIMessages.QueriedElementWrapper_NoItemsExplanation, null);
                }
            }
            return Collections.EMPTY_LIST;
        }
        Collection<?> elements = super.getElements(collector);
        if (elements.isEmpty()) {
            if (this.emptyExplanationString != null) {
                return this.emptyExplanation(this.emptyExplanationSeverity, this.emptyExplanationString, this.emptyExplanationDescription);
            }
            return this.emptyExplanation(this.emptyExplanationSeverity, ProvUIMessages.QueriedElementWrapper_NoItemsExplanation, null);
        }
        return elements;
    }

    Collection<?> emptyExplanation(int severity, String explanationString, String explanationDescription) {
        ArrayList<EmptyElementExplanation> collection = new ArrayList<EmptyElementExplanation>(1);
        collection.add(new EmptyElementExplanation(this.parent, severity, explanationString, explanationDescription));
        return collection;
    }
}

